/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.upgrade;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class SrmSupplierLifeCycleUpgradeService
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(SrmSupplierLifeCycleUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            boolean enablesupplierlifecycle = false;
            result.setLog("begin to update enablesupplierlifecycle configuration!\n");
            DBRoute dbRoute = new DBRoute(dbKey);
            try (DataSet ds = DB.queryDataSet((String)"SrmSupplierLifeCycleUpgradeService.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)"select fid from t_pur_regsupplier", null);){
                if (ds == null || ds.isEmpty()) {
                    enablesupplierlifecycle = true;
                }
            }
            if (enablesupplierlifecycle) {
                this.enablesupplierlifecycle();
            }
            this.updateEnterpriseBlack();
            this.updateSrmSupplierStatus();
            result.setLog(pProcessInfo.append("end to update enablesupplierlifecycle configuration\n!\n").toString());
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public void enablesupplierlifecycle() {
        this.enablesupplierlifecycle("pur");
        this.enableSrmAssignRoleToRootOrg("pur");
    }

    private void enablesupplierlifecycle(String dbKey) {
        DBRoute purdbRoute = new DBRoute(dbKey);
        String updatesql = "update t_pur_updateparamconfig set fparamvalue ='Y' where  fparamkey='enablesupplierlifecycle' ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        logger.info("\u542f\u7528\u4f9b\u5e94\u5546\u751f\u547d\u5468\u671f\u7ba1\u7406\u53c2\u6570\u6210\u529f\uff1aenablesupplierlifecycle.fparamvalue=Y");
    }

    private void enableSrmAssignRoleToRootOrg(String dbKey) {
        DBRoute purdbRoute = new DBRoute(dbKey);
        String updatesql = "update t_pur_updateparamconfig set fparamvalue ='Y' where  fparamkey='srmassignroletorootorg' ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        logger.info("\u542f\u7528\u5206\u914d\u89d2\u8272\u5230\u6839\u7ec4\u7ec7\u53c2\u6570\u6210\u529f\uff1asrmassignroletorootorg.fparamvalue=Y");
    }

    private void updateEnterpriseBlack() {
        DBRoute purdbRoute = new DBRoute("pur");
        String updatesql = "update t_pur_black_company set fblacklistdeadline = ?  ";
        ArrayList<Date> param = new ArrayList<Date>(10);
        Date date = new Date(4102410094727L);
        param.add(date);
        DB.execute((DBRoute)purdbRoute, (String)updatesql, (Object[])param.toArray(new Object[param.size()]));
        logger.info("\u5347\u7ea7\u5386\u53f2\u9ed1\u540d\u5355\u6709\u6548\u671f\uff1a2099-12-31");
    }

    private void updateSrmSupplierStatus() {
        DBRoute purdbRoute = new DBRoute("pur");
        String updatesql = "update t_pur_regsupplier set fsupplierstatus = 880835462149703680 where fauditstatus = 'Z' ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        updatesql = "update t_pur_regsupplier set fsupplierstatus = 988406399367190528 where fauditstatus in ('A','B','D') ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        updatesql = "update t_pur_regsupplier set fsupplierstatus = 880835238786237440 where fauditstatus in ('C','E','F','G','H','I','J','K','L','M') ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        updatesql = "update t_pur_regsupplier set fsupplierstatus = 880834131733251072 where fenable = '0'  ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        updatesql = "update t_pur_regsupplier set fsupplierstatus = 880835708355347456 where fenable = '0' and fsocietycreditcode in (select fnumber from t_pur_black_company where fauditstatus = 'C') ";
        DB.execute((DBRoute)purdbRoute, (String)updatesql);
        logger.info("\u5347\u7ea7\u5386\u53f2\u4f9b\u5e94\u5546\u72b6\u6001\u6210\u529f");
    }
}

