/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.upgrade.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.DBServiceHelper;
import kd.scm.srm.opplugin.upgrade.NodeUpgradeService;

public class AptitudeExamUpgradeService
implements NodeUpgradeService {
    @Override
    public void nodeDataUpgrade() {
        DBRoute dbRoute = new DBRoute("pur");
        DB.execute((DBRoute)dbRoute, (String)" delete from t_srm_aptitude_nodeentry where 1=1 ");
        Map<Long, Map<String, Long>> typeNodeListMap = this.getTypeNodeListMap(dbRoute);
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct tp.fid from t_pur_aptitude tp,t_pur_entertype te");
        sql.append(" where tp.fentertypeid = te.fid order by tp.fid desc ");
        try (DataSet dataSet = DB.queryDataSet((String)"SupapproveUpgradeService.upgradeNodeInfo", (DBRoute)dbRoute, (String)sql.toString(), null);){
            ArrayList idList = new ArrayList();
            dataSet.forEach(row -> idList.add(row.getLong("fid")));
            int count = idList.size();
            int totalPages = count / 500;
            if (count % 500 != 0) {
                ++totalPages;
            }
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                List<Object[]> params;
                List<Long> subIdList = (pageIndex + 1) * 500 > idList.size() ? idList.subList(pageIndex * 500, idList.size()) : idList.subList(pageIndex * 500, (pageIndex + 1) * 500);
                if (subIdList == null || subIdList.isEmpty() || (params = this.selectData(subIdList, dbRoute, typeNodeListMap)) == null || params.isEmpty() || params == null || params.isEmpty()) continue;
                this.insertData(dbRoute, params);
            }
        }
    }

    private List<Object[]> selectData(List<Long> subIdList, DBRoute dbRoute, Map<Long, Map<String, Long>> typeNodeListMap) {
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(subIdList.size() * 5);
        Map<String, Map<Long, Date>> objectNodeMap = this.getObjectNodeMap(subIdList, dbRoute);
        StringBuilder sb = new StringBuilder();
        sb.append(" select distinct tp.fid,tp.fbillno,tp.fauditstatus,tp.fexamresult,tp.fentertypeid,tp.fhasscene,tp.fhassample,");
        sb.append(" tp.fhasmaterial,tp.fhasapprove from t_pur_aptitude tp,t_pur_entertype te where tp.fentertypeid = te.fid");
        sb.append(" and tp.fid in (").append(StringUtils.join((Object[])subIdList.toArray(new Long[subIdList.size()]), (char)',')).append(')');
        try (DataSet dataSet = DB.queryDataSet((String)"AptitudeExamUpgradeService.selectData", (DBRoute)dbRoute, (String)sb.toString(), null);){
            dataSet.forEach(row -> {
                List<Object[]> tempList = this.getInsertData((Row)row, typeNodeListMap, objectNodeMap);
                if (tempList != null && !tempList.isEmpty()) {
                    insertList.addAll(tempList);
                }
            });
        }
        return insertList;
    }

    private Map<String, Map<Long, Date>> getObjectNodeMap(List<Long> subIdList, DBRoute dbRoute) {
        Map<String, String> nodetableMap = this.getNodeTableMap();
        HashMap<String, Map<Long, Date>> objectNodeMap = new HashMap<String, Map<Long, Date>>(nodetableMap.size());
        for (Map.Entry<String, String> entry : nodetableMap.entrySet()) {
            StringBuilder sql = new StringBuilder();
            sql.append("select faptitudenoid,t.fid,t.fbilldate from ").append(entry.getValue());
            sql.append(" t where t.faptitudenoid  in (").append(StringUtils.join((Object[])subIdList.toArray(new Long[subIdList.size()]), (char)',')).append(')');
            sql.append("  order by t.fbilldate asc");
            Map<Long, Date> nodeMap = this.getObjectNodeMap(subIdList.size(), dbRoute, sql.toString());
            if (nodeMap == null || nodeMap.isEmpty()) continue;
            objectNodeMap.put(entry.getKey(), nodeMap);
        }
        return objectNodeMap;
    }

    private Map<Long, Date> getObjectNodeMap(int size, DBRoute dbRoute, String sql) {
        HashMap<Long, Date> nodeMap = new HashMap<Long, Date>(size);
        try (DataSet dataSet = DB.queryDataSet((String)"AptitudeExamUpgradeService.getObjectNodeMap", (DBRoute)dbRoute, (String)sql, null);){
            dataSet.forEach(row -> {
                Long aptitudeid = row.getLong("faptitudenoid");
                Date billdate = row.getDate("fbilldate");
                nodeMap.put(aptitudeid, billdate);
            });
        }
        return nodeMap;
    }

    private List<Object[]> getInsertData(Row row, Map<Long, Map<String, Long>> typeNodeListMap, Map<String, Map<Long, Date>> objectNodeMap) {
        ArrayList<Object[]> params = new ArrayList<Object[]>(3);
        Long typeId = row.getLong("fentertypeid");
        Long aptitudeid = row.getLong("fid");
        boolean hasscene = row.getBoolean("fhasscene");
        boolean hassample = row.getBoolean("fhassample");
        boolean hasmaterial = row.getBoolean("fhasmaterial");
        boolean hasapprove = row.getBoolean("fhasapprove");
        if (typeNodeListMap.containsKey(typeId)) {
            String nodestatus;
            int rowseq = 1;
            Map<String, Long> nodeMap = typeNodeListMap.get(typeId);
            Long accessnodeId = nodeMap.get("srm_sceneexam");
            if (accessnodeId != null) {
                nodestatus = " ";
                if (hasscene) {
                    nodestatus = "1";
                }
                this.addNodeInfo(aptitudeid, accessnodeId, nodestatus, rowseq++, objectNodeMap.get("srm_sceneexam"), params);
            }
            if ((accessnodeId = nodeMap.get("srm_sampleexam")) != null) {
                nodestatus = " ";
                if (hassample) {
                    nodestatus = "1";
                }
                this.addNodeInfo(aptitudeid, accessnodeId, nodestatus, rowseq++, objectNodeMap.get("srm_sampleexam"), params);
            }
            if ((accessnodeId = nodeMap.get("srm_materialexam")) != null) {
                nodestatus = " ";
                if (hasmaterial) {
                    nodestatus = "1";
                }
                this.addNodeInfo(aptitudeid, accessnodeId, nodestatus, rowseq++, objectNodeMap.get("srm_materialexam"), params);
            }
            if ((accessnodeId = nodeMap.get("srm_supapprove")) != null) {
                nodestatus = " ";
                if (hasapprove) {
                    nodestatus = "1";
                }
                this.addNodeInfo(aptitudeid, accessnodeId, nodestatus, rowseq++, objectNodeMap.get("srm_supapprove"), params);
            }
        }
        return params;
    }

    private void addNodeInfo(Long id, Long accessnodeId, String nodestatus, int rowseq, Map<Long, Date> apptitudeNodeMap, List<Object[]> params) {
        Long entryid = DBServiceHelper.genGlobalLongId();
        Date billdate = null;
        if (apptitudeNodeMap != null) {
            billdate = apptitudeNodeMap.get(id);
        }
        Object[] param = new Object[]{id, entryid, rowseq++, accessnodeId, nodestatus, billdate};
        params.add(param);
    }

    private Map<String, String> getTypeNumber() {
        HashMap<String, String> nodeMap = new HashMap<String, String>(4);
        nodeMap.put("hasscene", "srm_sceneexam");
        nodeMap.put("hassample", "srm_sampleexam");
        nodeMap.put("hasmaterial", "srm_materialexam");
        nodeMap.put("hasapprove", "srm_supapprove");
        return nodeMap;
    }

    private Map<String, String> getNodeTableMap() {
        HashMap<String, String> nodeMap = new HashMap<String, String>(4);
        nodeMap.put("srm_sceneexam", "t_pur_scene");
        nodeMap.put("srm_sampleexam", "t_pur_sample");
        nodeMap.put("srm_materialexam", "t_pur_material");
        nodeMap.put("srm_supapprove", "t_pur_approve");
        return nodeMap;
    }

    private Map<Long, Map<String, Long>> getTypeNodeListMap(DBRoute dbRoute) {
        String sqlTypeNode = "select distinct t.fid,tp.faccessnodeid,node.fbizobject from t_pur_entertype t,t_srm_entertypeentry tp,t_srm_accessnode node where t.fid=tp.fid and node.fid=tp.faccessnodeid and node.fbizobject != 'srm_aptitudeexam' order by t.fid desc,tp.faccessnodeid asc";
        HashMap<Long, Map<String, Long>> typeNodeListMap = new HashMap<Long, Map<String, Long>>(10);
        try (DataSet dataSet1 = DB.queryDataSet((String)"SupapproveUpgradeService.getTypeNodeListMap", (DBRoute)dbRoute, (String)sqlTypeNode, null);){
            dataSet1.forEach(row -> {
                Long typeId = row.getLong("fid");
                Long nodeId = row.getLong("faccessnodeid");
                String objectnumber = row.getString("fbizobject");
                LinkedHashMap<String, Long> typeNodeMap = (LinkedHashMap<String, Long>)typeNodeListMap.get(typeId);
                if (typeNodeMap != null) {
                    typeNodeMap.put(objectnumber, nodeId);
                } else {
                    typeNodeMap = new LinkedHashMap<String, Long>(5);
                    typeNodeMap.put(objectnumber, nodeId);
                    typeNodeListMap.put(typeId, typeNodeMap);
                }
            });
        }
        return typeNodeListMap;
    }

    private void insertData(DBRoute dbRoute, List<Object[]> parms) {
        String insertSql = " insert  into t_srm_aptitude_nodeentry(fid,fentryid,fseq,faccessnodeid,fnodestatus,fnodebilldate)values( ?, ?, ? , ? , ? , ? )";
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, parms);
    }
}

