/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import kd.scm.srm.common.util.SrmCategoryConfigUtil;

public class SrmAptitudeExamValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject orgDy;
            Boolean isCateGory;
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)rowDataEntity.getDataEntity().getDynamicObject("supplier"));
            DynamicObjectCollection rows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)rows, (String)"category", (String)"material", null);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                this.addErrorMessage(rowDataEntity, resultMap.get("message").toString());
            }
            if (!SrmBillVerifyUtil.verifySupplierId((String)"srm_aptitudeexam", (long)supplierId)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u3001\u672a\u5ba1\u6838\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"SrmAptitudeExamValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if (!SrmBillVerifyUtil.verifyCategoryEntry((String)"srm_aptitudeexam", (DynamicObjectCollection)rows, (ExtendedDataEntity)rowDataEntity)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f15\u5165\u54c1\u7c7b\u5206\u5f55\uff1a\u6309\u54c1\u7c7b\u5f15\u5165\u65f6\uff0c\u8bf7\u5f55\u5165\u91c7\u8d2d\u54c1\u7c7b/\u7269\u6599 \u3002", (String)"SrmAptitudeExamValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if (!((Boolean)(resultMap = SrmBillVerifyUtil.aptitudeRepeatCheck((DynamicObject)rowDataEntity.getDataEntity())).get("succed")).booleanValue()) {
                this.addErrorMessage(rowDataEntity, resultMap.get("message").toString());
            }
            boolean validDate = false;
            for (DynamicObject row : rows) {
                Date datefrom = row.getDate("effectdate");
                Date dateto = row.getDate("expirydate");
                if (!Objects.nonNull(dateto) || !Objects.nonNull(datefrom) || dateto.compareTo(datefrom) > 0) continue;
                validDate = true;
            }
            if (validDate) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u201d\u5fc5\u987b\u5927\u4e8e\u201c\u751f\u6548\u65e5\u671f\u201d,\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SrmAptitudeExamValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if ((isCateGory = SrmCategoryConfigUtil.isCategory((DynamicObject)(orgDy = rowDataEntity.getDataEntity().getDynamicObject("org")))).booleanValue()) {
                int i;
                DynamicObjectCollection catetargetrows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity1");
                HashSet<String> cateidset = new HashSet<String>(rows.size() << 1);
                for (i = 0; i < rows.size(); ++i) {
                    DynamicObject catedyo = ((DynamicObject)rows.get(i)).getDynamicObject("category");
                    if (catedyo == null) continue;
                    cateidset.add(catedyo.getString("id"));
                }
                for (i = 0; i < catetargetrows.size(); ++i) {
                    DynamicObject catetargetdyo = ((DynamicObject)catetargetrows.get(i)).getDynamicObject("examcategory");
                    if (catetargetdyo == null || cateidset.contains(catetargetdyo.getString("id"))) continue;
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f15\u5165\u54c1\u7c7b\u5206\u5f55\u548c\u6700\u4f4e\u8d44\u8d28\u8bc4\u4f30\u5206\u5f55\u7684\u91c7\u8d2d\u54c1\u7c7b\u4e0d\u4e00\u81f4\u3002", (String)"SrmAptitudeExamValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObjectCollection targetrows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity1");
                DynamicObject dataEntity = rowDataEntity.getDataEntity();
                this.delRepeat(dataEntity);
            }
            DynamicObjectCollection targetrows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity1");
            StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u6700\u4f4e\u8d44\u8d28\u8bc4\u4f30\u5206\u5f55\u6ca1\u6709\u586b\u5199\"\u662f\u5426\u6ee1\u8db3\u6700\u4f4e\u8d44\u8d28\":", (String)"SrmAptitudeExamValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            boolean ok = true;
            for (int i = 0; i < targetrows.size(); ++i) {
                DynamicObject currow = (DynamicObject)targetrows.get(i);
                if (currow.getDynamicObject("examcategory") == null || currow.getString("issatisfied") != null) continue;
                ok = false;
                message.append(ResManager.loadResFormat((String)"\u7b2c%1\u884c", (String)"SrmAptitudeExamValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[]{i + 1}));
            }
            if (ok) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)message.toString(), (String)"SrmAptitudeExamValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]));
        }
    }

    private void delRepeat(DynamicObject dataEntity) {
        int i;
        DynamicObjectCollection targetrows = dataEntity.getDynamicObjectCollection("entryentity1");
        HashSet<String> isrepeatset = new HashSet<String>(targetrows.size() << 1);
        ArrayList<Integer> delIndex = new ArrayList<Integer>(10);
        for (i = 0; i < targetrows.size(); ++i) {
            DynamicObject targetrow = (DynamicObject)targetrows.get(i);
            if (targetrow.getDynamicObject("examcategory") == null) continue;
            String cateandevaconfig = targetrow.getDynamicObject("examcategory").getString("id") + targetrow.getDynamicObject("evafactorconfig").getString("id");
            if (isrepeatset.contains(cateandevaconfig)) {
                delIndex.add(i);
                continue;
            }
            isrepeatset.add(cateandevaconfig);
        }
        for (i = delIndex.size() - 1; i >= 0; --i) {
            int index = (Integer)delIndex.get(i);
            targetrows.remove(index);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private boolean isRepeat(DynamicObjectCollection targetrows, StringBuilder message) {
        HashSet<String> isrepeatset = new HashSet<String>(targetrows.size() << 1);
        boolean ok = true;
        for (int i = 0; i < targetrows.size(); ++i) {
            DynamicObject targetrow = (DynamicObject)targetrows.get(i);
            if (targetrow.getDynamicObject("examcategory") != null) {
                String cateandevaconfig = targetrow.getDynamicObject("examcategory").getString("id") + targetrow.getDynamicObject("evafactorconfig").getString("id");
                if (isrepeatset.contains(cateandevaconfig)) {
                    message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmAptitudeExamValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
                    ok = false;
                    continue;
                }
                isrepeatset.add(cateandevaconfig);
                continue;
            }
            ok = false;
            message.append(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u91c7\u8d2d\u54c1\u7c7b\u4e3a\u7a7a\u3002", (String)"SrmAptitudeExamValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[0]), String.valueOf(i + 1)));
        }
        return ok;
    }
}

