/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.common.validators.DealErrorInfoValidator;
import kd.scm.srm.common.SrmBillVerifyUtil;

public class SrmBlackPersonValidator
extends DealErrorInfoValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            Map resultMap;
            String name;
            StringBuilder sb = new StringBuilder();
            boolean isSucced = true;
            DynamicObject dataEntity = rowDataEntity.getDataEntity();
            boolean hasBlank = false;
            hasBlank = this.isMustInputBlank(dataEntity, "entryentity_e", "enumber", ResManager.loadKDString((String)"\"\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\"", (String)"SrmBlackPersonValidator_2", (String)"scm-srm-opplugin", (Object[])new Object[0]), sb, hasBlank);
            hasBlank = this.isMustInputBlank(dataEntity, "entryentity_e", "ename", ResManager.loadKDString((String)"\"\u4f01\u4e1a\u540d\u79f0\"", (String)"SrmBlackPersonValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]), sb, hasBlank);
            hasBlank = this.isMustInputBlank(dataEntity, "entryentity_p", "pnumber", ResManager.loadKDString((String)"\"\u8eab\u4efd\u8bc1\u53f7\u7801\"", (String)"SrmBlackPersonValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]), sb, hasBlank);
            hasBlank = this.isMustInputBlank(dataEntity, "entryentity_p", "pname", ResManager.loadKDString((String)"\"\u4eba\u5458\u59d3\u540d\"", (String)"SrmBlackPersonValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]), sb, hasBlank);
            if (hasBlank) {
                sb.append("\u3002");
                this.addErrorMessage(rowDataEntity, sb.toString());
                continue;
            }
            HashSet<String> nameSet = new HashSet<String>(16);
            HashSet<String> numberSet = new HashSet<String>(16);
            DynamicObjectCollection entryentity_e = dataEntity.getDynamicObjectCollection("entryentity_e");
            int index = 1;
            for (DynamicObject row : entryentity_e) {
                String ename = row.getString("ename");
                String enumber = row.getString("enumber");
                if (nameSet.contains(ename)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)"\u5173\u8054\u4f01\u4e1a\u5206\u5f55\uff1a\u7b2c%1\u884c\u4f01\u4e1a\u540d\u79f0\u91cd\u590d\u3002", (String)"SrmBlackPersonValidator_7", (String)"scm-srm-opplugin", (Object[])new Object[]{index}));
                }
                if (numberSet.contains(enumber)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)"\u5173\u8054\u4f01\u4e1a\u5206\u5f55\uff1a\u7b2c%1\u884c\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u91cd\u590d\u3002", (String)"SrmBlackPersonValidator_8", (String)"scm-srm-opplugin", (Object[])new Object[]{index}));
                }
                if (this.isEntryRepeat("name", ename)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)"\u5173\u8054\u4f01\u4e1a\u5206\u5f55\uff1a\u7b2c%1\u884c\u4f01\u4e1a\u540d\u79f0\u201c%2\u201d\u5df2\u88ab\u62c9\u9ed1\u3002", (String)"SrmBlackPersonValidator_9", (String)"scm-srm-opplugin", (Object[])new Object[]{index, ename}));
                }
                if (this.isEntryRepeat("number", enumber)) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)"\u5173\u8054\u4f01\u4e1a\u5206\u5f55\uff1a\u7b2c%1\u884c\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u201c%2\u201d\u5df2\u88ab\u62c9\u9ed1\u3002", (String)"SrmBlackPersonValidator_10", (String)"scm-srm-opplugin", (Object[])new Object[]{index, enumber}));
                }
                nameSet.add(ename);
                numberSet.add(enumber);
                ++index;
            }
            long currentId = rowDataEntity.getDataEntity().getLong("id");
            String number = rowDataEntity.getDataEntity().getString("number");
            if (!ValidateMatchUtil.isIdCard((String)number) || "".equals(number.trim())) {
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f-->\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a%1 \u65e0\u6548\u3002\n", (String)"SrmBlackPersonValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmBlackPersonValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[]{number == null ? "" : number}));
                isSucced = false;
            }
            if (!ValidateMatchUtil.isName((String)(name = rowDataEntity.getDataEntity().getString("name"))) || "".equals(name.trim())) {
                sb.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f-->\u4eba\u5458\u59d3\u540d\uff1a%1 \u65e0\u6548\u3002\n", (String)"SrmBlackPersonValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmBlackPersonValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[]{name == null ? "" : name}));
                isSucced = false;
            }
            if (!((Boolean)(resultMap = SrmBillVerifyUtil.blackListCheck((DynamicObject)rowDataEntity.getDataEntity())).get("succed")).booleanValue()) {
                isSucced = false;
                sb.append(resultMap.get("message"));
            }
            if (isSucced) continue;
            this.addErrorMessage(rowDataEntity, sb.toString(), "\\\\n");
        }
    }

    private boolean isEntryRepeat(String fieldname, String fileldvalue) {
        return QueryServiceHelper.exists((String)"srm_blackenterprise", (QFilter[])new QFilter[]{new QFilter("blacktype", "=", (Object)"1").and(fieldname, "=", (Object)fileldvalue).and(new QFilter("auditstatus", "=", (Object)"B").or("auditstatus", "=", (Object)"C"))});
    }

    private boolean isMustInputBlank(DynamicObject dataEntity, String entryName, String targetName, String filedName, StringBuilder sb, boolean hasBlank) {
        DynamicObjectCollection entryentityE = dataEntity.getDynamicObjectCollection(entryName);
        for (int i = 0; i < entryentityE.size(); ++i) {
            String filed = ((DynamicObject)entryentityE.get(i)).getString(targetName);
            if (!StringUtils.isBlank((CharSequence)filed)) continue;
            if (!hasBlank) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\uff1a", (String)"SrmBlackPersonValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            } else {
                sb.append(",");
            }
            sb.append(filedName);
            return true;
        }
        return hasBlank;
    }
}

