/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;
import org.apache.commons.collections.CollectionUtils;

public class SrmCategoryChgValidator
extends AbstractValidator {
    public void validate() {
        HashMap categoryMap = new HashMap(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject[] dyocol;
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)rowDataEntity.getDataEntity().getDynamicObject("supplier"));
            DynamicObjectCollection rows = rowDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)rows, (String)"category", (String)"material", null);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                this.addErrorMessage(rowDataEntity, resultMap.get("message").toString());
            }
            if (!SrmBillVerifyUtil.verifySupplierId((String)"srm_categorychg", (long)supplierId)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u3001\u672a\u5ba1\u6838\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"SrmCategoryChgValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            if (!SrmBillVerifyUtil.verifyCategoryEntry((String)"srm_categorychg", (DynamicObjectCollection)rows, (ExtendedDataEntity)rowDataEntity)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6309\u54c1\u7c7b\u5f15\u5165\u65f6\uff0c\u8bf7\u5f55\u5165\u54c1\u7c7b\u4e14\u586b\u5199\u91c7\u8d2d\u54c1\u7c7b\u53d8\u66f4\u540e\u72b6\u6001\u3002", (String)"SrmCategoryChgValidator_4", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject row : rows) {
                String auditStatus = row.getString("categorystatus_old");
                DynamicObject supcategory = row.getDynamicObject("supcategory");
                if (auditStatus == null || !Objects.nonNull(supcategory) || auditStatus.equals(supcategory.getString("auditstatus")) || null == row.getDynamicObject("category")) continue;
                if (StringUtils.isEmpty((Object)row.getString("material.name"))) {
                    this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u54c1\u7c7b[{0}]\u72b6\u6001\u5df2\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmCategoryChgValidator_5", (String)"scm-srm-opplugin", (Object[])new Object[0]), row.getDynamicObject("category").getString("name")));
                    continue;
                }
                this.addErrorMessage(rowDataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u54c1\u7c7b[{0}]/\u7269\u6599[{1}]\u72b6\u6001\u5df2\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SrmCategoryChgValidator_6", (String)"scm-srm-opplugin", (Object[])new Object[0]), row.getDynamicObject("category").getString("name"), row.getString("material.name")));
            }
            String selectedOrgId = rowDataEntity.getDataEntity().getString("org.id");
            String selectedSupId = rowDataEntity.getDataEntity().getString("supplier.id");
            String key = selectedOrgId + selectedSupId;
            HashSet<String> categoryIdSet = null;
            if (categoryMap.containsKey(key)) continue;
            categoryIdSet = new HashSet<String>(16);
            for (DynamicObject dyo : dyocol = BusinessDataServiceHelper.load((String)"adm_categorychg", (String)"org,supplier,initiator,entryentity,entryentity.category,entryentity.category.id,entryentity.category.name,entryentity.material,entryentity.material.id", (QFilter[])new QFilter[]{new QFilter("org.id", "=", (Object)rowDataEntity.getDataEntity().getLong("org.id")).and(new QFilter("supplier.id", "=", (Object)rowDataEntity.getDataEntity().getLong("supplier.id"))).and(new QFilter("auditstatus", "=", (Object)"B"))})) {
                DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection("entryentity");
                for (DynamicObject entrydata : entryentity) {
                    DynamicObject category = entrydata.getDynamicObject("category");
                    DynamicObject material = entrydata.getDynamicObject("material");
                    StringBuilder categoryAndMaterial = new StringBuilder();
                    if (category != null) {
                        categoryAndMaterial.append(category.getString("id"));
                    }
                    if (material != null) {
                        categoryAndMaterial.append(material.getString("id"));
                    }
                    categoryIdSet.add(categoryAndMaterial.toString());
                }
            }
            categoryMap.put(key, categoryIdSet);
        }
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject rowData = rowDataEntity.getDataEntity();
            String selectedOrgId = rowData.getString("org.id");
            String selectedSupId = rowData.getString("supplier.id");
            String key = selectedOrgId + selectedSupId;
            Set categoryIdSet = (Set)categoryMap.get(key);
            if (CollectionUtils.isEmpty((Collection)categoryIdSet)) continue;
            DynamicObjectCollection entryentity = rowData.getDynamicObjectCollection("entryentity");
            StringBuilder msg = new StringBuilder();
            boolean ok = true;
            for (DynamicObject entryData : entryentity) {
                if (!Objects.nonNull(entryData.getDynamicObject("category"))) continue;
                DynamicObject category = entryData.getDynamicObject("category");
                DynamicObject material = entryData.getDynamicObject("material");
                StringBuilder categoryAndMaterial = new StringBuilder();
                if (category != null) {
                    categoryAndMaterial.append(category.getString("id"));
                }
                if (material != null) {
                    categoryAndMaterial.append(material.getString("id"));
                }
                if (!categoryIdSet.contains(categoryAndMaterial.toString())) continue;
                String categoryname = entryData.getDynamicObject("category").getString("name");
                msg.append(categoryname);
                msg.append(",");
                ok = false;
            }
            if (ok) continue;
            msg.deleteCharAt(msg.length() - 1);
            this.addErrorMessage(rowDataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u672a\u5904\u7406\uff08\u63d0\u4ea4\u5ba1\u6279\uff09\u54c1\u7c7b[ %1 ]\uff0c\u8bf7\u7b49\u5f85\u5904\u7406\u540e\uff08\u5ba1\u6279\u901a\u8fc7/\u5ba1\u6279\u9a73\u56de\uff09\u6216\u8005\u64a4\u9500\u8be5\u5355\u636e\u540e\u518d\u7533\u8bf7\u53d8\u66f4\u3002", (String)"SrmCategoryChgValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]), (String)"SrmCategoryChgValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[]{msg.toString()}));
        }
    }
}

