/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.enums.BillStatusEnum;

public class SrmIndexClassDisableValidator
extends AbstractValidator {
    private static final String ENABLE_VAL = "1";

    public void validate() {
        QFilter commonFilter = new QFilter("enable", "=", (Object)ENABLE_VAL);
        commonFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        HashMap<String, String> unDisableLongNumber = new HashMap<String, String>(8);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            QFilter pkFilter = new QFilter("indexclass", "=", rowDataEntity.getBillPkId());
            pkFilter.and(commonFilter);
            boolean isExist = QueryServiceHelper.exists((String)"srm_index", (QFilter[])new QFilter[]{pkFilter});
            if (!isExist) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6709\u542f\u7528\u7684\u8bc4\u4f30\u6307\u6807,\u4e0d\u80fd\u7981\u7528\u3002", (String)"SrmIndexClassDisableValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
            String longNumber = rowDataEntity.getDataEntity().getString("longnumber");
            unDisableLongNumber.put(longNumber, longNumber);
        }
        block1: for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String longNumber = rowDataEntity.getDataEntity().getString("longnumber");
            if (null != unDisableLongNumber.get(longNumber)) continue;
            for (String number : unDisableLongNumber.keySet()) {
                if (!number.startsWith(longNumber)) continue;
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u4e0b\u7ea7\u8282\u70b9\u7981\u7528\u5931\u8d25\uff0c\u4e0a\u7ea7\u8282\u70b9\u65e0\u6cd5\u7981\u7528\u3002", (String)"SrmIndexClassDisableValidator_1", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                continue block1;
            }
        }
    }
}

