/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.opplugin.validator;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.srm.common.SrmBillVerifyUtil;

public class SrmSchemeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject obj = rowDataEntity.getDataEntity();
            DynamicObjectCollection indexRows = obj.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection scorerRows = obj.getDynamicObjectCollection("entry_scorer");
            if (indexRows == null || indexRows.size() == 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8bc4\u4f30\u6307\u6807\u3002", (String)"SrmSchemeValidator_0", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                return;
            }
            Map resultMap = SrmCommonUtil.isRepeatForEntry((DynamicObjectCollection)indexRows, (String)"index", null, null);
            if (!((Boolean)resultMap.get("succed")).booleanValue()) {
                this.addErrorMessage(rowDataEntity, resultMap.get("message").toString());
            }
            if (obj.getBoolean("ishundred")) {
                BigDecimal sumWeight = BigDecimal.ZERO;
                for (DynamicObject row : indexRows) {
                    BigDecimal weight = row.getBigDecimal("weight");
                    sumWeight = sumWeight.add(weight);
                }
                if (sumWeight.compareTo(BigDecimal.TEN.multiply(BigDecimal.TEN)) != 0) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u6307\u6807\u6743\u91cd\u4e4b\u548c\u5e94\u4e3a100\u3002", (String)"SrmSchemeValidator_3", (String)"scm-srm-opplugin", (Object[])new Object[0]));
                }
            }
            if (!rowDataEntity.getDataEntity().getBoolean("isscorer") || ((Boolean)(resultMap = SrmBillVerifyUtil.verifyScorerEntry((DynamicObjectCollection)indexRows, (DynamicObjectCollection)scorerRows)).get("succed")).booleanValue()) continue;
            String[] messages = resultMap.get("message").toString().split("\n");
            Stream.of(messages).forEach(message -> this.addErrorMessage(rowDataEntity, (String)message));
        }
    }
}

