/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.srm.report.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class SrmEvaplanBatchReportListPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterItemInfo evplanFilterItem = reportQueryParam.getFilter().getFilterItem("evplanIdStr");
        FilterItemInfo supplierfilter = reportQueryParam.getFilter().getFilterItem("supplierfilter");
        FilterItemInfo categoryfilter = reportQueryParam.getFilter().getFilterItem("categoryfilter");
        FilterItemInfo materialfilter = reportQueryParam.getFilter().getFilterItem("materialfilter");
        FilterItemInfo schemefilter = reportQueryParam.getFilter().getFilterItem("schemefilter");
        FilterItemInfo gradefilter = reportQueryParam.getFilter().getFilterItem("gradefilter");
        FilterItemInfo showrulefilter = reportQueryParam.getFilter().getFilterItem("showrule");
        boolean showrule = showrulefilter == null || showrulefilter.getValue().toString().equals("B") || showrulefilter.getValue().toString().equals("");
        DynamicObjectCollection supplier = null;
        DynamicObjectCollection category = null;
        DynamicObjectCollection material = null;
        DynamicObjectCollection scheme = null;
        DynamicObjectCollection grade = null;
        if (supplierfilter != null) {
            supplier = (DynamicObjectCollection)supplierfilter.getValue();
        }
        if (categoryfilter != null) {
            category = (DynamicObjectCollection)categoryfilter.getValue();
        }
        if (materialfilter != null) {
            material = (DynamicObjectCollection)materialfilter.getValue();
        }
        if (schemefilter != null) {
            scheme = (DynamicObjectCollection)schemefilter.getValue();
        }
        if (gradefilter != null) {
            grade = (DynamicObjectCollection)gradefilter.getValue();
        }
        if (Objects.isNull(evplanFilterItem)) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"SrmEvaplanBatchReportListPlugin", (String)"srm_score", (String)" ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)" ");
            return rows;
        }
        Object id = evplanFilterItem.getValue();
        String[] idStrS = id.toString().split(",");
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (String idStr : idStrS) {
            idSet.add(Long.parseLong(idStr));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("taskbillid", "in", idSet)};
        DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"srm_score", (String)"entry.index,entry.index.indextype", (QFilter[])qFilters);
        DynamicObjectCollection evaplan = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"id,evamethod", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        if (CollectionUtils.isEmpty((Collection)schemeDys) || Objects.isNull(evaplan) || evaplan.isEmpty()) {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"SrmEvaplanBatchReportListPlugin", (String)"srm_score", (String)" ", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)0)}, (String)" ");
            return rows;
        }
        Set<Long> indexIds = schemeDys.stream().map(x -> x.getLong("entry.index")).distinct().collect(Collectors.toSet());
        HashMap<Long, String> indexMap = new HashMap<Long, String>(16);
        HashMap<Long, HashSet<Long>> addedIndexMap = new HashMap<Long, HashSet<Long>>(16);
        for (DynamicObject schemeDy : schemeDys) {
            long index = schemeDy.getLong("entry.index");
            long indextype = schemeDy.getLong("entry.index.indextype");
            String indexStr = (String)indexMap.get(indextype);
            HashSet<Long> addedIndexSet = (HashSet<Long>)addedIndexMap.get(indextype);
            if (addedIndexSet == null) {
                addedIndexSet = new HashSet<Long>(16);
            }
            if (StringUtils.isBlank((CharSequence)indexStr)) {
                indexMap.put(indextype, "" + index);
                addedIndexSet.add(index);
                addedIndexMap.put(indextype, addedIndexSet);
                continue;
            }
            if (!addedIndexSet.add(index)) continue;
            indexMap.put(indextype, indexStr + "," + index);
            addedIndexMap.put(indextype, addedIndexSet);
        }
        Set indexTypeIds = schemeDys.stream().map(x -> x.getLong("entry.index.indextype")).distinct().collect(Collectors.toSet());
        String selectFieldSql = this.bulidSelectFieldSql(indexIds, indexMap, showrule);
        String supplierParam = this.buildQueryParam(supplier);
        String categoryParam = this.buildQueryParam(category);
        String materialParam = this.buildQueryParam(material);
        String schemeParam = this.buildQueryParam(scheme);
        String gradeParam = this.buildQueryParam(grade);
        String sql = this.bulidQuerySql(id.toString(), selectFieldSql, supplierParam, categoryParam, materialParam, schemeParam, gradeParam);
        DataSet dataSet = DB.queryDataSet((String)"SrmEvaplanReportListPlugin", (DBRoute)new DBRoute("scm"), (String)sql);
        return dataSet;
    }

    private String buildQueryParam(DynamicObjectCollection collection) {
        StringBuilder res = new StringBuilder();
        if (collection != null) {
            for (DynamicObject item : collection) {
                long id = item.getLong("id");
                if (res.length() > 0) {
                    res.append(",");
                }
                res.append(id);
            }
        }
        return res.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterItemInfo evplan = queryParam.getFilter().getFilterItem("evplanIdStr");
        FilterItemInfo supplierfilter = queryParam.getFilter().getFilterItem("supplierfilter");
        FilterItemInfo categoryfilter = queryParam.getFilter().getFilterItem("categoryfilter");
        FilterItemInfo materialfilter = queryParam.getFilter().getFilterItem("materialfilter");
        FilterItemInfo schemefilter = queryParam.getFilter().getFilterItem("schemefilter");
        FilterItemInfo gradefilter = queryParam.getFilter().getFilterItem("gradefilter");
        FilterItemInfo showrulefilter = queryParam.getFilter().getFilterItem("showrule");
        boolean showrule = showrulefilter == null || showrulefilter.getValue().toString().equals("B") || showrulefilter.getValue().toString().equals("");
        DynamicObjectCollection supplier = null;
        DynamicObjectCollection category = null;
        DynamicObjectCollection material = null;
        DynamicObjectCollection scheme = null;
        DynamicObjectCollection grade = null;
        if (supplierfilter != null) {
            supplier = (DynamicObjectCollection)supplierfilter.getValue();
        }
        if (categoryfilter != null) {
            category = (DynamicObjectCollection)categoryfilter.getValue();
        }
        if (materialfilter != null) {
            material = (DynamicObjectCollection)materialfilter.getValue();
        }
        if (schemefilter != null) {
            scheme = (DynamicObjectCollection)schemefilter.getValue();
        }
        if (gradefilter != null) {
            grade = (DynamicObjectCollection)gradefilter.getValue();
        }
        if (Objects.isNull(evplan)) {
            return columns;
        }
        Object id = evplan.getValue();
        String[] idStrS = id.toString().split(",");
        HashSet<Long> idSet = new HashSet<Long>(16);
        for (String idStr : idStrS) {
            idSet.add(Long.parseLong(idStr));
        }
        DynamicObjectCollection evaplanDys = QueryServiceHelper.query((String)"srm_evaplan_batch", (String)"entryentity.supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        HashSet<Object> supplierSet = new HashSet<Object>(16);
        for (DynamicObject evaplanDy : evaplanDys) {
            Object supId = evaplanDy.get("entryentity.supplier");
            supplierSet.add(supId);
        }
        Set<Long> supplierFilterSet = this.buildFilterParam(supplier);
        Set<Long> categoryFilterSet = this.buildFilterParam(category);
        Set<Long> materialFilterSet = this.buildFilterParam(material);
        Set<Long> schemeFilterSet = this.buildFilterParam(scheme);
        Set<Long> gradeFilterSet = this.buildFilterParam(grade);
        if (supplierSet.size() > 0 || supplierFilterSet.size() > 0 || categoryFilterSet.size() > 0 || materialFilterSet.size() > 0 || schemeFilterSet.size() > 0 || gradeFilterSet.size() > 0) {
            QFilter qf = new QFilter("taskbillid", "in", idSet);
            if (supplierFilterSet.size() != 0) {
                qf.and("supplier", "in", supplierFilterSet);
            } else {
                qf.and("supplier", "in", supplierSet);
            }
            if (categoryFilterSet.size() != 0) {
                qf.and("cagetory", "in", categoryFilterSet);
            }
            if (materialFilterSet.size() != 0) {
                qf.and("material", "in", materialFilterSet);
            }
            if (schemeFilterSet.size() != 0) {
                qf.and("scheme", "in", schemeFilterSet);
            }
            if (gradeFilterSet.size() != 0) {
                qf.and("grade", "in", gradeFilterSet);
            }
            DynamicObjectCollection schemeDys = QueryServiceHelper.query((String)"srm_score", (String)this.selectScoreIndexField(), (QFilter[])new QFilter[]{qf});
            Iterator iterator = schemeDys.iterator();
            ArrayList<Long> indexIds = new ArrayList<Long>(12);
            while (iterator.hasNext()) {
                DynamicObject score = (DynamicObject)iterator.next();
                long indexId = score.getLong("entry.index");
                if (indexIds.contains(indexId)) {
                    iterator.remove();
                    continue;
                }
                indexIds.add(indexId);
            }
            ArrayList<ReportColumnGroup> typrGroups = new ArrayList<ReportColumnGroup>();
            if (!showrule) {
                this.addIndexTypeColum(schemeDys, typrGroups, columns);
            } else {
                this.addIdexTypeGroup(schemeDys, typrGroups, showrule);
                this.addIndexClassGroup(schemeDys, typrGroups, showrule);
                this.addIndexColum(schemeDys, typrGroups, showrule);
                columns.addAll(3, typrGroups);
            }
        }
        return columns;
    }

    private void addIndexTypeColum(DynamicObjectCollection schemeDys, List<ReportColumnGroup> typrGroups, List<AbstractReportColumn> columns) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            ArrayList<Long> indexTypeIds = new ArrayList<Long>(24);
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                String indextypeName = schemeDy.getString("entry.index.indextype.name");
                if (indexTypeIds.contains(indexTypeId)) continue;
                indexTypeIds.add(indexTypeId);
                ReportColumn indexColum = new ReportColumn();
                indexColum.setCaption(new LocaleString(indextypeName));
                indexColum.setFieldKey(indexTypeId.toString());
                indexColum.setFieldType("decimal");
                indexColum.setScale(2);
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setTextAlign("center");
                indexColum.setStyle(columnStyle);
                indexColum.setHideSingleColumnRow(false);
                columns.add(3, (AbstractReportColumn)indexColum);
            }
        }
    }

    private Set<Long> buildFilterParam(DynamicObjectCollection collection) {
        HashSet<Long> res = new HashSet<Long>(16);
        if (collection != null) {
            for (DynamicObject item : collection) {
                long id = item.getLong("id");
                res.add(id);
            }
        }
        return res;
    }

    protected String selectScoreIndexField() {
        return "entry.index,entry.index.number,entry.index.name,entry.index.indextype,entry.index.indextype.name,entry.index.indextype.number,entry.index.indexclass,entry.index.indexclass.number,entry.index.indexclass.name";
    }

    protected String bulidQuerySql(String taskIds, String selectStr, String supplierParam, String categoryParam, String materialParam, String schemeParam, String gradeParam) {
        StringBuilder sqlStr = new StringBuilder(16);
        sqlStr.append("SELECT ");
        sqlStr.append(selectStr);
        sqlStr.append(" FROM T_PUR_SCORE A LEFT JOIN t_pur_scoreentry C ON C.FId=A.FId LEFT JOIN T_PUR_SCORE_a D ON D.FId=A.FId");
        sqlStr.append(" WHERE A.ftaskbillid in ( ");
        sqlStr.append(taskIds);
        sqlStr.append(" ) ");
        this.appendQueryParam(sqlStr, "A.FSUPPLIERID", supplierParam);
        this.appendQueryParam(sqlStr, "A.FCATEGORYID", categoryParam);
        this.appendQueryParam(sqlStr, "A.FMATERIALID", materialParam);
        this.appendQueryParam(sqlStr, "A.FSCHEMEID", schemeParam);
        this.appendQueryParam(sqlStr, "A.FGRADEID", gradeParam);
        sqlStr.append(" group by A.FSupplierID,A.FCategoryId,A.FmaterialId,A.Ftaskbillno,A.Fbillno");
        sqlStr.append(" ORDER BY sumscore DESC");
        return sqlStr.toString();
    }

    private void appendQueryParam(StringBuilder sqlStr, String paramName, String param) {
        if (StringUtils.isNotBlank((CharSequence)param)) {
            sqlStr.append(" AND ");
            sqlStr.append(paramName);
            sqlStr.append(" in (");
            sqlStr.append(param);
            sqlStr.append(") ");
        }
    }

    protected String bulidSelectFieldSql(Set<Long> indexIds, Map<Long, String> indexMap, boolean showrule) {
        StringBuilder selectSqlStr = new StringBuilder(16);
        selectSqlStr.append("A.FSupplierID AS \"supplier\",");
        selectSqlStr.append("A.FCategoryId AS \"category\",");
        selectSqlStr.append("A.FmaterialId AS \"material\",");
        selectSqlStr.append("A.FtaskbillNo AS \"evaplanbillno\",");
        selectSqlStr.append("A.Fbillno AS \"evataskbillno\",");
        if (showrule) {
            for (Long indexId : indexIds) {
                selectSqlStr.append(" max(case when C.FIndexID=");
                selectSqlStr.append(indexId);
                selectSqlStr.append(" then C.ffinalscore end ) AS \"");
                selectSqlStr.append(indexId);
                selectSqlStr.append("\",");
            }
        } else {
            for (Map.Entry<Long, String> mapItem : indexMap.entrySet()) {
                Long indexTypeId = mapItem.getKey();
                String indexStr = mapItem.getValue();
                selectSqlStr.append(" sum(case when C.FIndexID in ( ");
                selectSqlStr.append(indexStr);
                selectSqlStr.append(" ) then C.ffinalscore else 0 end ) AS \"");
                selectSqlStr.append(indexTypeId);
                selectSqlStr.append("\",");
            }
        }
        selectSqlStr.append("max(A.FSumScore) AS \"sumscore\",");
        selectSqlStr.append("max(A.fcalgradeid) AS \"evagrade\",");
        selectSqlStr.append("max(A.FSupGradeID) AS \"supgrade\",");
        selectSqlStr.append("max(A.FSchemeId) AS \"scheme\",");
        selectSqlStr.append("max(A.FGradeId) AS \"grade\",");
        selectSqlStr.append("max(D.FSuggestion) AS \"suggestion\",");
        selectSqlStr.append("max(A.fauditgradeid) AS \"auditgrade\",");
        selectSqlStr.append("max(D.fauditopinion) AS \"auditopinion\"");
        return selectSqlStr.toString();
    }

    protected void addIdexTypeGroup(DynamicObjectCollection schemeDys, List<ReportColumnGroup> typrGroups, boolean showrule) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            ArrayList<Long> indexTypeIds = new ArrayList<Long>(24);
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                String indextypeName = schemeDy.getString("entry.index.indextype.name");
                if (indexTypeIds.contains(indexTypeId)) continue;
                ReportColumnGroup typeGroup = new ReportColumnGroup();
                typeGroup.setCaption(new LocaleString(indextypeName));
                typeGroup.setFieldKey(indexTypeId.toString());
                if (!showrule) {
                    typeGroup.setMerge(true);
                }
                indexTypeIds.add(indexTypeId);
                typrGroups.add(typeGroup);
            }
        }
    }

    protected void addIndexClassGroup(DynamicObjectCollection schemeDys, List<ReportColumnGroup> columns, boolean showrule) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            ArrayList<Long> exitIndexClassIds = new ArrayList<Long>(24);
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                Long indexClassId = schemeDy.getLong("entry.index.indexclass");
                String indexclassName = schemeDy.getString("entry.index.indexclass.name");
                for (ReportColumnGroup column : columns) {
                    String fieldKey = column.getFieldKey();
                    if (!indexTypeId.toString().equals(fieldKey) || indexTypeId == 0L || exitIndexClassIds.contains(indexClassId)) continue;
                    ReportColumnGroup indexClassGroup = new ReportColumnGroup();
                    indexClassGroup.setCaption(new LocaleString(indexclassName));
                    indexClassGroup.setFieldKey(indexClassId.toString());
                    if (!showrule) {
                        indexClassGroup.setMerge(true);
                    }
                    column.getChildren().add(indexClassGroup);
                    exitIndexClassIds.add(indexClassId);
                }
            }
        }
    }

    protected void addIndexColum(DynamicObjectCollection schemeDys, List<ReportColumnGroup> columns, boolean showrule) {
        if (!CollectionUtils.isEmpty((Collection)schemeDys)) {
            for (DynamicObject schemeDy : schemeDys) {
                Long indexTypeId = schemeDy.getLong("entry.index.indextype");
                Long indexClassId = schemeDy.getLong("entry.index.indexclass");
                Long indexId = schemeDy.getLong("entry.index");
                String indexName = schemeDy.getString("entry.index.name");
                for (ReportColumnGroup column : columns) {
                    String fieldKey = column.getFieldKey();
                    if (!indexTypeId.toString().equals(fieldKey) || indexTypeId == 0L) continue;
                    List indexClassGroups = column.getChildren();
                    for (AbstractReportColumn indexClassGroup : indexClassGroups) {
                        if (!(indexClassGroup instanceof ReportColumnGroup)) continue;
                        ReportColumnGroup indexReportColumnGroup = (ReportColumnGroup)indexClassGroup;
                        indexReportColumnGroup.setHideSingleColumnRow(false);
                        String indexGroupFiledKey = indexReportColumnGroup.getFieldKey();
                        if (!indexClassId.toString().equals(indexGroupFiledKey) || indexClassId == 0L) continue;
                        ReportColumn indexColum = new ReportColumn();
                        indexColum.setCaption(new LocaleString(indexName));
                        indexColum.setFieldKey(indexId.toString());
                        indexColum.setFieldType("decimal");
                        indexColum.setScale(2);
                        ColumnStyle columnStyle = new ColumnStyle();
                        columnStyle.setTextAlign("center");
                        indexColum.setStyle(columnStyle);
                        indexColum.setHideSingleColumnRow(false);
                        indexReportColumnGroup.getChildren().add(indexColum);
                    }
                }
            }
        }
    }
}

