/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;

public class TenQuestionClarifyOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("bidproject");
        e.getFieldKeys().add("clarifysupplier");
        e.getFieldKeys().add("bidsection");
        e.getFieldKeys().add("supplierdetail");
        e.getFieldKeys().add("clarifydeadline");
        e.getFieldKeys().add("clarifytheme");
        e.getFieldKeys().add("rate");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("resubmisstenders");
        e.getFieldKeys().add("clarifytype");
        e.getFieldKeys().add("openType");
        e.getFieldKeys().add("workday");
        e.getFieldKeys().add("sectionname");
        e.getFieldKeys().add("multiquestclarifyid");
        e.getFieldKeys().add("tenderprice");
        e.getFieldKeys().add("pricevat");
        e.getFieldKeys().add("tax");
        e.getFieldKeys().add("notaxtenderprice");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ValidatorQuestionClarify());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        int j;
        DynamicObjectCollection supplierdetail;
        int i;
        DynamicObjectCollection bidSectionColl;
        BigDecimal rate;
        BigDecimal pricevat;
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        DynamicObject data = datas[0];
        if (StringUtils.equals((CharSequence)"submit", (CharSequence)key)) {
            pricevat = data.getBigDecimal("pricevat");
            rate = data.getBigDecimal("rate");
            data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
            data.set("rate", (Object)rate.divide(new BigDecimal("100")));
            this.synDataFromTenToBid(data);
            bidSectionColl = data.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (i = 0; i < bidSectionColl.size(); ++i) {
                    supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                    for (j = 0; j < supplierdetail.size(); ++j) {
                        ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
            }
        }
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key)) {
            pricevat = data.getBigDecimal("pricevat");
            rate = data.getBigDecimal("rate");
            data.set("pricevat", (Object)pricevat.divide(new BigDecimal("100")));
            data.set("rate", (Object)rate.divide(new BigDecimal("100")));
            bidSectionColl = data.getDynamicObjectCollection("bidsection");
            if (bidSectionColl != null && bidSectionColl.size() > 0) {
                for (i = 0; i < bidSectionColl.size(); ++i) {
                    supplierdetail = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                    if (supplierdetail == null || supplierdetail.size() <= 0) continue;
                    for (j = 0; j < supplierdetail.size(); ++j) {
                        ((DynamicObject)supplierdetail.get(j)).set("taxrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("taxrate").divide(new BigDecimal("100")));
                        ((DynamicObject)supplierdetail.get(j)).set("costrate", (Object)((DynamicObject)supplierdetail.get(j)).getBigDecimal("costrate").divide(new BigDecimal("100")));
                    }
                }
            }
        }
    }

    public void synDataFromTenToBid(DynamicObject data) {
        DynamicObject bidProject;
        block60: {
            bidProject = data.getDynamicObject("bidproject");
            Boolean resubmisstenders = data.getBoolean("resubmisstenders");
            if (!resubmisstenders.booleanValue()) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.synFileOtherattach(data.getPkValue());
                        break block60;
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
            }
            String clarifytype = data.getString("clarifytype");
            if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.synFileTechattach(data.getPkValue());
                        this.synFileOtherattach(data.getPkValue());
                        break block60;
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
            }
            if (BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.synFileCommercattach(data.getPkValue());
                        this.synFileOtherattach(data.getPkValue());
                        break block60;
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
            }
            if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        this.synFileCommercattach(data.getPkValue());
                        this.synFileTechattach(data.getPkValue());
                        this.synFileOtherattach(data.getPkValue());
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        throw ex;
                    }
                }
            }
        }
        data.set("replystatus", (Object)"C");
        data.set("billstatus", (Object)ClarifyStatusEnum.CLARIFIED);
        this.sendMessage(data, bidProject);
    }

    public void synFileOtherattach(Object pk) {
        BidFileHelper.synFileFromAToB((String)this.getSourceFromId(), (Object)pk, (String)"otherattachment", (String)this.getTargetFromId(), (Object)pk, (String)"otherattachment");
    }

    public void synFileCommercattach(Object pk) {
        BidFileHelper.synFileFromAToB((String)this.getSourceFromId(), (Object)pk, (String)"commercattachment", (String)this.getTargetFromId(), (Object)pk, (String)"commercattachment");
    }

    public void synFileTechattach(Object pk) {
        BidFileHelper.synFileFromAToB((String)this.getSourceFromId(), (Object)pk, (String)"techattachment", (String)this.getTargetFromId(), (Object)pk, (String)"techattachment");
    }

    public String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    public String getSourceFromId() {
        String sourceFromId = "ten_questionclarify";
        if ("resp".equals(this.getAppId())) {
            sourceFromId = "resp_questionclarify";
        }
        return sourceFromId;
    }

    public String getTargetFromId() {
        String targetFromId = "bid_questionclarify";
        if ("resp".equals(this.getAppId())) {
            targetFromId = "rebm_questionclarify";
        }
        return targetFromId;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if ("submit".equals(operationKey)) {
            DynamicObject dataEntity = e.getDataEntities()[0];
            String string = this.updateMulQuesClafity(dataEntity);
        }
    }

    protected void updateBidOpen(String s, DynamicObject bidopen, DynamicObject dataEntity) {
        String[] split = s.split("@#@");
        if (split.length <= 1) {
            return;
        }
        String supplierID = split[1].split("&&")[0];
        DynamicObjectCollection bidsection = bidopen.getDynamicObjectCollection("bidsection");
        bidsection.forEach(e -> {
            String sectionname = e.getString("sectionname");
            if (!sectionname.equals(split[0])) {
                return;
            }
            DynamicObjectCollection supplierentry = e.getDynamicObjectCollection("supplierentry");
            supplierentry.forEach(u -> {
                Object supplierId = u.getDynamicObject("supplier").getPkValue();
                if (!StringUtils.equals((CharSequence)String.valueOf(supplierId), (CharSequence)supplierID)) {
                    return;
                }
                u.set("supplier_tenderprice", dataEntity.get("tenderprice"));
                u.set("supplier_taxrate", dataEntity.get("pricevat"));
                u.set("supplier_pricevat", dataEntity.get("tax"));
                u.set("supplier_exceptvat", dataEntity.get("notaxtenderprice"));
            });
            DynamicObjectCollection supplierdetail = e.getDynamicObjectCollection("supplierdetail");
            supplierdetail.forEach(u -> {
                Object supplierId = u.getDynamicObject("pursupplier").getPkValue();
                if (!StringUtils.equals((CharSequence)String.valueOf(supplierId), (CharSequence)supplierID)) {
                    return;
                }
                u.set("inclutaxamount", dataEntity.get("tenderprice"));
                u.set("taxrate", dataEntity.get("pricevat"));
                u.set("taxamount", dataEntity.get("tax"));
                u.set("excepttaxamount", dataEntity.get("notaxtenderprice"));
            });
        });
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidopen});
    }

    protected String updateMulQuesClafity(DynamicObject dataEntity) {
        long multiquestclarifyid = dataEntity.getLong("multiquestclarifyid");
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        String clafitySupplier = dataEntity.getString("clarifysupplier");
        if (multiquestclarifyid == 0L || clafitySupplier == null || bidProject == null) {
            return null;
        }
        long bidProjectId = (Long)bidProject.getPkValue();
        long supplierId = Long.parseLong(clafitySupplier.split("&&")[0]);
        String clarifyTheme = dataEntity.getString("clarifytheme");
        String entityAppid = "ten".equals(this.getAppId()) ? "bid" : "rebm";
        DynamicObject multiQuestClarify = BusinessDataServiceHelper.loadSingle((Object)multiquestclarifyid, (String)(entityAppid + "_multiquestclarify"));
        if (multiQuestClarify == null) {
            return null;
        }
        String sectionInfo = "";
        DynamicObjectCollection bidsection = multiQuestClarify.getDynamicObjectCollection("bidsection");
        String ip = IsIllegalBidUtil.getLoginIp();
        for (DynamicObject section : bidsection) {
            String sectionname = section.getString("sectionname");
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject row : supplierentry) {
                DynamicObject questclarify = row.getDynamicObject("questclarifyid");
                if (questclarify == null || !questclarify.getPkValue().equals(dataEntity.getPkValue())) continue;
                sectionInfo = sectionname + "@#@" + clafitySupplier;
                row.set("isillegalbid", (Object)IsIllegalBidUtil.isIllegalBidInClafity((long)bidProjectId, (long)supplierId, (String)clarifyTheme, (String)(entityAppid + "_multiquestclarify"), (String)ip));
                row.set("clairfytime", (Object)new Date());
                row.set("ip", (Object)ip);
                row.set("clairfyuser", (Object)RequestContext.get().getCurrUserId());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{multiQuestClarify});
        String entityName = "ten".equals(this.getAppId()) ? "bid_iprecord" : "rebm_iprecord";
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        dynamicObject.set("bidproject", (Object)bidProjectId);
        dynamicObject.set("stage", (Object)"clarify");
        dynamicObject.set("supplier", (Object)supplierId);
        dynamicObject.set("ip", (Object)ip);
        dynamicObject.set("operationtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return sectionInfo;
    }

    public void sendMessage(DynamicObject data, DynamicObject bidProject) {
        String clarifysupplier = data.getString("clarifysupplier");
        String[] values = clarifysupplier.split("&&");
        String supplierName = values[1];
        String clarifytype = data.getString("clarifytype");
        String projectName = bidProject.getString("name");
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        if ("resp".equals(this.getAppId())) {
            msgParam.put("formId", "rebm_questionclarify");
            msgParam.put("appId", "rebm");
        } else {
            msgParam.put("formId", "bid_questionclarify");
            msgParam.put("appId", "bid");
        }
        msgParam.put("msgentity", "ten_questionclarify");
        msgParam.put("tplScene", "clear");
        msgParam.put("operation", "send");
        msgParam.put("title", null);
        msgParam.put("content", null);
        msgParam.put("pkId", data.getPkValue());
        msgParam.put("id", data.getPkValue());
        msgParam.put("supplierId", values[0]);
        msgParam.put("sectionName", values[2]);
        msgParam.put("urlParams", Arrays.asList("formId", "pkId", "supplierId", "sectionName"));
        Set<Long> receiveUserIds = this.memberAndProficient(bidProject, clarifytype);
        if (!receiveUserIds.isEmpty()) {
            ArrayList<Long> list = new ArrayList<Long>(receiveUserIds.size());
            for (Long id : receiveUserIds) {
                list.add(id);
            }
            String notifyType = MessageChannelUtil.getNotifyType((String)"clear", (String)"ten_questionclarify");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, list, (String)notifyType);
        }
    }

    public Set<Long> memberAndProficient(DynamicObject bidProject, String clarifytype) {
        HashSet<Long> receiveUserIds;
        block12: {
            HashSet<DynamicObject> memberSet;
            block13: {
                block11: {
                    receiveUserIds = new HashSet<Long>();
                    memberSet = new HashSet<DynamicObject>();
                    if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) break block11;
                    DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                    DynamicObjectCollection memberColl = project.getDynamicObjectCollection("memberentity");
                    for (DynamicObject member : memberColl) {
                        String[] values = member.getString("respbusiness").split(",");
                        if (values == null || values.length <= 0) continue;
                        for (int i = 0; i < values.length; ++i) {
                            if (!"13".equals(values[i]) && !"07".equals(values[i])) continue;
                            memberSet.add(member.getDynamicObject("user"));
                        }
                    }
                    if (memberSet.isEmpty()) break block12;
                    for (DynamicObject set : memberSet) {
                        receiveUserIds.add(set.getLong("id"));
                    }
                    break block12;
                }
                if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) break block13;
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                DynamicObjectCollection memberColl = project.getDynamicObjectCollection("memberentity");
                for (DynamicObject member : memberColl) {
                    String[] values = member.getString("respbusiness").split(",");
                    if (values == null || values.length <= 0) continue;
                    for (int i = 0; i < values.length; ++i) {
                        if (!"14".equals(values[i]) && !"07".equals(values[i])) continue;
                        memberSet.add(member.getDynamicObject("user"));
                    }
                }
                if (memberSet.isEmpty()) break block12;
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
                break block12;
            }
            if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
                DynamicObjectCollection memberColl = project.getDynamicObjectCollection("memberentity");
                for (DynamicObject member : memberColl) {
                    String[] values = member.getString("respbusiness").split(",");
                    if (values == null || values.length <= 0) continue;
                    for (int i = 0; i < values.length; ++i) {
                        if (!"13".equals(values[i]) && !"07".equals(values[i]) && !"14".equals(values[i])) continue;
                        memberSet.add(member.getDynamicObject("user"));
                    }
                }
                if (!memberSet.isEmpty()) {
                    for (DynamicObject set : memberSet) {
                        if (set == null) continue;
                        receiveUserIds.add(set.getLong("id"));
                    }
                }
            }
        }
        return receiveUserIds;
    }

    public static class ValidatorQuestionClarify
    extends AbstractValidator {
        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)key) && dataEntities.length > 0) {
                Integer workDay;
                ExtendedDataEntity data = dataEntities[0];
                Boolean resubmisstenders = (Boolean)data.getValue("resubmisstenders");
                if (!resubmisstenders.booleanValue()) {
                    return;
                }
                String clarifytype = (String)data.getValue("clarifytype");
                if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
                    return;
                }
                DynamicObject bidProject = (DynamicObject)data.getValue("bidproject");
                Boolean ismaterialpur = bidProject.getBoolean("ismaterialpur");
                Boolean isratebidding = bidProject.getBoolean("isratebidding");
                if (!ismaterialpur.booleanValue() && (workDay = (Integer)data.getValue("workday")) != null && workDay < 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenQuestionClarifyOP_0", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                String msgPer = ResManager.loadKDString((String)"\u91c7\u8d2d\u660e\u7ec6\u4fe1\u606f\u4e2d\u3002", (String)"TenQuestionClarifyOP_1", (String)"scm-ten-opplugin", (Object[])new Object[0]);
                DynamicObjectCollection clarifyBidsection = (DynamicObjectCollection)data.getValue("bidsection");
                DynamicObjectCollection supplierdetails = ((DynamicObject)clarifyBidsection.get(0)).getDynamicObjectCollection("supplierdetail");
                for (int i = 0; i < supplierdetails.size(); ++i) {
                    String str;
                    DynamicObject detail = (DynamicObject)supplierdetails.get(i);
                    String rowTip = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"TenQuestionClarifyOP_2", (String)"scm-ten-opplugin", (Object[])new Object[0]), String.valueOf(i + 1));
                    if (isratebidding.booleanValue()) {
                        BigDecimal costrate = detail.getBigDecimal("costrate");
                        if (costrate != null && !(costrate.doubleValue() <= 0.0)) continue;
                        str = String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u8d39\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TenQuestionClarifyOP_3", (String)"scm-ten-opplugin", (Object[])new Object[0]), msgPer, rowTip);
                        this.addErrorMessage(data, str);
                        continue;
                    }
                    BigDecimal taxrate = detail.getBigDecimal("taxrate");
                    if (taxrate != null) continue;
                    str = String.format(ResManager.loadKDString((String)"%1$s%2$s\u201c\u7a0e\u7387\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TenQuestionClarifyOP_5", (String)"scm-ten-opplugin", (Object[])new Object[0]), msgPer, rowTip);
                    this.addErrorMessage(data, str);
                }
            }
        }
    }
}

