/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.common.util.BackBidWayUtil;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenRegistrationOperationServicePlugin
extends AbstractOperationServicePlugIn {
    private static final String ITEM_REGISTER = "register";
    private static final String ENROLLSUPPLIER = "enrollsupplier";
    private static final String ENROLLSUPPLIERCONTACT = "enrollsuppliercontact";
    private static final String ENROLLCONTACTPHONE = "enrollcontactphone";
    private static final String ENROLLADDRESS = "enrolladdress";
    private static final String ENROLLFAX = "enrollfax";
    private static final String ENROLLEMAIL = "enrollemail";
    private static final String BIDPROJECT = "bidproject";
    private static final String ANNOUNCEMENT = "announcement";
    private static final String BIDENROLLSECTION = "bidenrollsection";
    private static final String SUPPLIERENROLLENTRY = "supplierenrollentry";
    private static final String NOTE = "note";
    private static final String INSTRUCTION = "instruction";
    private static final String ATTACHMENT_PANEL_AP = "attachmentpanelap";
    private HashMap<String, DynamicObject> projectSectionIDMap = new HashMap();
    private HashMap<Long, DynamicObject> projectSectionMap = new HashMap();
    Set<String> isCheckList = new HashSet<String>(16);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ValidatorRegister());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add(ENROLLSUPPLIER);
        keys.add(ENROLLSUPPLIERCONTACT);
        keys.add(ENROLLCONTACTPHONE);
        keys.add(ENROLLADDRESS);
        keys.add(ENROLLFAX);
        keys.add(ENROLLEMAIL);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if (StringUtils.equals((CharSequence)ITEM_REGISTER, (CharSequence)key)) {
            DynamicObject data = datas[0];
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u3010beginOperationTransaction\u3011\u4f9b\u5e94\u5546\u62a5\u540d\u5f00\u59cb", (String)"TenRegistrationOperationServicePlugin_7", (String)"scm-ten-opplugin", (Object[])new Object[0]));
            this.registration(data);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        if (StringUtils.equals((CharSequence)ITEM_REGISTER, (CharSequence)key)) {
            DynamicObject data = datas[0];
            Object announcementId = data.get(ANNOUNCEMENT);
            Object bidprojectid = data.get(BIDPROJECT);
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidprojectid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            DynamicObject supplier = null;
            supplier = "ten".equals(this.getAppId()) ? SupplierUtil.getSupplierByOrg((Object)bidprojectid, (Object)bidProject.getDynamicObject("org").getPkValue()) : SupplierUtil.getRESMSupplier();
            this.sendMessage(announcementId, supplier, bidProject);
        }
    }

    public synchronized void registration(DynamicObject data) {
        Object announcementId = data.get(ANNOUNCEMENT);
        Object enrollsuppliercontact = data.get(ENROLLSUPPLIERCONTACT);
        Object enrollcontactphone = data.get(ENROLLCONTACTPHONE);
        Object enrolladdress = data.get(ENROLLADDRESS);
        Object enrollfax = data.get(ENROLLFAX);
        Object enrollemail = data.get(ENROLLEMAIL);
        Object bidprojectid = data.get(BIDPROJECT);
        Object note = data.get(NOTE);
        Object instruction = data.get(INSTRUCTION);
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidprojectid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        DynamicObject supplier = null;
        supplier = "ten".equals(this.getAppId()) ? SupplierUtil.getSupplierByOrg((Object)bidprojectid, (Object)bidProject.getDynamicObject("org").getPkValue()) : SupplierUtil.getRESMSupplier();
        BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u3010beginOperationTransaction\u3011\u4f9b\u5e94\u5546\u62a5\u540d: \u4f9b\u5e94\u5546id\uff1a ", (String)"TenRegistrationOperationServicePlugin_8", (String)"scm-ten-opplugin", (Object[])new Object[0]) + supplier.getPkValue()));
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)this.getSupplierInvitationProperties(), (QFilter[])new QFilter[]{new QFilter(BIDPROJECT, "=", (Object)Long.parseLong(bidprojectid.toString())), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
        if (supplierInvitation != null) {
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u3010beginOperationTransaction\u3011\u4f9b\u5e94\u5546\u62a5\u540d: \u53cd\u5199\u5165\u56f4\u5f00\u59cb\u3002", (String)"TenRegistrationOperationServicePlugin_9", (String)"scm-ten-opplugin", (Object[])new Object[0]));
            DynamicObjectCollection bidSectionColl = supplierInvitation.getDynamicObjectCollection(BIDENROLLSECTION);
            String registerInviteFileFormId = this.getAppId() + "_register_invite_file";
            DynamicObject registerInviteFile = BusinessDataServiceHelper.loadSingle((String)registerInviteFileFormId, (String)"id", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)ITEM_REGISTER), new QFilter("supplierId", "=", supplier.getPkValue()), new QFilter("bidprojectid", "=", bidProject.getPkValue()), new QFilter("announcementid", "=", (Object)Long.valueOf(announcementId.toString()))});
            List attachmentList = new ArrayList();
            if (registerInviteFile != null) {
                attachmentList = AttachmentServiceHelper.getAttachments((String)registerInviteFileFormId, (Object)registerInviteFile.getPkValue(), (String)ATTACHMENT_PANEL_AP);
            }
            SupplierStatisticServiceImpl suppStatService = new SupplierStatisticServiceImpl();
            String entityName = FormTypeConstants.getFormConstant((String)"supplierstatistic", ((Object)((Object)this)).getClass());
            DynamicObject supplierStatistic = suppStatService.getSupplierStatistic((Long)supplier.getPkValue(), entityName);
            supplierStatistic = BusinessDataServiceHelper.loadSingle((Object)supplierStatistic.get("id"), (String)entityName);
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                Object pkValue = ((DynamicObject)bidSectionColl.get(i)).getPkValue();
                if (null == pkValue) continue;
                int size = 0;
                if (!this.isCheckList.contains(pkValue.toString())) continue;
                DynamicObjectCollection supplierRollEntryCol = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection(SUPPLIERENROLLENTRY);
                size = supplierRollEntryCol.size();
                DynamicObject supplierRollEntry = supplierRollEntryCol.addNew();
                supplierRollEntry.set(ENROLLSUPPLIER, (Object)supplier);
                supplierRollEntry.set(ENROLLSUPPLIERCONTACT, enrollsuppliercontact);
                supplierRollEntry.set(ENROLLCONTACTPHONE, enrollcontactphone);
                supplierRollEntry.set(ENROLLEMAIL, enrollemail);
                supplierRollEntry.set(ENROLLADDRESS, enrolladdress);
                supplierRollEntry.set(ENROLLFAX, enrollfax);
                supplierRollEntry.set("enrollstatus", (Object)"ENROLLED");
                supplierRollEntry.set("seq", (Object)(size + 1));
                supplierRollEntry.set(ANNOUNCEMENT, announcementId);
                supplierRollEntry.set("enrollsupplierstatistic", (Object)supplierStatistic);
                supplierRollEntry.set("applyuser", (Object)RequestContext.get().getCurrUserId());
                supplierRollEntry.set("baoprojectpartner", (Object)RequestContext.get().getCurrUserId());
                supplierRollEntry.set("instructionsign", instruction);
                supplierRollEntry.set("notesign", note);
                List attachments = AttachmentUtil.copyToEntryAttachment(attachmentList);
                DynamicObjectCollection inviteAttachFiles = supplierRollEntry.getDynamicObjectCollection("registerattachfile");
                inviteAttachFiles.clear();
                attachments.stream().forEach(item -> {
                    DynamicObject inviteAttach = inviteAttachFiles.addNew();
                    inviteAttach.set("fbasedataid", item);
                });
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitation});
            BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u3010beginOperationTransaction\u3011\u4f9b\u5e94\u5546\u62a5\u540d: \u53cd\u5199\u5165\u56f4\u6210\u529f\u3002", (String)"TenRegistrationOperationServicePlugin_10", (String)"scm-ten-opplugin", (Object[])new Object[0]));
            DynamicObject announcement = BusinessDataServiceHelper.loadSingle((String)TenFormTypeConstants.getFormConstant((String)"apply", ((Object)((Object)this)).getClass()), (String)"publishdate, annotitle", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(announcementId.toString()))});
            DynamicObject myTender = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass())));
            myTender.set("name", (Object)announcement.getString("annotitle"));
            myTender.set("billstatus", (Object)"C");
            myTender.set("org", (Object)bidProject.getDynamicObject("org"));
            myTender.set("currency", bidProject.get("currency"));
            myTender.set(BIDPROJECT, (Object)bidProject);
            myTender.set("ispublicbid", (Object)Boolean.TRUE);
            myTender.set("tenderstatus", (Object)MyTenderStatus.APPLIED);
            myTender.set("publishdate", (Object)announcement.getDate("publishdate"));
            myTender.set(ANNOUNCEMENT, (Object)announcement);
            myTender.set("tenderer", (Object)RequestContext.get().getUserId());
            myTender.set("supplier", (Object)supplier);
            myTender.set("createtime", (Object)new Date());
            myTender.set("entitytypeid", (Object)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()));
            String backBidWay = bidProject.getString("backbidway");
            String docType = bidProject.getString("doctype");
            String backType = BackBidWayUtil.getBackBidType((String)backBidWay, (String)docType);
            myTender.set("backbidway", (Object)backBidWay);
            myTender.set("backbidtype", (Object)backType);
            myTender.set("rounds", (Object)1);
            myTender.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"TenRegistrationOperationServicePlugin_6", (String)"scm-ten-opplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)"1")));
            DynamicObjectCollection myTenderEntryColl = myTender.getDynamicObjectCollection("entry");
            Iterator<String> iterator = this.isCheckList.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                String next = iterator.next();
                DynamicObject myTenderEntry = myTenderEntryColl.addNew();
                DynamicObject projectSection = this.projectSectionMap.get(Long.parseLong(next));
                myTenderEntry.set("projectSection", (Object)projectSection);
                myTenderEntry.set("seq", (Object)index);
                myTenderEntry.set("sectionname", projectSection.get("sectionname"));
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.APPLIED);
                ++index;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTender});
        }
        BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u3010beginOperationTransaction\u3011\u4f9b\u5e94\u5546\u62a5\u540d\u7ed3\u675f", (String)"TenRegistrationOperationServicePlugin_11", (String)"scm-ten-opplugin", (Object[])new Object[0]));
    }

    private void sendMessage(Object announcementId, DynamicObject supplier, DynamicObject bidProject) {
        DynamicObject purTypeObj;
        String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u62a5\u540d\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"TenRegistrationOperationServicePlugin_5", (String)"scm-ten-opplugin", (Object[])new Object[0]), bidProject.getString("name"));
        HashMap<String, Object> msgParam = new HashMap<String, Object>();
        String purTypeName = "";
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        DynamicObject supplierInvi = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
        if (project != null && (purTypeObj = project.getDynamicObject("purtype")) != null) {
            purTypeName = purTypeObj.getString("name");
        }
        DynamicObject[] tender = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"id,entry,entry.sectionname,supplier,entry.projectsection", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()).and(new QFilter("supplier", "=", supplier.getPkValue()))});
        DynamicObjectCollection entry = tender[0].getDynamicObjectCollection("entry");
        msgParam.put("id", tender[0].getPkValue());
        msgParam.put("pkId", supplierInvi.getPkValue());
        msgParam.put("projectId", bidProject.getPkValue());
        msgParam.put("message", "message");
        msgParam.put("purtype", purTypeName);
        msgParam.put("title", null);
        msgParam.put("operation", "btn_tender");
        msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
        String appId = "bid_supplierinvitation".equals(FormTypeConstants.getFormConstant((String)"supplierinvitation", ((Object)((Object)this)).getClass())) ? "bid" : "rebm";
        String notifyType = null;
        if ("bid".equals(appId)) {
            msgParam.put("msgentity", "ten_mytender");
            msgParam.put("formId", "bid_supplierinvitation");
            msgParam.put("appId", "bid");
            notifyType = MessageChannelUtil.getNotifyType((String)"tenregister", (String)"ten_mytender");
        } else {
            msgParam.put("msgentity", "resp_mytender");
            msgParam.put("formId", "rebm_supplierinvitation");
            msgParam.put("appId", "rebm");
            notifyType = MessageChannelUtil.getNotifyType((String)"tenregister", (String)"resp_mytender");
        }
        msgParam.put("tplScene", "tenregister");
        DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
        HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
        for (DynamicObject member : memberColl) {
            String[] values = member.getString("respbusiness").split(",");
            if (values != null && values.length > 0) {
                for (int m = 0; m < values.length; ++m) {
                    if (!"02".equals(values[m])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!member.getBoolean("isdirector")) continue;
            memberSet.add(member.getDynamicObject("user"));
        }
        List receiveUserIds = memberSet.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        msgParam.put("content", null);
        MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
    }

    private String getAppId() {
        return ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
    }

    public String getSupplierInvitationProperties() {
        return "bidsection,supplierentry,supplierentry,bidenrollsection,supplierenrollentry.enrollsupplier,supplierenrollentry.enrollsuppliercontact,supplierenrollentry.enrollcontactphone,supplierenrollentry.enrollemail,supplierenrollentry.enrolladdress,supplierenrollentry.enrollfax,supplierenrollentry.enrollstatus,supplierenrollentry.seq,supplierenrollentry.announcement,supplierenrollentry.enrollsupplierstatistic,supplierenrollentry.applyuser,supplierenrollentry.applydate,supplierenrollentry.instructionsign,supplierenrollentry.notesign,supplierenrollentry.attachmentsign,supplierenrollentry.baoprojectpartner,supplierenrollentry.registerattachfile";
    }

    private class ValidatorRegister
    extends AbstractValidator {
        private ValidatorRegister() {
        }

        public void validate() {
            String key = this.getOperateKey();
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            if (StringUtils.equals((CharSequence)TenRegistrationOperationServicePlugin.ITEM_REGISTER, (CharSequence)key)) {
                ExtendedDataEntity dataEntity = dataEntities[0];
                Object enrollemail = dataEntity.getValue(TenRegistrationOperationServicePlugin.ENROLLEMAIL);
                Object enrollcontactphone = dataEntity.getValue(TenRegistrationOperationServicePlugin.ENROLLCONTACTPHONE);
                Object enrollsuppliercontact = dataEntity.getValue(TenRegistrationOperationServicePlugin.ENROLLSUPPLIERCONTACT);
                Object enrolladdress = dataEntity.getValue(TenRegistrationOperationServicePlugin.ENROLLADDRESS);
                Object bidprojectid = dataEntity.getValue(TenRegistrationOperationServicePlugin.BIDPROJECT);
                Object announcementId = dataEntity.getValue(TenRegistrationOperationServicePlugin.ANNOUNCEMENT);
                Object orgPk = BusinessDataServiceHelper.loadSingle((Object)bidprojectid, (String)"bid_project").getDynamicObject("org").getPkValue();
                DynamicObject supplier = SupplierUtil.getSupplierByOrg((Object)bidprojectid, (Object)orgPk);
                String supplierId = supplier.getPkValue().toString();
                QFilter filter1 = new QFilter(TenRegistrationOperationServicePlugin.ENROLLSUPPLIER, "=", (Object)Long.parseLong(supplierId));
                DynamicObject[] supplierenrollentry = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)TenRegistrationOperationServicePlugin.SUPPLIERENROLLENTRY, ((Object)((Object)this)).getClass()), (String)TenRegistrationOperationServicePlugin.ANNOUNCEMENT, (QFilter[])new QFilter[]{filter1});
                HashSet<String> announcementIds = new HashSet<String>();
                for (int i = 0; i < supplierenrollentry.length; ++i) {
                    if (StringUtils.isBlank((CharSequence)supplierenrollentry[i].getString(TenRegistrationOperationServicePlugin.ANNOUNCEMENT))) continue;
                    announcementIds.add(supplierenrollentry[i].getString(TenRegistrationOperationServicePlugin.ANNOUNCEMENT));
                }
                if (announcementIds.contains(announcementId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u62db\u6807\u516c\u544a\u5df2\u7ecf\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"TenRegistrationOperationServicePlugin_0", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidprojectid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enrolldeadline");
                Object enrollDeadline = bidProject.get("enrolldeadline");
                String endTime = enrollDeadline.toString();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date date = format.parse(endTime);
                    Date date1 = new Date();
                    int compareTo = date1.compareTo(date);
                    if (compareTo > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672c\u6b21\u62db\u6807\u62a5\u540d\u5df2\u622a\u6b62\u3002", (String)"TenRegistrationOperationServicePlugin_1", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                DynamicObject bid_project = BusinessDataServiceHelper.loadSingle((Object)bidprojectid, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"enablemultisection, org, bidsection, bidsection.sectionname");
                for (DynamicObject projectSection : bid_project.getDynamicObjectCollection("bidsection")) {
                    TenRegistrationOperationServicePlugin.this.projectSectionIDMap.put(projectSection.getString("sectionname"), projectSection);
                }
                Boolean enablemultisection = (Boolean)bid_project.get("enablemultisection");
                DynamicObjectCollection colls = SupplierUtil.getSupplierInvitation((String)bidprojectid.toString());
                if (enablemultisection.booleanValue()) {
                    for (DynamicObject temp : colls) {
                        Boolean isCheck = (Boolean)dataEntity.getValue("section" + temp.getPkValue());
                        if (!isCheck.booleanValue()) continue;
                        TenRegistrationOperationServicePlugin.this.isCheckList.add(temp.getPkValue().toString());
                        if (!TenRegistrationOperationServicePlugin.this.projectSectionIDMap.containsKey(temp.getString("entrysectionname"))) continue;
                        TenRegistrationOperationServicePlugin.this.projectSectionMap.put((Long)temp.getPkValue(), TenRegistrationOperationServicePlugin.this.projectSectionIDMap.get(temp.getString("entrysectionname")));
                    }
                    if (TenRegistrationOperationServicePlugin.this.isCheckList.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u540d\u4fe1\u606f\u672a\u586b\u5199\u5b8c\u5168\uff0c\u8bf7\u586b\u5199\u5b8c\u6210\u540e\u518d\u62a5\u540d\u3002", (String)"TenRegistrationOperationServicePlugin_2", (String)"scm-ten-opplugin", (Object[])new Object[0]));
                        return;
                    }
                } else {
                    Long tempID = (Long)((DynamicObject)colls.get(0)).getPkValue();
                    TenRegistrationOperationServicePlugin.this.isCheckList.add(tempID.toString());
                    TenRegistrationOperationServicePlugin.this.projectSectionMap.put(tempID, TenRegistrationOperationServicePlugin.this.projectSectionIDMap.get(((DynamicObject)colls.get(0)).getString("entrysectionname")));
                }
            }
        }
    }
}

