/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.ten.business.bill.ITenQuestionClarifyService;
import kd.scm.ten.business.bill.serviceImpl.ITenQuestionClarifyServiceImpl;
import kd.scm.ten.common.constant.TenFormTypeConstants;

public class TenQuestionClarifyEdit
extends AbstractBillPlugIn
implements TabSelectListener {
    ITenQuestionClarifyService questionClarifyService = new ITenQuestionClarifyServiceImpl();
    private static final String CACHEIMPORTNEWFILEUIDS = "cacheImportNewFileUids";
    private static final String CACHESAVESUBMITSUCCESS = "cacheSaveSubmitSuccess";
    private static final String SPLITSTR = "#@#";

    public void beforeBindData(EventObject e) {
        String bigquestiondescription;
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BigDecimal pricevat = dataEntity.getBigDecimal("pricevat");
        BigDecimal rate = dataEntity.getBigDecimal("rate");
        dataEntity.set("pricevat", (Object)pricevat.multiply(new BigDecimal("100")));
        dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
        DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
        if (bidSectionColl != null && bidSectionColl.size() > 0) {
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObjectCollection supplierDetailColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                if (supplierDetailColl == null || supplierDetailColl.size() <= 0) continue;
                for (int m = 0; m < supplierDetailColl.size(); ++m) {
                    ((DynamicObject)supplierDetailColl.get(m)).set("taxrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                    ((DynamicObject)supplierDetailColl.get(m)).set("costrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)(bigquestiondescription = dataEntity.getString("bigquestiondescription_tag")))) {
            String questiondescription = dataEntity.getString("questiondescription");
            dataEntity.set("bigquestiondescription_tag", (Object)questiondescription);
            this.getView().updateView("bigquestiondescription");
            this.getView().updateView("bigquestiondescription_tag");
        }
        this.getView().updateView("supplierdetail");
        this.getView().updateView("ten_questionclarify");
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        Long multiquestclarifyId;
        super.afterBindData(e);
        Boolean resubmisstenders = (Boolean)this.getModel().getValue("resubmisstenders");
        if (!resubmisstenders.booleanValue()) {
            this.setVisibleByResubmisstenders(Boolean.FALSE);
        } else {
            String clarifytype = (String)this.getModel().getValue("clarifytype");
            this.setVisibleByClarifytype(clarifytype);
        }
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        String docType = bidProject.getString("doctype");
        if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
            this.getModel().setValue("clarifytype", (Object)docType);
            this.getView().setEnable(Boolean.FALSE, new String[]{"clarifytype"});
        }
        DynamicObjectCollection sectionList = this.getModel().getDataEntity(true).getDynamicObjectCollection("bidsection");
        for (DynamicObject section : sectionList) {
            section.getDataEntityState().setPushChanged(true);
        }
        String pageId = this.getView().getPageId();
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        if (pageCache != null && pageId != null) {
            pageCache.put(String.valueOf(pkValue), pageId);
        }
        String appId = this.getFromId().split("_")[0];
        String entityName = "";
        entityName = "ten".equals(appId) ? "bid_query_letters" : "rebm_query_letters_inh";
        boolean exists = QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{new QFilter("queryid", "=", (Object)(multiquestclarifyId = Long.valueOf(this.getModel().getDataEntity().getLong("multiquestclarifyid"))))});
        if (!exists) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"questiontab"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData cd = e.getChangeSet()[0];
        Object newVal = cd.getNewValue();
        Object oldVal = cd.getOldValue();
        if (newVal != null && newVal.equals(oldVal)) {
            return;
        }
        String filedName = e.getProperty().getName();
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxprice") || StringUtils.equals((CharSequence)filedName, (CharSequence)"taxrate") || StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxamount")) {
            DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection detailEntryCols = ((DynamicObject)bidSectionEntry.get(0)).getDynamicObjectCollection("supplierdetail");
            BigDecimal sumInclutaxprice = BigDecimal.ZERO;
            BigDecimal sumtaxrate = BigDecimal.ZERO;
            BigDecimal sumtaxamount = BigDecimal.ZERO;
            BigDecimal sumexcepttaxamount = BigDecimal.ZERO;
            DynamicObject bidProject = dataentity.getDynamicObject("bidproject");
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            int bidType = bidProject.getInt("bidtype");
            ChangeData[] datas = e.getChangeSet();
            ChangeData changedata = datas[0];
            int index = changedata.getRowIndex();
            DynamicObject supplierDetailRow = (DynamicObject)detailEntryCols.get(index);
            if (bidType != 0) {
                BigDecimal inclutaxprice = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxprice")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxprice");
                BigDecimal qty = supplierDetailRow.getBigDecimal("qty");
                BigDecimal inclutaxamount = qty.multiply(inclutaxprice).setScale(2, 4);
                BigDecimal taxrate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), 2, 4);
                this.getModel().setValue("taxamount", (Object)taxamount, index);
            } else {
                BigDecimal inclutaxamount = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxamount")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxamount");
                BigDecimal taxrate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxamount = inclutaxamount.multiply(taxrate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxrate.divide(new BigDecimal("100"))), 2, 4);
                this.getModel().setValue("taxamount", (Object)taxamount, index);
            }
            HashSet<BigDecimal> taxSet = new HashSet<BigDecimal>();
            for (DynamicObject supplierdetailcol : detailEntryCols) {
                taxSet.add(supplierdetailcol.getBigDecimal("taxrate"));
                BigDecimal singleInclutaxprice = supplierdetailcol.getBigDecimal("inclutaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("inclutaxamount");
                BigDecimal singletaxamount = supplierdetailcol.getBigDecimal("taxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("taxamount");
                BigDecimal singleexcepttaxamount = supplierdetailcol.getBigDecimal("excepttaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("excepttaxamount");
                sumInclutaxprice = sumInclutaxprice.add(singleInclutaxprice);
                sumtaxamount = sumtaxamount.add(singletaxamount);
                sumexcepttaxamount = sumexcepttaxamount.add(singleexcepttaxamount);
            }
            sumtaxrate = sumexcepttaxamount.compareTo(BigDecimal.ZERO) != 0 ? sumtaxamount.divide(sumexcepttaxamount, 4, 4) : BigDecimal.ZERO;
            this.getModel().setValue("tenderprice", (Object)sumInclutaxprice);
            if (detailEntryCols.size() == 1 || taxSet.size() == 1) {
                sumtaxrate = ((DynamicObject)detailEntryCols.get(0)).getBigDecimal("taxrate");
                this.getModel().setValue("pricevat", (Object)sumtaxrate);
            } else {
                this.getModel().setValue("pricevat", (Object)sumtaxrate.multiply(new BigDecimal("100")));
            }
            BigDecimal inclutaxprice = (BigDecimal)this.getModel().getValue("inclutaxprice", index);
            if (Objects.isNull(inclutaxprice)) {
                this.getModel().setValue("inclutaxprice", (Object)BigDecimal.ZERO, index);
            }
            this.getModel().setValue("tax", (Object)sumtaxamount);
            this.getModel().setValue("notaxtenderprice", (Object)sumexcepttaxamount);
        }
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"bd_taxrate")) {
            int rowindex = cd.getRowIndex();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowindex);
            } else {
                DynamicObject bdTaxRate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bdTaxRate.getBigDecimal("taxrate"), rowindex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("submit".equals(operateKey)) {
            Object clarifyId;
            String appId = this.getFromId().split("_")[0];
            if ("ten".equals(appId) || "resp".equals(appId)) {
                DynamicObject bidproject = dataEntity.getDynamicObject("bidproject");
                String bidAppId = "ten".equals(appId) ? "bid_" : "rebm_";
                bidproject = BusinessDataServiceHelper.loadSingle((Object)bidproject.getPkValue(), (String)(bidAppId + "project"));
                boolean isratebidding = bidproject.getBoolean("isratebidding");
                boolean resubmisstenders = dataEntity.getBoolean("resubmisstenders");
                String clarifytype = dataEntity.getString("clarifytype");
                if (resubmisstenders && !isratebidding && !"TECHNICAL".equals(clarifytype)) {
                    DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
                    for (DynamicObject section : bidsection) {
                        DynamicObjectCollection supplierdetail = section.getDynamicObjectCollection("supplierdetail");
                        for (DynamicObject detail : supplierdetail) {
                            DynamicObject bd_taxrate;
                            int bidType = bidproject.getInt("bidtype");
                            if (bidType == 0 || (bd_taxrate = detail.getDynamicObject("bd_taxrate")) != null) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7a0e\u7387\u540d\u79f0\u3002", (String)"TenQuestionClarifyEdit_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                            args.setCancel(true);
                            return;
                        }
                    }
                }
            }
            if (this.questionClarifyService.checkClarifyDeadline(clarifyId = dataEntity.getPkValue()).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6f84\u6e05\u622a\u6b62\u65f6\u95f4\u201d\u5df2\u5230\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TenQuestionClarifyEdit_2", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((Object)clarifyId, (String)"bid_questionclarify", (String)"billstatus,clarifysupplier,resubmisstenders,clarifytype");
            String billstatus = clarifyQest.getString("billstatus");
            if (ClarifyStatusEnum.INVALID.getValue().equals(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62db\u6807\u9879\u5df2\u6d41\u6807\uff0c\u4e0d\u652f\u6301\u6f84\u6e05\u3002", (String)"TenQuestionClarifyEdit_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!ClarifyStatusEnum.UNCLARIFIED.getValue().equals(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d28\u7591\u5355\u636e\u5df2\u88ab\u64a4\u9500\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"TenQuestionClarifyEdit_4", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String clarifysupplier = clarifyQest.getString("clarifysupplier");
            Boolean resubmisstenders = clarifyQest.getBoolean("resubmisstenders");
            String clarifytype = clarifyQest.getString("clarifytype");
            String clarifysupplierModel = (String)this.getModel().getValue("clarifysupplier");
            Boolean resubmisstendersModel = (Boolean)this.getModel().getValue("resubmisstenders");
            String clarifytypeModel = (String)this.getModel().getValue("clarifytype");
            Boolean isDataModel = StringUtils.equals((CharSequence)clarifysupplier, (CharSequence)clarifysupplierModel) && resubmisstenders.equals(resubmisstendersModel) && StringUtils.equals((CharSequence)clarifytype, (CharSequence)clarifytypeModel);
            if (!isDataModel.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"TenQuestionClarifyEdit_5", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            resubmisstenders = (Boolean)this.getModel().getValue("resubmisstenders");
            if (resubmisstenders.booleanValue() && this.checkAttachMustInputByClarifytype(clarifytype = (String)this.getModel().getValue("clarifytype")).booleanValue()) {
                args.setCancel(true);
                return;
            }
        }
        if ("importlatestdata".equals(operateKey)) {
            String clarifysupplier = (String)this.getModel().getValue("clarifysupplier");
            String[] values = clarifysupplier.split("&&");
            Long supplierId = Long.parseLong(values[0]);
            String clarifySectionName = "";
            if (values.length == 3) {
                clarifySectionName = values[2];
            }
            DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
            QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
            boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
            if (enableMultiSection) {
                supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + clarifySectionName)));
            }
            QFilter isBidDingFilter = new QFilter("is_again_bidding", "!=", (Object)"2");
            QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
            QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI));
            QFilter reSubmitTendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
            String orderBys = "submitdate desc";
            boolean top = true;
            Log log = LogFactory.getLog(TenQuestionClarifyEdit.class);
            this.importDataFromOpenBid(clarifysupplier, true);
            log.info("TenQuestionClarifyEdit--\u4ece\u5f00\u6807\u62ff\u6700\u65b0\u6570\u636e");
            this.addBillsum(clarifysupplier);
        }
    }

    private void importDataFromBidding(DynamicObject bidProject, Long supplierId) {
        QFilter filter1 = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter filter2 = new QFilter("supplier", "=", (Object)supplierId);
        QFilter filter3 = new QFilter("billstatus", "=", (Object)new String[]{"B"});
        DynamicObject[] biddingColl = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass()), (String)"id,billstatus", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        if (biddingColl.length == 0) {
            return;
        }
        DynamicObject bidding = BusinessDataServiceHelper.loadSingle((Object)biddingColl[0].get("id"), (String)TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass()));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidsectioncoll = bidding.getDynamicObjectCollection("entry");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            DynamicObjectCollection sectionColl = model.getEntityEntity("bidsection");
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            if (sectionColl.size() - 1 < i) {
                model.createNewEntryRow("bidsection");
            }
            model.setValue("sectionname", (Object)bidsection.getString("sectionname"), i);
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                model.setEntryCurrentRowIndex("bidsection", i);
                DynamicObjectCollection supplierColl = this.getModel().getEntryEntity("supplierdetail");
                if (supplierColl.size() - 1 < j) {
                    model.createNewEntryRow("supplierdetail");
                }
                model.setValue("pursupplier", bidding.get("supplier"), j);
                model.setValue("purentrycontent", supplierentry.get("purentrycontent"), j);
                model.setValue("materialid", supplierentry.get("materialid"), j);
                model.setValue("purentryproject", supplierentry.get("purentryproject"), j);
                model.setValue("materialdes", supplierentry.get("materialdes"), j);
                model.setValue("qty", supplierentry.get("qty"), j);
                model.setValue("inclutaxprice", supplierentry.get("inclutaxprice"), j);
                model.setValue("inclutaxamount", supplierentry.get("inclutaxamount"), j);
                model.setValue("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")), j);
                model.setValue("taxamount", supplierentry.get("taxamount"), j);
                model.setValue("excepttaxamount", supplierentry.get("excepttaxamount"), j);
                model.setValue("costrate", (Object)supplierentry.getBigDecimal("costrate").multiply(new BigDecimal("100")), j);
            }
        }
        model.endInit();
        this.getView().updateView("supplierdetail");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        OperationResult opResult = e.getOperationResult();
        if (opResult != null && !opResult.isSuccess()) {
            return;
        }
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            if (e.getOperationResult().isSuccess()) {
                this.getPageCache().put(CACHESAVESUBMITSUCCESS, "true");
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                BigDecimal pricevat = dataEntity.getBigDecimal("pricevat");
                BigDecimal rate = dataEntity.getBigDecimal("rate");
                dataEntity.set("pricevat", (Object)pricevat.multiply(new BigDecimal("100")));
                dataEntity.set("rate", (Object)rate.multiply(new BigDecimal("100")));
                DynamicObjectCollection bidSectionColl = dataEntity.getDynamicObjectCollection("bidsection");
                if (bidSectionColl != null && bidSectionColl.size() > 0) {
                    for (int i = 0; i < bidSectionColl.size(); ++i) {
                        DynamicObjectCollection supplierDetailColl = ((DynamicObject)bidSectionColl.get(i)).getDynamicObjectCollection("supplierdetail");
                        if (supplierDetailColl == null || supplierDetailColl.size() <= 0) continue;
                        for (int m = 0; m < supplierDetailColl.size(); ++m) {
                            ((DynamicObject)supplierDetailColl.get(m)).set("taxrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("taxrate").multiply(new BigDecimal("100")));
                            ((DynamicObject)supplierDetailColl.get(m)).set("costrate", (Object)((DynamicObject)supplierDetailColl.get(m)).getBigDecimal("costrate").multiply(new BigDecimal("100")));
                        }
                    }
                }
                this.getView().updateView("supplierdetail");
                this.getView().updateView("ten_questionclarify");
            }
            if ("submit".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().setEnable(Boolean.FALSE, new String[]{"importlatestdata"});
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String status = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)status, (CharSequence)"CLARIFIED") || StringUtils.equals((CharSequence)status, (CharSequence)"SAVED") || StringUtils.equals((CharSequence)status, (CharSequence)"UNCLARIFIED")) {
            this.getModel().setDataChanged(false);
        }
        String cacheImportNewFileUids = this.getPageCache().get(CACHEIMPORTNEWFILEUIDS);
        Log log = LogFactory.getLog(TenQuestionClarifyEdit.class);
        log.info("TenQuestionClarifyEdit--\u5f00\u59cb\u8fdb\u884c\u9644\u4ef6\u5220\u9664\u5224\u65ad");
        if (cacheImportNewFileUids != null) {
            if ("".equals(cacheImportNewFileUids.trim())) {
                return;
            }
            log.info("TenQuestionClarifyEdit--cacheImportNewFileUids--\u672c\u6b21\u5f15\u5165\u65b0\u589e\u7684\u9644\u4ef6uid", (Object)cacheImportNewFileUids);
            String cacheSuccessSaveSubmit = this.getPageCache().get(CACHESAVESUBMITSUCCESS);
            if (cacheSuccessSaveSubmit == null) {
                String[] uidArray = cacheImportNewFileUids.split(SPLITSTR);
                ArrayList<String> uidList = new ArrayList<String>(uidArray.length);
                for (String uidArrayOne : uidArray) {
                    uidList.add(uidArrayOne);
                }
                BidFileHelper.removeSpecificFile((String)this.getFromId(), (Object)this.getModel().getDataEntity().getPkValue(), uidList);
            } else {
                log.info("TenQuestionClarifyEdit--cacheSuccessSaveSubmit--\u672c\u6b21\u4e0d\u9700\u8981\u5220\u9664\u9644\u4ef6\u4fe1\u606f", (Object)cacheSuccessSaveSubmit);
            }
        }
    }

    public void addBillsum(String clarifysupplier) {
        String[] values = clarifysupplier.split("&&");
        Long supplierId = Long.parseLong(values[0]);
        String clarifySectionName = "";
        if (values.length == 3) {
            clarifySectionName = values[2];
        }
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection detailEntryCols = new DynamicObjectCollection();
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        for (DynamicObject sectionEntry : bidSectionEntry) {
            String sectionname = sectionEntry.getString("sectionname");
            if (enablemultisection && !clarifySectionName.equals(sectionname)) continue;
            detailEntryCols = sectionEntry.getDynamicObjectCollection("supplierdetail");
        }
        BigDecimal sumInclutaxprice = BigDecimal.ZERO;
        BigDecimal sumtaxrate = BigDecimal.ZERO;
        BigDecimal sumtaxamount = BigDecimal.ZERO;
        BigDecimal sumexcepttaxamount = BigDecimal.ZERO;
        for (DynamicObject supplierdetailcol : detailEntryCols) {
            BigDecimal singleInclutaxprice = supplierdetailcol.getBigDecimal("inclutaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("inclutaxamount");
            BigDecimal singletaxamount = supplierdetailcol.getBigDecimal("taxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("taxamount");
            BigDecimal singleexcepttaxamount = supplierdetailcol.getBigDecimal("excepttaxamount") == null ? BigDecimal.ZERO : supplierdetailcol.getBigDecimal("excepttaxamount");
            sumInclutaxprice = sumInclutaxprice.add(singleInclutaxprice);
            sumtaxamount = sumtaxamount.add(singletaxamount);
            sumexcepttaxamount = sumexcepttaxamount.add(singleexcepttaxamount);
        }
        if (sumexcepttaxamount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        sumtaxrate = sumtaxamount.divide(sumexcepttaxamount, 4, 4);
        this.getModel().setValue("tenderprice", (Object)sumInclutaxprice);
        if (detailEntryCols.size() == 1) {
            sumtaxrate = ((DynamicObject)detailEntryCols.get(0)).getBigDecimal("taxrate");
            this.getModel().setValue("pricevat", (Object)sumtaxrate);
        } else {
            this.getModel().setValue("pricevat", (Object)sumtaxrate.multiply(new BigDecimal("100")));
        }
        this.getModel().setValue("tax", (Object)sumtaxamount);
        this.getModel().setValue("notaxtenderprice", (Object)sumexcepttaxamount);
    }

    private void setVisibleByClarifytype(String clarifytype) {
        IFormView view = this.getView();
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.FALSE, new String[]{"tax", "rate", "pricevat", "tenderprice", "notaxtenderprice", "businesstenderattach", "procuredetailpanel", "projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"technicaltenderattach"});
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.FALSE, new String[]{"technicaltenderattach"});
            view.setVisible(Boolean.TRUE, new String[]{"businesstenderattach", "procuredetailpanel"});
            this.setVisibleByMaterialpurAndRate();
        } else if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
            view.setVisible(Boolean.TRUE, new String[]{"technicaltenderattach", "businesstenderattach", "procuredetailpanel"});
            this.setVisibleByMaterialpurAndRate();
        }
    }

    private Boolean checkAttachMustInputByClarifytype(String clarifytype) {
        IFormView view = this.getView();
        if (this.getView().getParentView() != null) {
            view = this.getView().getParentView();
        }
        if (BidOpenTypeEnum.TECHNICAL.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("techattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenQuestionClarifyEdit_6", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(view);
                return Boolean.TRUE;
            }
        } else if (BidOpenTypeEnum.BUSSINESS.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("commercattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenQuestionClarifyEdit_7", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(view);
                return Boolean.TRUE;
            }
        } else if (BidOpenTypeEnum.MULTI.getValue().equals(clarifytype)) {
            Boolean checkflag = this.checkAttachMustInput("techattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenQuestionClarifyEdit_6", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(view);
                return Boolean.TRUE;
            }
            checkflag = this.checkAttachMustInput("commercattachment");
            if (checkflag.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenQuestionClarifyEdit_7", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(view);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private Boolean checkAttachMustInput(String attachmentpanelName) {
        JSONArray attachment;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pk = dataEntity.getPkValue();
        String key = "TampAttCache" + this.getView().getPageId();
        String xObject = this.getPageCache().get(key);
        JSONObject attObject = null;
        String formID = this.getFromId();
        List attachmentList = AttachmentServiceHelper.getAttachments((String)formID, (Object)pk, (String)attachmentpanelName);
        if (xObject != null ? ((attachment = (JSONArray)(attObject = (JSONObject)JSONArray.parse((String)this.getPageCache().get(key))).get((Object)attachmentpanelName)) != null ? attachment.isEmpty() && attachmentList.isEmpty() : attObject.get((Object)attachmentpanelName) == null && attachmentList.isEmpty()) : attachmentList.isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String getFromId() {
        String fromId = "ten_questionclarify";
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        if ("resp".equals(appName)) {
            fromId = "resp_questionclarify";
        }
        return fromId;
    }

    private void setVisibleByMaterialpurAndRate() {
        IFormView view = this.getView();
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        int bidType = bidProject.getInt("bidtype");
        Boolean isratebidding = bidProject.getBoolean("isratebidding");
        if (bidType != 0) {
            view.setVisible(Boolean.TRUE, new String[]{"tenderprice", "tax", "pricevat", "notaxtenderprice"});
            this.setControlMustInput("tenderprice,tax,pricevat,notaxtenderprice");
            view.setVisible(Boolean.FALSE, new String[]{"rate", "projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"materialid", "materialname", "model", "baseunit", "materialdes", "qty", "inclutaxprice"});
            view.setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
            EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierdetail");
            entryEntityGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
            entryEntityGrid.setColumnProperty("taxrate", "l", (Object)55);
            if (bidType == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model"});
            }
            this.setControlMustInput("inclutaxprice,taxrate,bd_taxrate");
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "materialdes", "qty", "inclutaxprice", "resourceitem", "resitemname", "resourcemodel", "resourceunit"});
            view.setVisible(Boolean.TRUE, new String[]{"projectmanage", "workday"});
            view.setVisible(Boolean.TRUE, new String[]{"purentrycontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bd_taxrate"});
            if (isratebidding.booleanValue()) {
                view.setVisible(Boolean.FALSE, new String[]{"tenderprice", "tax", "pricevat", "notaxtenderprice"});
                view.setVisible(Boolean.TRUE, new String[]{"rate"});
                view.setVisible(Boolean.FALSE, new String[]{"purentrycontent", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
                view.setVisible(Boolean.TRUE, new String[]{"costrate"});
                this.setControlMustInput("costrate,rate");
            } else {
                view.setVisible(Boolean.TRUE, new String[]{"tenderprice", "pricevat", "tax", "notaxtenderprice"});
                this.setControlMustInput("tenderprice,tax,pricevat,notaxtenderprice");
                view.setVisible(Boolean.FALSE, new String[]{"rate"});
                view.setVisible(Boolean.TRUE, new String[]{"purentrycontent", "inclutaxamount", "taxrate", "taxamount", "excepttaxamount"});
                this.setControlMustInput("inclutaxamount,taxrate");
                view.setVisible(Boolean.FALSE, new String[]{"costrate"});
            }
        }
    }

    private void setControlMustInput(String arg0) {
        String[] arr;
        for (String thisArg : arr = arg0.split(",")) {
            FieldEdit purTypeControl = (FieldEdit)this.getView().getControl(thisArg);
            purTypeControl.setMustInput(true);
        }
    }

    private void setVisibleByResubmisstenders(Boolean resubmisstenders) {
        this.getView().setVisible(resubmisstenders, new String[]{"tax", "rate", "pricevat", "tenderprice", "notaxtenderprice", "technicaltenderattach", "businesstenderattach", "procuredetailpanel", "projectmanage", "workday"});
    }

    private void importDataFromlatestData(DynamicObject latestData) {
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        bidSectionEntry.clear();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidsectioncoll = latestData.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            int index = model.createNewEntryRow("bidsection");
            model.setValue("sectionname", bidsection.get("sectionname"), index);
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                model.setEntryCurrentRowIndex("bidsection", index);
                int supplierdetailIndex = model.createNewEntryRow("supplierdetail");
                model.setValue("pursupplier", supplierentry.get("pursupplier"), supplierdetailIndex);
                model.setValue("purentrycontent", supplierentry.get("purentrycontent"), supplierdetailIndex);
                model.setValue("materialid", supplierentry.get("materialid"), supplierdetailIndex);
                model.setValue("purentryproject", supplierentry.get("purentryproject"), supplierdetailIndex);
                model.setValue("materialdes", supplierentry.get("materialdes"), supplierdetailIndex);
                model.setValue("qty", supplierentry.get("qty"), supplierdetailIndex);
                model.setValue("inclutaxprice", supplierentry.get("inclutaxprice"), supplierdetailIndex);
                model.setValue("inclutaxamount", supplierentry.get("inclutaxamount"), supplierdetailIndex);
                model.setValue("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")), supplierdetailIndex);
                model.setValue("taxamount", supplierentry.get("taxamount"), supplierdetailIndex);
                model.setValue("excepttaxamount", supplierentry.get("excepttaxamount"), supplierdetailIndex);
                model.setValue("costrate", (Object)supplierentry.getBigDecimal("costrate").multiply(new BigDecimal("100")), supplierdetailIndex);
            }
        }
        model.endInit();
        this.getView().updateView("supplierdetail");
    }

    private String getAppId() {
        String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
        return appName;
    }

    private void importDataFromOpenBid(String clarifysupplier, boolean isAddOriginalAmount) {
        DynamicObject bidOpen;
        Log log = LogFactory.getLog(TenQuestionClarifyEdit.class);
        String[] values = clarifysupplier.split("&&");
        Long supplierId = Long.parseLong(values[0]);
        String clarifySectionName = "";
        if (values.length == 3) {
            clarifySectionName = values[2];
        }
        DynamicObject dataentity = this.getModel().getDataEntity(true);
        DynamicObject bidProject = (DynamicObject)this.getModel().getValue("bidproject");
        StringBuilder selectProper = new StringBuilder("id,bidsection,bidsection.sectionname,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.baseunit,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.bd_taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate");
        if ("resp".equals(this.getAppId())) {
            selectProper.append(",supplierdetail.listname,supplierdetail.listnumber,supplierdetail.resourceitem");
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)selectProper.toString(), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "J"})});
        } else {
            bidOpen = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)selectProper.toString(), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "J"})});
        }
        DynamicObjectCollection bidSectionEntry = dataentity.getDynamicObjectCollection("bidsection");
        bidSectionEntry.clear();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        DynamicObjectCollection bidsectioncoll = bidOpen.getDynamicObjectCollection("bidsection");
        boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        String sourceBillType = FormTypeConstants.getFormConstant((String)"supplier_file", ((Object)((Object)this)).getClass());
        String destinationBillType = dataentity.getDataEntityType().getName();
        ArrayList addUidList = new ArrayList();
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            String sectionName = bidsection.getString("sectionname");
            if (enablemultisection && !clarifySectionName.equals(sectionName)) continue;
            DynamicObjectCollection supplierDetail = bidsection.getDynamicObjectCollection("supplierdetail");
            int index = model.createNewEntryRow("bidsection");
            model.setValue("sectionname", (Object)clarifySectionName, index);
            for (int j = 0; j < supplierDetail.size(); ++j) {
                DynamicObject[] techAttachArray;
                DynamicObject supplierentry = (DynamicObject)supplierDetail.get(j);
                if (!supplierId.equals(((DynamicObject)supplierDetail.get(j)).getDynamicObject("pursupplier").getPkValue())) continue;
                for (DynamicObject techAttach : techAttachArray = BusinessDataServiceHelper.load((String)sourceBillType, (String)"id,type", (QFilter[])new QFilter[]{new QFilter("sectionid", "=", bidsection.getPkValue()), new QFilter("supplierid", "=", (Object)supplierId)})) {
                    if ("techFile".equals(techAttach.getString("type"))) {
                        Map techattReturnMap = BidFileHelper.copyFileFromAToBReturnMap((String)sourceBillType, (Object)techAttach.getPkValue(), (String)"attachmentpanelap", (String)destinationBillType, (Object)dataentity.getPkValue(), (String)"techattachment");
                        addUidList.addAll((Collection)techattReturnMap.get("addUidList"));
                        continue;
                    }
                    if ("comFile".equals(techAttach.getString("type"))) {
                        Map commattReturnMap = BidFileHelper.copyFileFromAToBReturnMap((String)sourceBillType, (Object)techAttach.getPkValue(), (String)"attachmentpanelap", (String)destinationBillType, (Object)dataentity.getPkValue(), (String)"commercattachment");
                        addUidList.addAll((Collection)commattReturnMap.get("addUidList"));
                        continue;
                    }
                    if (!"otherFile".equals(techAttach.getString("type"))) continue;
                    Map otherattReturnMap = BidFileHelper.copyFileFromAToBReturnMap((String)sourceBillType, (Object)techAttach.getPkValue(), (String)"attachmentpanelap", (String)destinationBillType, (Object)dataentity.getPkValue(), (String)"otherattachment");
                    addUidList.addAll((Collection)otherattReturnMap.get("addUidList"));
                }
                model.setEntryCurrentRowIndex("bidsection", index);
                int supplierdetailIndex = model.createNewEntryRow("supplierdetail");
                model.setValue("pursupplier", supplierentry.get("pursupplier"), supplierdetailIndex);
                model.setValue("purentrycontent", supplierentry.get("purentrycontent"), supplierdetailIndex);
                model.setValue("materialid", supplierentry.get("materialid"), supplierdetailIndex);
                model.setValue("baseunit", supplierentry.get("baseunit"), supplierdetailIndex);
                model.setValue("purentryproject", supplierentry.get("purentryproject"), supplierdetailIndex);
                model.setValue("materialdes", supplierentry.get("materialdes"), supplierdetailIndex);
                model.setValue("qty", supplierentry.get("qty"), supplierdetailIndex);
                model.setValue("bd_taxrate", supplierentry.get("bd_taxrate"), supplierdetailIndex);
                if ("resp_questionclarify".equals(this.getFromId())) {
                    model.setValue("resourceitem", supplierentry.get("resourceitem"), supplierdetailIndex);
                    model.setValue("listname", supplierentry.get("listname"), supplierdetailIndex);
                    model.setValue("listnumber", supplierentry.get("listnumber"), supplierdetailIndex);
                }
                if (!isAddOriginalAmount) continue;
                model.setValue("inclutaxprice", supplierentry.get("inclutaxprice"), supplierdetailIndex);
                model.setValue("inclutaxamount", supplierentry.get("inclutaxamount"), supplierdetailIndex);
                model.setValue("taxrate", (Object)supplierentry.getBigDecimal("taxrate").multiply(new BigDecimal("100")), supplierdetailIndex);
                model.setValue("taxamount", supplierentry.get("taxamount"), supplierdetailIndex);
                model.setValue("excepttaxamount", supplierentry.get("excepttaxamount"), supplierdetailIndex);
                model.setValue("costrate", (Object)supplierentry.getBigDecimal("costrate").multiply(new BigDecimal("100")), supplierdetailIndex);
            }
        }
        model.endInit();
        String cacheImportNewFileUid = "";
        int addUidListSize = addUidList.size();
        for (int k = 0; k < addUidListSize; ++k) {
            cacheImportNewFileUid = k == 0 ? (String)addUidList.get(k) : cacheImportNewFileUid + SPLITSTR + (String)addUidList.get(k);
        }
        log.info("TenQuestionClarifyEdit---" + cacheImportNewFileUid);
        this.getPageCache().put(CACHEIMPORTNEWFILEUIDS, cacheImportNewFileUid);
        this.getPageCache().remove(CACHESAVESUBMITSUCCESS);
        this.getView().updateView("supplierdetail");
        this.getView().updateView("techattachment");
        this.getView().updateView("commercattachment");
        this.getView().updateView("otherattachment");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control contractTab = this.getView().getControl("tabap");
        ((Tab)contractTab).addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        if ("questiontab".equals(tabKey) && !"1".equals(this.getPageCache().get("open"))) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object supplierId = formShowParameter.getCustomParam("supplierId");
            Long multiquestclarifyId = dataEntity.getLong("multiquestclarifyid");
            String sectionName = (String)formShowParameter.getCustomParam("sectionName");
            FormShowParameter newFormShowParameter = new FormShowParameter();
            String appName = ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
            newFormShowParameter.setFormId(appName + "_query_letters");
            newFormShowParameter.setCustomParam("multiquestclarifyId", (Object)multiquestclarifyId);
            newFormShowParameter.setCustomParam("currentSupplierId", supplierId);
            newFormShowParameter.setCustomParam("sectionName", (Object)sectionName);
            newFormShowParameter.setCustomParam("originPage", (Object)"questclarify");
            newFormShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            newFormShowParameter.getOpenStyle().setTargetKey(tabKey);
            newFormShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(newFormShowParameter);
            this.getPageCache().put("open", "1");
        }
    }
}

