/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.edit;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.ClarifyStatusEnum;

public class TenQuestionClarifyShowEdit
extends AbstractFormPlugin
implements TabSelectListener {
    private String ACTIVETABKEY = "";
    private Long supplierId = 0L;
    private Long bidprojectId = 0L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control contractTab = this.getView().getControl("bidsectiontab");
        ((Tab)contractTab).addTabSelectListener((TabSelectListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Map<String, String> unclarifySectionInfoMap = this.getUnclarifySectionInfo(formShowParameter);
        TabAp tab = this.createDynamicTabAp(unclarifySectionInfoMap);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "bidsectiontab");
        mapHead.put("items", (String)tab.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    protected TabAp createDynamicTabAp(Map<String, String> unclarifySectionInfoMap) {
        TabAp tabAp = new TabAp();
        int i = 0;
        for (Map.Entry<String, String> unclarifySectionInfo : unclarifySectionInfoMap.entrySet()) {
            tabAp.setKey("bidsectiontab" + i);
            TabPageAp tpa = this.createTabPageAp(unclarifySectionInfo);
            tabAp.getItems().add(tpa);
        }
        return tabAp;
    }

    protected TabPageAp createTabPageAp(Map.Entry<String, String> unclarifySectionInfo) {
        TabPageAp tpa = new TabPageAp();
        tpa.setKey(unclarifySectionInfo.getKey() + "_tab");
        tpa.setId(unclarifySectionInfo.getKey());
        String str = String.format(ResManager.loadKDString((String)"%s\u9879\u76ee", (String)"TenQuestionClarifyShowEdit_0", (String)"scm-ten-formplugin", (Object[])new Object[0]), unclarifySectionInfo.getValue());
        tpa.setName(new LocaleString(str));
        return tpa;
    }

    protected Map<String, String> getUnclarifySectionInfo(FormShowParameter billShowParameter) {
        LinkedHashMap<String, String> sectionMap = new LinkedHashMap<String, String>();
        this.supplierId = (Long)billShowParameter.getCustomParam("supplierId");
        this.bidprojectId = (Long)billShowParameter.getCustomParam("bidprojectId");
        DynamicObject[] questions = this.getQuestions(this.bidprojectId, this.supplierId);
        if (questions.length > 0) {
            for (DynamicObject question : questions) {
                Long questionId = (Long)question.getPkValue();
                DynamicObjectCollection bidsection = question.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidsection.size(); ++i) {
                    DynamicObject section = (DynamicObject)bidsection.get(i);
                    if (i == 0) {
                        this.ACTIVETABKEY = questionId + "@@" + section.getString("sectionname") + "_tab";
                    }
                    sectionMap.put(questionId + "@@" + section.getString("sectionname"), section.getString("sectionname"));
                }
            }
        }
        return sectionMap;
    }

    protected DynamicObject[] getQuestions(Object bidprojectId, Object supplierId) {
        String entityName = null;
        entityName = this.getModel() == null ? FormTypeConstants.getFormConstant((String)"questionclarify", ((Object)((Object)this)).getClass()) : this.getModel().getDataEntityType().getAppId() + "_questionclarify";
        DynamicObjectCollection questions = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidprojectId), new QFilter("clarifysupplier", "like", (Object)(supplierId + "%")), new QFilter("clarifydeadline", ">", (Object)new Date()), new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue()), new QFilter("is_again_bidding", "!=", (Object)"1")});
        List<Long> id = questions.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((Object[])id.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Tab tab = (Tab)this.getView().getControl("bidsectiontab");
        tab.activeTab(this.ACTIVETABKEY);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        String key = tabKey.split("\\_")[0];
        String questionId = key.split("@@")[0];
        if (questionId != null) {
            if (this.getPageCache().get(questionId) != null) {
                return;
            }
            this.getPageCache().put(questionId, "true");
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId(this.getModel().getDataEntityType().getAppId() + "_questionclarify");
            billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            billShowParameter.getOpenStyle().setTargetKey(tabKey);
            billShowParameter.setPkId((Object)Long.valueOf(questionId));
            if (this.getView().getFormShowParameter().getCustomParam("supplierId") != null) {
                String supplierIdStr = this.getView().getFormShowParameter().getCustomParam("supplierId").toString();
                this.supplierId = Long.parseLong(supplierIdStr);
            }
            this.bidprojectId = (Long)this.getView().getFormShowParameter().getCustomParam("bidprojectId");
            billShowParameter.setCustomParam("supplierId", (Object)this.supplierId);
            billShowParameter.setCustomParam("bidprojectId", (Object)this.bidprojectId);
            billShowParameter.setCustomParam("sectionName", (Object)key.split("@@")[1]);
            billShowParameter.setBillStatus(BillOperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.supplierId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("supplierId").toString());
        this.bidprojectId = (Long)this.getView().getFormShowParameter().getCustomParam("bidprojectId");
        DynamicObject[] questions = this.getQuestions(this.bidprojectId, this.supplierId);
        String operateKey = args.getOperateKey();
        String entityType = this.getModel().getDataEntityType().getAppId() + "_questionclarify";
        if (questions.length > 0) {
            for (DynamicObject question : questions) {
                String sonPageId = this.getView().getPageCache().get(String.valueOf(question.getPkValue()));
                if (sonPageId == null) {
                    this.invokeQuestionClarifyOperate(operateKey, new DynamicObject[]{question}, entityType);
                    continue;
                }
                IFormView sonPageView = this.getView().getView(sonPageId);
                if (sonPageView == null) continue;
                if ("save".equals(operateKey)) {
                    sonPageView.invokeOperation("save");
                } else if ("submit".equals(operateKey)) {
                    sonPageView.invokeOperation("submit");
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
                    this.getView().updateView("toolbarap");
                }
                this.getView().sendFormAction(sonPageView);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"TenQuestionClarifyShowEdit_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void invokeQuestionClarifyOperate(String operateKey, DynamicObject[] questions, String entityType) {
        try (TXHandle h = TX.requiresNew();){
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)operateKey, (String)entityType, (DynamicObject[])questions, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null && result.getValidateResult().getValidateErrors().size() > 0 && ((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo() != null && ((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().size() > 0) {
                        throw new KDBizException(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
                    }
                    if (result.getAllErrorInfo() != null && result.getAllErrorInfo().size() > 0) {
                        throw new KDBizException(((OperateErrorInfo)result.getAllErrorInfo().get(0)).getMessage());
                    }
                }
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }
}

