/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.list;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.formplugin.bill.util.BidHistoryUtil;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.formplugin.base.TenBaseListPlugin;

public class MyTenderHisListPlugin
extends TenBaseListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        final String viewhistory = (String)parameter.getCustomParam("viewhistory");
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection rows = super.getData(arg0, arg1);
                if (rows.isEmpty()) {
                    return rows;
                }
                if (StringUtils.isNotEmpty((CharSequence)viewhistory)) {
                    return MyTenderHisListPlugin.this.ListTenderHis(rows);
                }
                return rows;
            }
        });
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        Object supplier = parameter.getCustomParam("supplier");
        if (StringUtils.isEmpty((CharSequence)viewhistory)) {
            filters.add(BidHistoryUtil.getDocumentListQFilter());
        } else {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            filters.add(BidHistoryUtil.getTenderHistoryQFilter((Object)bidProjectId, (Object)supplier));
        }
        super.setFilter(e);
    }

    protected DynamicObjectCollection ListTenderHis(DynamicObjectCollection rows) {
        for (int i = 0; i < rows.size(); ++i) {
            DynamicObject row = (DynamicObject)rows.get(i);
            Long id = row.getLong("id");
            String tenderamount = this.getTenderamount(id);
            row.set("notaxpricelist", (Object)tenderamount);
        }
        return rows;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String viewhistory = (String)parameter.getCustomParam("viewhistory");
        if (StringUtils.isNotEmpty((CharSequence)viewhistory)) {
            Object bidProjectId = parameter.getCustomParam("bidProjectId");
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            boolean showRateAmount = project.getBoolean("isratebidding");
            if (showRateAmount) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"notaxpricelist"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"rate"});
            }
        }
    }

    private Date getAuditDate(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        String entityName = TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass());
        DynamicObject bidding = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,auditdate", (QFilter[])new QFilter[]{filter});
        if (bidding != null) {
            return bidding.getDate("auditdate");
        }
        return null;
    }

    private String getTenderamount(Long id) {
        DynamicObjectCollection biddinEntryColl;
        QFilter filter = new QFilter("id", "=", (Object)id);
        String entityName = TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass());
        DynamicObject bidding = BusinessDataServiceHelper.loadSingle((String)entityName, (String)"id,entry.id,entry.sectionname,entry.tenderprice,price", (QFilter[])new QFilter[]{filter});
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (bidding != null && (biddinEntryColl = bidding.getDynamicObjectCollection("entry")) != null && !biddinEntryColl.isEmpty()) {
            for (DynamicObject mytenderEntry : biddinEntryColl) {
                String sectionname = mytenderEntry.getString("sectionname");
                BigDecimal tenderprice = mytenderEntry.getBigDecimal("tenderprice");
                BigDecimal amount = map.getOrDefault(sectionname, BigDecimal.ZERO).add(tenderprice.setScale(2, 4));
                map.put(sectionname, amount);
            }
            if (map.size() > 1) {
                StringJoiner amountStr = new StringJoiner(" ");
                for (Map.Entry entry : map.entrySet()) {
                    BigDecimal amount = (BigDecimal)entry.getValue();
                    amountStr.add((String)entry.getKey() + ":" + amount);
                }
                return amountStr.toString();
            }
            if (map.size() == 1) {
                BigDecimal notaxprice = (BigDecimal)map.values().toArray()[0];
                return notaxprice.setScale(2, 4).toString();
            }
            BigDecimal price = bidding.getBigDecimal("price");
            if (price != null) {
                return price.setScale(2, 4).toString();
            }
        }
        return "";
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"listrounds", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            Object biddingId = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            Object mytenderId = BusinessDataServiceHelper.loadSingle((Object)biddingId, (String)TenFormTypeConstants.getFormConstant((String)"bidding_his", ((Object)((Object)this)).getClass())).get("mytender.id");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(TenFormTypeConstants.getFormConstant((String)"bidding", ((Object)((Object)this)).getClass()));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPkId(biddingId);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("mytenderId", mytenderId);
            showParameter.setCustomParam("biddingId", biddingId);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

