/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.list;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.SupplierHelper;
import kd.scm.ten.formplugin.base.TenBaseListPlugin;

public class QuestionRecordDetailListPlugin
extends TenBaseListPlugin {
    private static final String CACHE_ID_INNER_FILTER = "cache_id_inner_filter";
    private static final String CACHE_SUPPLIER_ID = "cache_supplier_id";
    private static final String CACHE_MYQUESTION_ID_STR = "cache_myquestion_id_str";
    private static final String CACHE_SPECIFIC_RECOENTRY_ID_STR = "cache_specific_RecoEntry_id_Str";
    private static final String CACHE_QUESTION_TIME = "cache_question_time";
    private static final String CACHE_ANSWER_TIME = "cache_answer_time";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long bidProjectID = (Long)this.getView().getFormShowParameter().getCustomParam("bidProjectID");
        IPageCache pageCache = this.getPageCache();
        if (bidProjectID != null) {
            DynamicObject[] myQuestionArr;
            StringBuilder myquestionIdStr = new StringBuilder();
            for (DynamicObject myQuestion : myQuestionArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ten_question"), (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)bidProjectID), new QFilter("creator.id", "=", (Object)RequestContext.get().getUserId())}).values().toArray(new DynamicObject[0])) {
                myquestionIdStr.append(myQuestion.getPkValue());
                myquestionIdStr.append('|');
            }
            pageCache.put(CACHE_MYQUESTION_ID_STR, myquestionIdStr.toString());
        } else {
            pageCache.put(CACHE_MYQUESTION_ID_STR, "");
        }
    }

    public void setFilter(SetFilterEvent e) {
        String idInnerFilter = null;
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get(CACHE_ID_INNER_FILTER) != null) {
            idInnerFilter = pageCache.get(CACHE_ID_INNER_FILTER);
        } else {
            Long bidProjectID = (Long)this.getView().getFormShowParameter().getCustomParam("bidProjectID");
            DynamicObject supplier = SupplierHelper.getSupplierByUserId((String)RequestContext.get().getUserId());
            if (bidProjectID == null || supplier == null) {
                idInnerFilter = "null";
            } else {
                DynamicObject[] questionRecoArr;
                pageCache.put(CACHE_SUPPLIER_ID, supplier.getPkValue().toString());
                StringBuilder questionRecoEntryIDStr = new StringBuilder();
                StringBuilder specificRecoEntryIDStr = new StringBuilder();
                for (DynamicObject questionReco : questionRecoArr = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", ((Object)((Object)this)).getClass())), (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)bidProjectID)}).values().toArray(new DynamicObject[0])) {
                    for (DynamicObject questionRecoEntry : questionReco.getDynamicObjectCollection("bid_answerquestions_list")) {
                        boolean mark = false;
                        if ((BillStatusEnum.AUDITED.getVal().equals(questionReco.getString("billStatus")) || BillStatusEnum.INVALID.getVal().equals(questionReco.getString("billStatus"))) && questionRecoEntry.getBoolean("issend")) {
                            mark = true;
                            questionRecoEntryIDStr.append(questionRecoEntry.getPkValue());
                            questionRecoEntryIDStr.append('|');
                        } else if (questionRecoEntry.getDynamicObject("proposedunit") != null && questionRecoEntry.getBoolean("isfromten")) {
                            mark = true;
                            questionRecoEntryIDStr.append(questionRecoEntry.getPkValue());
                            questionRecoEntryIDStr.append('|');
                            specificRecoEntryIDStr.append(questionRecoEntry.getPkValue());
                            specificRecoEntryIDStr.append('|');
                        }
                        if (!mark) continue;
                        Date questionTime = null;
                        Date answerTime = questionReco.getDate("answerquestiontime");
                        questionTime = questionRecoEntry.getDynamicObject("proposedunit") != null && questionRecoEntry.getBoolean("isfromten") && questionRecoEntry.getDynamicObject("tenquestionid") != null ? questionRecoEntry.getDynamicObject("tenquestionid").getDate("createtime") : questionReco.getDate("answerquestiontime");
                        if (questionTime != null) {
                            pageCache.put("cache_question_time|" + questionRecoEntry.getPkValue(), Long.toString(questionTime.getTime()));
                        }
                        if (answerTime == null) continue;
                        pageCache.put("cache_answer_time|" + questionRecoEntry.getPkValue(), Long.toString(answerTime.getTime()));
                    }
                }
                idInnerFilter = questionRecoEntryIDStr.length() > 0 ? questionRecoEntryIDStr.substring(0, questionRecoEntryIDStr.length() - 1) : "null";
                pageCache.put(CACHE_ID_INNER_FILTER, idInnerFilter);
                pageCache.put(CACHE_SPECIFIC_RECOENTRY_ID_STR, specificRecoEntryIDStr.toString());
            }
        }
        List filters = e.getQFilters();
        filters.add(new QFilter("id", "in", new HashSet<String>(Arrays.asList(idInnerFilter.split("\\|")))));
        super.setFilter(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                IPageCache pageCache = QuestionRecordDetailListPlugin.this.getPageCache();
                String specificRecoEntryIDStr = pageCache.get(QuestionRecordDetailListPlugin.CACHE_SPECIFIC_RECOENTRY_ID_STR);
                String myQuestionIDStr = pageCache.get(QuestionRecordDetailListPlugin.CACHE_MYQUESTION_ID_STR);
                for (DynamicObject row : rows) {
                    String answerTimeStr;
                    long tenquestionid = row.getLong("tenquestionid");
                    if (tenquestionid != 0L && myQuestionIDStr.contains(Long.toString(tenquestionid))) {
                        row.set("isfromten", (Object)Boolean.TRUE);
                    } else {
                        row.set("isfromten", (Object)Boolean.FALSE);
                    }
                    String questionTimeStr = pageCache.get("cache_question_time|" + row.getPkValue());
                    if (!StringUtils.isEmpty((String)questionTimeStr)) {
                        row.set("createtime", (Object)new Date(Long.parseLong(questionTimeStr)));
                    }
                    if (!StringUtils.isEmpty((String)(answerTimeStr = pageCache.get("cache_answer_time|" + row.getPkValue())))) {
                        row.set("modifytime", (Object)new Date(Long.parseLong(answerTimeStr)));
                    }
                    if (!specificRecoEntryIDStr.contains(row.getPkValue().toString())) continue;
                    row.set("questionanswer", null);
                    row.set("modifytime", null);
                }
                rows.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        Date date1 = o1.getDate("createtime");
                        Date date2 = o2.getDate("createtime");
                        if (date1 == null && date2 == null) {
                            return 0;
                        }
                        if (date1 == null && date2 != null) {
                            return 1;
                        }
                        if (date1 != null && date2 == null) {
                            return -1;
                        }
                        return Math.abs(date1.compareTo(date2));
                    }
                });
                return rows;
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        BillList billList = (BillList)this.getControl("billlistap");
        String key = afterDoOperationEventArgs.getOperateKey();
        if (key.equals("questionfile") || key.equals("answerfile")) {
            String specificRecoEntryIDStr;
            Long focusRowPkId = (Long)billList.getFocusRowPkId();
            if (key.equals("answerfile") && (specificRecoEntryIDStr = this.getPageCache().get(CACHE_SPECIFIC_RECOENTRY_ID_STR)).contains(focusRowPkId.toString())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684\u201c\u7b54\u590d\u9644\u4ef6\u201d\u3002", (String)"QuestionRecordDetailListPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bidAnswerFile = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"answer_file", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("answerid", "=", (Object)focusRowPkId), new QFilter("type", "=", (Object)key)});
            if (bidAnswerFile == null) {
                String s = key.equals("questionfile") ? ResManager.loadKDString((String)"\u201c\u63d0\u95ee\u9644\u4ef6\u201d\u3002", (String)"QuestionRecordDetailListPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b54\u590d\u9644\u4ef6\u3002", (String)"QuestionRecordDetailListPlugin_2", (String)"scm-ten-formplugin", (Object[])new Object[0]);
                String str = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684%s", (String)"QuestionRecordDetailListPlugin_3", (String)"scm-ten-formplugin", (Object[])new Object[0]), s);
                this.getView().showTipNotification(str);
                return;
            }
            List attachment = AttachmentServiceHelper.getAttachments((String)FormTypeConstants.getFormConstant((String)"answer_file", ((Object)((Object)this)).getClass()), (Object)bidAnswerFile.getPkValue(), (String)"attachmentpanelap");
            if (attachment.isEmpty()) {
                String s = key.equals("questionfile") ? ResManager.loadKDString((String)"\u201c\u63d0\u95ee\u9644\u4ef6\u201d\u3002", (String)"QuestionRecordDetailListPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7b54\u590d\u9644\u4ef6\u3002", (String)"QuestionRecordDetailListPlugin_2", (String)"scm-ten-formplugin", (Object[])new Object[0]);
                String str = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8f7d\u7684%s", (String)"QuestionRecordDetailListPlugin_3", (String)"scm-ten-formplugin", (Object[])new Object[0]), s);
                this.getView().showTipNotification(str);
                return;
            }
            for (int j = 0; j < attachment.size(); ++j) {
                Map atta = (Map)attachment.get(j);
                String url = atta.get("url").toString();
                this.getView().download(url);
            }
        }
    }
}

