/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.onlinebid;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenOnlineBidDetailEditPlugin
extends AbstractBillPlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initTenDidDetail();
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlMustInputVisible();
        this.setRebackPanleVisiable();
        this.setRePublishPanleVisiable();
    }

    private void setRePublishPanleVisiable() {
        List<Object> supplierPkArray;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParamMap = (Map)formShowParameter.getCustomParam("parentParam");
        Object bidProjectId = customParamMap.get("bidProjectId");
        int rounds = (Integer)customParamMap.get("rounds");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String appId = dataEntity.getDynamicObjectType().getName().split("_")[0];
        String bidAppId = "ten".equalsIgnoreCase(appId) ? "bid" : "rebm";
        DynamicObject[] load = BusinessDataServiceHelper.load((String)(bidAppId + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
        boolean isnew = false;
        boolean isnew_invitation = false;
        DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(bidAppId + "_bidpublish"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("isnewbill", "=", (Object)Character.valueOf('1'))});
        Object source = bidPublish.get("source");
        List<Object> list = supplierPkArray = "ten".equalsIgnoreCase(appId) ? SupplierUtil.getSupplierPkArray() : SupplierUtil.getRESMSupplierByUserPkArray();
        if (null != bidPublish) {
            DynamicObjectCollection bidSections = bidPublish.getDynamicObjectCollection("bidsection");
            OrmLocaleValue sectionnames = (OrmLocaleValue)this.getModel().getValue("sectionname");
            String sectionName = sectionnames.getLocaleValue();
            for (int i = 0; i < bidSections.size(); ++i) {
                OrmLocaleValue publish_SectionNames = (OrmLocaleValue)((DynamicObject)bidSections.get(i)).get("sectionname");
                String publish_SectionName = publish_SectionNames.getLocaleValue();
                if (!publish_SectionName.equals(sectionName)) continue;
                DynamicObjectCollection supplierentry = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierentry.size(); ++j) {
                    if (!((DynamicObject)supplierentry.get(j)).getDynamicObject("supplier").getPkValue().equals(supplierPkArray.get(0))) continue;
                    isnew = ((DynamicObject)supplierentry.get(j)).getBoolean("isnew");
                }
            }
        }
        boolean fromReBackBid = (Boolean)customParamMap.get("fromReBackBid");
        DynamicObject supplierInvitation = BusinessDataServiceHelper.loadSingle((String)(bidAppId + "_supplierinvitation"), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "=", (Object)"C")});
        DynamicObject[] supplierInvitations = BusinessDataServiceHelper.load((String)(bidAppId + "_supplierinvitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId)});
        if (null != supplierInvitation && supplierInvitations.length != 1) {
            DynamicObjectCollection bidSections_invitation = supplierInvitation.getDynamicObjectCollection("bidsection");
            OrmLocaleValue sectionnames = (OrmLocaleValue)this.getModel().getValue("sectionname");
            String sectionName = sectionnames.getLocaleValue_zh_CN();
            for (int i = 0; i < bidSections_invitation.size(); ++i) {
                OrmLocaleValue invitation_SectionNames = (OrmLocaleValue)((DynamicObject)bidSections_invitation.get(i)).get("sectionname");
                String invitation_SectionName = invitation_SectionNames.getLocaleValue_zh_CN();
                if (!invitation_SectionName.equals(sectionName)) continue;
                DynamicObjectCollection supplierentry = ((DynamicObject)bidSections_invitation.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierentry.size(); ++j) {
                    if (!((DynamicObject)supplierentry.get(j)).getDynamicObject("supplier").getPkValue().equals(supplierPkArray.get(0))) continue;
                    isnew_invitation = ((DynamicObject)supplierentry.get(j)).getBoolean("isnew");
                }
            }
        }
        if (load.length > 1) {
            if (isnew) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"republishpanle"});
            } else if (isnew_invitation && "resupplierInvitation".equals(source)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"republishpanle"});
            } else if (fromReBackBid) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"republishpanle"});
            } else if (rounds == 1) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"republishpanle"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"republishpanle"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"republishpanle"});
        }
    }

    protected void setRebackPanleVisiable() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParamMap = (Map)formShowParameter.getCustomParam("parentParam");
        boolean fromReBackBid = (Boolean)customParamMap.get("fromReBackBid");
        this.getView().setVisible(Boolean.valueOf(fromReBackBid), new String[]{"rebackpanle"});
    }

    public void initTenDidDetail() {
        Object bidType;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParamMap = (Map)formShowParameter.getCustomParam("parentParam");
        Object myTenderId = customParamMap.get("myTenderId");
        Object bidProjectId = customParamMap.get("bidProjectId");
        String sectionId = customParamMap.get("sectionId").toString();
        String sectionName = customParamMap.get("sectionName").toString();
        String sectionStatus = customParamMap.get("sectionStatus").toString();
        String backBidWay = customParamMap.get("backBidWay").toString();
        String backBidType = customParamMap.get("backBidType").toString();
        Object supplierId = customParamMap.get("supplierId");
        Object onlineBidId = customParamMap.get("onlineBidId");
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection supplierDetailCol = dataEntity.getDynamicObjectCollection("supplierdetail");
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle(bidProjectId, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            this.getModel().setValue("bidproject", bidProjectId);
            this.getModel().setValue("projectsectionid", (Object)sectionId);
            this.getModel().setValue("sectionname", (Object)sectionName);
            this.getModel().setValue("sectionstatus", (Object)sectionStatus);
            this.getModel().setValue("onlinebidid", onlineBidId);
            this.getModel().setValue("currency", bidProject.get("currency"));
            this.getModel().setValue("mytenderid", myTenderId);
            this.getModel().setValue("backbidtype", (Object)backBidType);
            this.getModel().setValue("backbidway", (Object)backBidWay);
            bidType = bidProject.getString("bidtype");
            DynamicObjectCollection projectSectionCol = bidProject.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < projectSectionCol.size(); ++i) {
                DynamicObject projectSection = (DynamicObject)projectSectionCol.get(i);
                if (!sectionId.equals(projectSection.getPkValue().toString())) continue;
                this.getModel().setValue("workday", projectSection.get("workload"));
                DynamicObjectCollection projectEntryCol = projectSection.getDynamicObjectCollection("projectentry");
                for (DynamicObject projectEntry : projectEntryCol) {
                    DynamicObject supplierDetail = supplierDetailCol.addNew();
                    supplierDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
                    supplierDetail.set("materialid", projectEntry.get("materialid"));
                    supplierDetail.set("baseunit", projectEntry.get("baseunit"));
                    supplierDetail.set("purentryproject", projectEntry.get("purentryproject"));
                    supplierDetail.set("materialdes", projectEntry.get("materialdes"));
                    supplierDetail.set("qty", projectEntry.get("qty"));
                    if (!BidTypeEnum.RESOURCE.getValue().equals(bidType)) continue;
                    supplierDetail.set("resourceitem", projectEntry.get("resourceitem"));
                }
            }
        }
        supplierDetailCol.forEach(entry -> entry.getDataEntityState().setPushChanged(true));
        TXHandle h = TX.requiresNew();
        bidType = null;
        try {
            try {
                this.copyDescAndAttachFromRePublish(sectionName, supplierId, bidProjectId, dataEntity);
            }
            catch (Throwable e) {
                throw new KDBizException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            bidType = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (bidType != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)bidType).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        BigDecimal pricevat = dataEntity.getBigDecimal("pricevat").multiply(new BigDecimal("100"));
        dataEntity.set("pricevat", (Object)pricevat);
        BigDecimal rate = dataEntity.getBigDecimal("rate").multiply(new BigDecimal("100"));
        dataEntity.set("rate", (Object)rate);
        for (DynamicObject supplierDetail : supplierDetailCol) {
            BigDecimal taxRate = supplierDetail.getBigDecimal("taxrate").multiply(new BigDecimal("100"));
            BigDecimal costRate = supplierDetail.getBigDecimal("costrate").multiply(new BigDecimal("100"));
            supplierDetail.set("taxrate", (Object)taxRate);
            supplierDetail.set("costrate", (Object)costRate);
        }
    }

    public void copyDescAndAttachFromRePublish(String sectionName, Object supplierId, Object bidProjectId, DynamicObject dataEntity) {
        String appId = dataEntity.getDynamicObjectType().getName().split("_")[0];
        String bidAppId = "ten".equalsIgnoreCase(appId) ? "bid" : "rebm";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParamMap = (Map)formShowParameter.getCustomParam("parentParam");
        int rounds = (Integer)customParamMap.get("rounds");
        Object bidPublishId = customParamMap.get("bidpublishid");
        DynamicObject[] bidPublishs = BusinessDataServiceHelper.load((String)(bidAppId + "_bidpublish"), (String)"bidsection,sectionname,supplierentry,supplier,repdescription,tenderstrategy,republishattachment", (QFilter[])new QFilter[]{new QFilter("id", "=", bidPublishId)});
        if (bidPublishs.length == 0) {
            return;
        }
        DynamicObject rebackBid = bidPublishs[0];
        DynamicObjectCollection bidsection = rebackBid.getDynamicObjectCollection("bidsection");
        Optional<DynamicObject> sectionEntry = bidsection.stream().filter(section -> section.getString("sectionname").equals(sectionName)).findFirst();
        if (!sectionEntry.isPresent()) {
            return;
        }
        DynamicObjectCollection supplierentry = sectionEntry.get().getDynamicObjectCollection("supplierentry");
        Optional<DynamicObject> supEntry = supplierentry.stream().filter(entry -> "NEEDBID".equals(entry.get("tenderstrategy")) || "".equals(entry.get("tenderstrategy"))).filter(entry -> String.valueOf(entry.getDynamicObject("supplier").getPkValue()).equals(String.valueOf(supplierId))).findFirst();
        if (!supEntry.isPresent()) {
            return;
        }
        DynamicObject entry2 = supEntry.get();
        String privateDesc = entry2.getString("repdescription");
        if (privateDesc != null && !privateDesc.isEmpty()) {
            dataEntity.set("republishdesc", (Object)privateDesc);
        } else {
            dataEntity.set("republishdesc", (Object)"");
        }
        DynamicObjectCollection attachments = entry2.getDynamicObjectCollection("republishattachment");
        HashSet<Object> attachIdSet = new HashSet<Object>(16);
        if (attachments.size() > 0) {
            for (DynamicObject attachment : attachments) {
                DynamicObject data = attachment.getDynamicObject("fbasedataid");
                Object attachId = data.getPkValue();
                attachIdSet.add(attachId);
            }
        }
        AttachmentPanel control = (AttachmentPanel)this.getView().getControl("republishattach");
        List attachmentData = control.getAttachmentData();
        for (Map map : attachmentData) {
            String formId = map.get("entityNum").toString();
            Object pkId = map.get("billPkId");
            Object fileUid = map.get("uid");
            AttachmentServiceHelper.remove((String)formId, pkId, fileUid);
            control.remove(map);
        }
        AttachmentUtil.copyAttachFieldToAttachPanelByAttachId(attachIdSet, (String)dataEntity.getDataEntityType().getName(), (Object)dataEntity.get("id"), (String)"republishattach");
    }

    public void setControlMustInputVisible() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        Boolean isRateBidDing = bidProject.getBoolean("isratebidding");
        String bidType = bidProject.getString("bidtype");
        if (isRateBidDing.booleanValue()) {
            FieldEdit tenderPrice = (FieldEdit)this.getView().getControl("tenderprice");
            tenderPrice.setMustInput(false);
            FieldEdit priceVatFieldEdit = (FieldEdit)this.getView().getControl("pricevat");
            priceVatFieldEdit.setMustInput(false);
            FieldEdit rate = (FieldEdit)this.getView().getControl("rate");
            rate.setMustInput(true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"tenderprice", "pricevat"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"rate"});
            if (BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                FieldEdit costRateEdit = (FieldEdit)this.getView().getControl("costrate");
                costRateEdit.setMustInput(true);
                this.getView().setEnable(Boolean.TRUE, new String[]{"pricevat"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"projectmanage", "workday", "rate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"tenderprice", "notaxtenderprice", "tax"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"inclutaxprice", "inclutaxamount", "taxrate", "bd_taxrate", "taxamount", "excepttaxamount", "materialname", "materialid", "materialdes", "model", "unit", "baseunit", "qty", "resourceitem", "resitemname", "resourcemodel", "resourceunit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"costrate"});
                FieldEdit taxRatePrice = (FieldEdit)this.getView().getControl("taxrate");
                taxRatePrice.setMustInput(false);
            }
        } else {
            FieldEdit rate = (FieldEdit)this.getView().getControl("rate");
            rate.setMustInput(false);
            this.getView().setVisible(Boolean.TRUE, new String[]{"tenderprice", "pricevat"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"rate", "costrate"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"tenderprice", "notaxtenderprice", "tax", "pricevat"});
            if (!BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"pricevat", "tenderprice", "baseunit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"projectmanage", "workday", "rate"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "costrate"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"tenderprice", "notaxtenderprice", "tax", "pricevat"});
                EntryGrid entryEntityGrid = (EntryGrid)this.getControl("supplierdetail");
                entryEntityGrid.setColumnProperty("inclutaxamount", "l", (Object)55);
                entryEntityGrid.setColumnProperty("taxrate", "l", (Object)55);
                FieldEdit purTypeControl = (FieldEdit)this.getView().getControl("bd_taxrate");
                purTypeControl.setMustInput(true);
                FieldEdit includeTaxPriceControl = (FieldEdit)this.getView().getControl("inclutaxprice");
                includeTaxPriceControl.setMustInput(true);
                FieldEdit taxRateControl = (FieldEdit)this.getView().getControl("taxrate");
                taxRateControl.setMustInput(true);
                if (BidTypeEnum.MATERIAL.getValue().equals(bidType)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"resourceitem", "resitemname", "resourcemodel", "resourceunit"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"purentrycontent", "materialid", "materialname", "model", "unit"});
                }
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"projectmanage", "workday"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"purentrycontent"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"materialid", "materialname", "model", "unit", "baseunit", "materialdes", "qty", "inclutaxprice", "resourceitem", "resitemname", "resourcemodel", "resourceunit", "bd_taxrate", "baseunit"});
                this.getView().setEnable(Boolean.TRUE, new String[]{"inclutaxamount", "projectmanage"});
                FieldEdit includeTaxAmountPriceEdit = (FieldEdit)this.getView().getControl("inclutaxamount");
                includeTaxAmountPriceEdit.setMustInput(true);
                FieldEdit taxRateEdit = (FieldEdit)this.getView().getControl("taxrate");
                taxRateEdit.setMustInput(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String filedName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxprice") || StringUtils.equals((CharSequence)filedName, (CharSequence)"taxrate") || StringUtils.equals((CharSequence)filedName, (CharSequence)"inclutaxamount")) {
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            ChangeData[] dataSet = args.getChangeSet();
            ChangeData changedata = dataSet[0];
            int index = changedata.getRowIndex();
            BigDecimal sumIncludeTaxPrice = BigDecimal.ZERO;
            BigDecimal sumTaxRate = BigDecimal.ZERO;
            BigDecimal sumTaxAmount = BigDecimal.ZERO;
            BigDecimal sumExceptTaxAmount = BigDecimal.ZERO;
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
            String bidType = bidProject.getString("bidtype");
            DynamicObjectCollection supplierDetailCol = dataEntity.getDynamicObjectCollection("supplierdetail");
            DynamicObject supplierDetailRow = (DynamicObject)supplierDetailCol.get(index);
            if (!BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                BigDecimal includeTaxPrice = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxprice")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxprice");
                BigDecimal qty = supplierDetailRow.getBigDecimal("qty");
                BigDecimal includeTaxAmount = qty.multiply(includeTaxPrice).setScale(10, 4);
                BigDecimal taxRate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxAmount = includeTaxAmount.multiply(taxRate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxRate.divide(new BigDecimal("100"))), 10, 4);
                this.getModel().setValue("taxamount", (Object)taxAmount, index);
            } else {
                BigDecimal includeTaxAmount = Objects.isNull(supplierDetailRow.getBigDecimal("inclutaxamount")) ? BigDecimal.ZERO : supplierDetailRow.getBigDecimal("inclutaxamount");
                BigDecimal taxRate = supplierDetailRow.getBigDecimal("taxrate");
                BigDecimal taxAmount = includeTaxAmount.multiply(taxRate.divide(new BigDecimal("100"))).divide(new BigDecimal(1).add(taxRate.divide(new BigDecimal("100"))), 10, 4);
                this.getModel().setValue("taxamount", (Object)taxAmount, index);
            }
            HashSet<BigDecimal> taxSet = new HashSet<BigDecimal>();
            for (DynamicObject supplierDetail : supplierDetailCol) {
                taxSet.add(supplierDetail.getBigDecimal("taxrate"));
                BigDecimal singleIncludeTaxPrice = supplierDetail.getBigDecimal("inclutaxamount") == null ? BigDecimal.ZERO : supplierDetail.getBigDecimal("inclutaxamount");
                BigDecimal singleTaxAmount = supplierDetail.getBigDecimal("taxamount") == null ? BigDecimal.ZERO : supplierDetail.getBigDecimal("taxamount");
                BigDecimal singleExceptTaxAmount = supplierDetail.getBigDecimal("excepttaxamount") == null ? BigDecimal.ZERO : supplierDetail.getBigDecimal("excepttaxamount");
                sumIncludeTaxPrice = sumIncludeTaxPrice.add(singleIncludeTaxPrice);
                sumTaxAmount = sumTaxAmount.add(singleTaxAmount);
                sumExceptTaxAmount = sumExceptTaxAmount.add(singleExceptTaxAmount);
            }
            sumTaxRate = sumExceptTaxAmount.compareTo(BigDecimal.ZERO) != 0 ? sumTaxAmount.divide(sumExceptTaxAmount, 4, 4) : BigDecimal.ZERO;
            this.getModel().setValue("tenderprice", (Object)sumIncludeTaxPrice);
            if (supplierDetailCol.size() == 1 || taxSet.size() == 1) {
                this.getModel().setValue("pricevat", (Object)((DynamicObject)supplierDetailCol.get(0)).getBigDecimal("taxrate"));
            } else {
                this.getModel().setValue("pricevat", (Object)sumTaxRate.multiply(new BigDecimal("100")));
            }
            this.getModel().setValue("notaxtenderprice", (Object)sumExceptTaxAmount);
            this.getModel().setValue("tax", (Object)sumTaxAmount);
            BigDecimal inclutaxprice = (BigDecimal)this.getModel().getValue("inclutaxprice", index);
            if (Objects.isNull(inclutaxprice)) {
                this.getModel().setValue("inclutaxprice", (Object)BigDecimal.ZERO, index);
            }
            this.getView().updateView("tenderprice");
            this.getView().updateView("pricevat");
            this.getView().updateView("notaxtenderprice");
            this.getView().updateView("tax");
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"tenderprice") || StringUtils.equals((CharSequence)filedName, (CharSequence)"pricevat")) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map customParamMap = (Map)formShowParameter.getCustomParam("parentParam");
            String appId = customParamMap.get("appId").toString();
            if ("resp".equals(appId)) {
                BigDecimal priceVat = dataEntity.getBigDecimal("pricevat").divide(new BigDecimal("100"));
                BigDecimal tenderPrice = dataEntity.getBigDecimal("tenderprice");
                if (priceVat.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("notaxtenderprice", (Object)tenderPrice);
                }
            }
        } else if (StringUtils.equals((CharSequence)filedName, (CharSequence)"bd_taxrate")) {
            ChangeData[] dataSet = args.getChangeSet();
            ChangeData changedata = dataSet[0];
            Object newVal = changedata.getNewValue();
            int rowIndex = changedata.getRowIndex();
            if (newVal == null) {
                this.getModel().setValue("taxrate", (Object)new BigDecimal(0), rowIndex);
            } else {
                DynamicObject bdTaxRate = (DynamicObject)newVal;
                this.getModel().setValue("taxrate", (Object)bdTaxRate.getBigDecimal("taxrate"), rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            BigDecimal pricevat = dataEntity.getBigDecimal("pricevat").divide(new BigDecimal("100"));
            dataEntity.set("pricevat", (Object)pricevat);
            BigDecimal rate = dataEntity.getBigDecimal("rate").divide(new BigDecimal("100"));
            dataEntity.set("rate", (Object)rate);
            DynamicObjectCollection supplierDetailCol = dataEntity.getDynamicObjectCollection("supplierdetail");
            for (DynamicObject supplierDetail : supplierDetailCol) {
                BigDecimal taxRate = supplierDetail.getBigDecimal("taxrate").divide(new BigDecimal("100"));
                BigDecimal costRate = supplierDetail.getBigDecimal("costrate").divide(new BigDecimal("100"));
                supplierDetail.set("taxrate", (Object)taxRate);
                supplierDetail.set("costrate", (Object)costRate);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null) {
            operationResult.setShowMessage(false);
        }
    }
}

