/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.onlinebid;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidBackTypeEnum;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.BidRevokeUtil;
import kd.scm.ten.formplugin.util.ConfirmBidUtil;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.PermissionUtils;
import kd.scm.ten.formplugin.util.RevokeBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenOnlineBidEditPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static String FIRST_TAB_KEY = "onlineTenderTabKey";
    private static String SUB_SECTION_PAGE = "subSectionPage_";
    private static String SUPPLIER = "onlineBidSupplier_";
    private ConfirmBidUtil confirmBidUtil = new ConfirmBidUtil();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        Object onlineBidId = formShowParameter.getCustomParam("onlineBidId");
        List<Map<String, Object>> sectionList = this.getSectionList(appId, onlineBidId, bidProjectId);
        this.initOnlineBidData(sectionList);
        TabAp dynamicPanel = this.createDynamicTabAp(sectionList);
        Container myFldPanel = (Container)this.getView().getControl("sectiontab");
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String firstTabKey = this.getPageCache().get(FIRST_TAB_KEY);
        if (StringUtils.isNotBlank((CharSequence)firstTabKey)) {
            this.showSectionChildView(firstTabKey, false);
        }
    }

    public void initOnlineBidData(List<Map<String, Object>> sectionList) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object myTenderId = formShowParameter.getCustomParam("myTenderId");
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject onlineBidEntity = this.getView().getModel().getDataEntity(true);
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()));
        DynamicObject bidProject = null;
        DynamicObject supplier = null;
        if (appId.equals("resp")) {
            supplier = SupplierUtil.getRESMSupplier();
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"rebm_bidproject_f7");
        } else {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bidproject_f7");
            Object orgPk = bidProject.getDynamicObject("org").getPkValue();
            supplier = SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), orgPk);
        }
        this.getPageCache().put(SUPPLIER, supplier.getString("id"));
        DynamicObjectCollection sectionEntryCol = onlineBidEntity.getDynamicObjectCollection("sectionentry");
        StringBuilder sectionNameSb = new StringBuilder();
        String billStatus = onlineBidEntity.getString("billstatus");
        if (OperationStatus.ADDNEW.equals((Object)status) || BillStatusEnum.SAVE.getVal().equals(billStatus)) {
            String formId;
            DynamicObject[] onlineBidDetailArray;
            sectionEntryCol.clear();
            HashMap<String, String> sectionListMap = new HashMap<String, String>(16);
            for (Map<String, Object> sectionMap : sectionList) {
                DynamicObject sectionEntry = sectionEntryCol.addNew();
                sectionEntry.set("projectsectionid", sectionMap.get("sectionid"));
                sectionEntry.set("sectionname", sectionMap.get("sectionname"));
                sectionEntry.set("sectionstatus", sectionMap.get("sectionstatus"));
                sectionEntry.set("enablemultisection", sectionMap.get("enablemultisection"));
                sectionEntry.set("currentroundflag", sectionMap.get("currentroundflag"));
                sectionEntry.set("fromrebackflag", sectionMap.get("fromrebackflag"));
                String sectionStatus = sectionMap.get("sectionstatus").toString();
                if (MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) {
                    String value = sectionMap.get("sectionname") + ";";
                    sectionNameSb.append(value);
                }
                sectionListMap.put((String)sectionMap.get("sectionid"), sectionStatus);
            }
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X", "J"})});
            if (bidPublish != null) {
                this.getModel().setValue("bidpublishid", bidPublish.getPkValue());
            }
            if ((onlineBidDetailArray = BusinessDataServiceHelper.load((String)(formId = appId + "_" + "online_bid_detail"), (String)"id,projectsectionid,sectionstatus", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidEntity.getPkValue()), new QFilter("sectionname", "in", sectionListMap.keySet())})) != null && onlineBidDetailArray.length > 0) {
                for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
                    String projectSectionId = onlineBidDetail.getString("projectsectionid");
                    String sectionStatus = (String)sectionListMap.get(projectSectionId);
                    onlineBidDetail.set("sectionstatus", (Object)sectionStatus);
                }
                SaveServiceHelper.update((DynamicObject[])onlineBidDetailArray);
            }
            this.getModel().setValue("sectionnamelist", (Object)sectionNameSb);
            this.getModel().setValue("supplier", (Object)supplier);
            this.getModel().setValue("bidproject", bidProject.getPkValue());
            this.getModel().setValue("currency", bidProject.get("currency"));
            this.getModel().setValue("mytender", myTender.getPkValue());
            this.getModel().setValue("node", (Object)myTender.getString("node"));
            this.getModel().setValue("tenderstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
            this.getModel().setValue("backbidway", myTender.get("backbidway"));
            this.getModel().setValue("backbidtype", myTender.get("backbidtype"));
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                this.getModel().setValue("rounds", (Object)1);
                this.getModel().setValue("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"TenOnlineBidEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)"1")));
            }
        }
        Date backDeadLineDate = CommonUtil.getBackDeadLineDate((String)myTender.getString("backbidtype"), (Object)bidProjectId);
        this.getModel().setValue("bidbackdeadline", (Object)backDeadLineDate);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        this.showSectionChildView(tabKey, false);
    }

    public void showSectionChildView(String tabKey, boolean refreshFlag) {
        String subPageId = this.getPageCache().get(SUB_SECTION_PAGE + tabKey);
        if (subPageId != null && !refreshFlag) {
            return;
        }
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object myTenderId = formShowParameter.getCustomParam("myTenderId");
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String formId = appId + "_" + "online_bid_detail";
        BillShowParameter subParameter = new BillShowParameter();
        subParameter.setFormId(formId);
        OperationStatus status = OperationStatus.ADDNEW;
        DynamicObject subOnlineTender = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", dataEntity.getPkValue()), new QFilter("projectsectionid", "=", (Object)tabKey)});
        if (subOnlineTender != null) {
            subParameter.setPkId(subOnlineTender.getPkValue());
            status = OperationStatus.EDIT;
        }
        HashMap<String, DynamicObject> sectionMap = new HashMap<String, DynamicObject>();
        DynamicObjectCollection sectionEntryCol = dataEntity.getDynamicObjectCollection("sectionentry");
        for (DynamicObject sectionEntry : sectionEntryCol) {
            sectionMap.put(sectionEntry.getString("projectsectionid"), sectionEntry);
        }
        subParameter.setHasRight(true);
        subParameter.setStatus(status);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(tabKey);
        subParameter.setOpenStyle(openStyle);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>();
        customParamMap.put("myTenderId", myTenderId);
        customParamMap.put("bidProjectId", bidProjectId);
        customParamMap.put("appId", appId);
        customParamMap.put("sectionId", tabKey);
        DynamicObject sectionEntry = (DynamicObject)sectionMap.get(tabKey);
        customParamMap.put("sectionName", sectionEntry.getString("sectionname"));
        customParamMap.put("sectionStatus", sectionEntry.getString("sectionstatus"));
        customParamMap.put("onlineBidId", dataEntity.getPkValue());
        customParamMap.put("backBidWay", dataEntity.get("backbidway"));
        customParamMap.put("backBidType", dataEntity.get("backbidtype"));
        customParamMap.put("fromReBackBid", sectionEntry.getBoolean("fromrebackflag"));
        Object supplierId = dataEntity.getDynamicObject("supplier").getPkValue();
        customParamMap.put("supplierId", supplierId);
        customParamMap.put("rounds", dataEntity.get("rounds"));
        customParamMap.put("bidpublishid", dataEntity.get("bidpublishid"));
        subParameter.setCustomParam("parentParam", customParamMap);
        this.getView().showForm((FormShowParameter)subParameter);
        this.getPageCache().put(SUB_SECTION_PAGE + tabKey, subParameter.getPageId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Control sectionTab = this.getView().getControl("sectiontab");
        ((Tab)sectionTab).addTabSelectListener((TabSelectListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        Object onlineBidId = formShowParameter.getCustomParam("onlineBidId");
        List<Map<String, Object>> sectionList = this.getSectionList(appId, onlineBidId, bidProjectId);
        TabAp tab = this.createDynamicTabAp(sectionList);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "sectiontab");
        mapHead.put("items", (String)tab.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public TabAp createDynamicTabAp(List<Map<String, Object>> list) {
        TabAp tab = new TabAp();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            tab.setKey("sectiontab" + i);
            TabPageAp tpa = this.createTabPageAp(map);
            tab.getItems().add(tpa);
        }
        return tab;
    }

    public TabPageAp createTabPageAp(Map<String, Object> map) {
        String firstTabKey;
        String sectionId = (String)map.get("sectionid");
        String sectionName = (String)map.get("sectionname");
        Boolean enableMultiSection = (Boolean)map.get("enablemultisection");
        String sectionStatus = (String)map.get("sectionstatus");
        Boolean currentRoundFlag = (Boolean)map.get("currentroundflag");
        TabPageAp tpa = new TabPageAp();
        String tpaKey = sectionId;
        tpa.setKey(tpaKey);
        tpa.setId(sectionId);
        boolean hidden = false;
        if (MyTenderStatus.UNTENDERED.getValue().equals(sectionStatus) || !currentRoundFlag.booleanValue()) {
            hidden = true;
        } else if (currentRoundFlag.booleanValue()) {
            hidden = false;
        }
        tpa.setHidden(hidden);
        if (!enableMultiSection.booleanValue()) {
            tpa.setName(new LocaleString(ResManager.loadKDString((String)"\u6295\u6807\u4fe1\u606f", (String)"TenOnlineBidEditPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0])));
        } else {
            tpa.setName(new LocaleString(sectionName));
        }
        IPageCache pageCache = this.getPageCache();
        if (pageCache != null && !hidden && (firstTabKey = pageCache.get(FIRST_TAB_KEY)) == null) {
            pageCache.put(FIRST_TAB_KEY, tpaKey);
        }
        FlexPanelAp fpa = new FlexPanelAp();
        fpa.setKey("container");
        fpa.setId("container");
        fpa.setWidth(new LocaleString("100%"));
        fpa.setBackColor("#EBEEF2");
        return tpa;
    }

    public String getBidAppId(String appId) {
        appId = "ten".equals(appId) ? "bid" : "rebm";
        return appId;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject onlineBidEntity = this.getModel().getDataEntity(true);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
        Object myTenderId = formShowParameter.getCustomParam("myTenderId");
        String appId = (String)formShowParameter.getCustomParam("appId");
        if ("unsubmit".equals(operateKey)) {
            this.validatorRevoke(onlineBidEntity, args);
        } else if ("submit".equals(operateKey)) {
            onlineBidEntity.set("ten_ip", (Object)IsIllegalBidUtil.getLoginIp());
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"bidopentype");
            DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)"ten_mytender", (String)"backbidtype,tenderstatus");
            if (!CommonUtil.checkBidOpenStatus((DynamicObject)bidProject, (DynamicObject)myTender)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u6216\u5df2\u5b8c\u6210\u7684\u5f00\u6807\u4e1a\u52a1\uff0c\u65e0\u6cd5\u8fdb\u884c\u6295\u6807\u64cd\u4f5c\u3002", (String)"TenOnlineBidEditPlugin_39", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String tenderStatus = myTender.getString("tenderstatus");
            if (MyTenderStatus.UNTENDERED.getValue().equals(tenderStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6295\u6807\u5355\u5df2\u505a\u5f03\u6807\uff0c\u65e0\u6cd5\u6295\u6807\u3002", (String)"TenOnlineBidEditPlugin_28", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String bidAppId = this.getBidAppId(appId);
            this.checkSupplierBizPartner(bidAppId, onlineBidEntity, args);
            DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)(bidAppId + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X"})});
            if (bidPublishArray != null && bidPublishArray.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c06\u8fdb\u884c\u91cd\u65b0\u53d1\u6807\uff0c\u4e0d\u5141\u8bb8\u6295\u6807\u3002", (String)"TenOnlineBidEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject[] supplierInvitationArray = BusinessDataServiceHelper.load((String)(bidAppId + "_supplierinvitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX"})});
            if (supplierInvitationArray != null && supplierInvitationArray.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c06\u8fdb\u884c\u91cd\u65b0\u53d1\u6807\uff0c\u4e0d\u5141\u8bb8\u6295\u6807\u3002", (String)"TenOnlineBidEditPlugin_40", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<Map<String, Object>> sectionList = this.getSectionList(appId, onlineBidEntity.getPkValue(), bidProjectId);
            for (Map<String, Object> sectionMap : sectionList) {
                DynamicObject onlineBidDetailEntity;
                boolean validatorResult;
                String tabKey = (String)sectionMap.get("sectionid");
                String sectionName = (String)sectionMap.get("sectionname");
                String sectionStatus = (String)sectionMap.get("sectionstatus");
                String sonPageId = this.getPageCache().get(SUB_SECTION_PAGE + tabKey);
                if (sonPageId == null || null == this.getView().getView(sonPageId)) {
                    if (!MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) continue;
                    String formId = appId + "_" + "online_bid_detail";
                    DynamicObject subOnlineTenderTemp = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidEntity.getPkValue()), new QFilter("projectsectionid", "=", (Object)tabKey)});
                    if (subOnlineTenderTemp == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u586b\u5199\u6570\u636e\u3002", (String)"TenOnlineBidEditPlugin_41", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                        args.setCancel(true);
                        return;
                    }
                    DynamicObject subOnlineTender = BusinessDataServiceHelper.loadSingle((Object)subOnlineTenderTemp.getPkValue(), (String)formId);
                    boolean validatorResult2 = this.validatorOnlineBidDetail(appId, operateKey, subOnlineTender, null);
                    if (validatorResult2) continue;
                    args.setCancel(true);
                    return;
                }
                IFormView subView = this.getView().getView(sonPageId);
                if (!"submit".equals(operateKey) || (validatorResult = this.validatorOnlineBidDetail(appId, operateKey, onlineBidDetailEntity = subView.getModel().getDataEntity(true), subView))) continue;
                args.setCancel(true);
                return;
            }
        }
    }

    public void checkSupplierBizPartner(String appId, DynamicObject onlineBidEntity, BeforeDoOperationEventArgs args) {
        Long bizPartnerId = RequestContext.get().getBizPartnerId();
        DynamicObject currentSupplier = onlineBidEntity.getDynamicObject("supplier");
        if (currentSupplier == null) {
            this.tipSupplierDataError(args);
            args.setCancel(true);
            return;
        }
        DynamicObject supplier = null;
        supplier = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)currentSupplier.getPkValue(), (String)"resm_official_supplier", (String)"bizpartner") : BusinessDataServiceHelper.loadSingle((Object)currentSupplier.getPkValue(), (String)"bd_supplier", (String)"bizpartner");
        if (supplier == null) {
            this.tipSupplierDataError(args);
            args.setCancel(true);
            return;
        }
        DynamicObject bizPartner = supplier.getDynamicObject("bizpartner");
        if (bizPartner == null) {
            this.tipSupplierDataError(args);
            args.setCancel(true);
            return;
        }
        if (!bizPartner.getString("id").equals(bizPartnerId.toString())) {
            String bizPartnerName = bizPartner.getString("name");
            String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u767b\u5f55\u7684\u5546\u52a1\u4f19\u4f34\u4e0e\u6295\u6807\u7684\u6570\u636e\u7684\u5546\u52a1\u4f19\u4f34\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728\u53f3\u4e0a\u89d2\u70b9\u51fb\u3010\u4eba\u7269\u5934\u50cf\u3011->\u3010\u5546\u52a1\u4f19\u4f34\u3011\u70b9\u51fb\u56fe\u6807\u5207\u6362\u5546\u52a1\u4f19\u4f34\u4e3a\u3010%s\u3011\u8fdb\u884c\u6295\u6807\uff01", (String)"TenOnlineBidEditPlugin_37", (String)"scm-ten-formplugin", (Object[])new Object[0]), bizPartnerName);
            this.getView().showTipNotification(tip);
            args.setCancel(true);
            return;
        }
    }

    public void tipSupplierDataError(BeforeDoOperationEventArgs args) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6570\u636e\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"TenOnlineBidEditPlugin_36", (String)"scm-ten-formplugin", (Object[])new Object[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            DynamicObject onlineBidEntity = this.getModel().getDataEntity(true);
            BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
            String appId = (String)formShowParameter.getCustomParam("appId");
            List<Map<String, Object>> sectionList = this.getSectionList(appId, onlineBidEntity.getPkValue(), bidProjectId);
            List<Object> sectionNameList = new ArrayList();
            if (sectionList != null && sectionList.size() > 0) {
                sectionNameList = sectionList.stream().map(sectionMap -> String.valueOf(sectionMap.get("sectionname"))).collect(Collectors.toList());
            }
            if ("save".equals(operateKey) || "submit".equals(operateKey) || "unsubmit".equals(operateKey)) {
                for (Map<String, Object> sectionMap2 : sectionList) {
                    String tabKey = String.valueOf(sectionMap2.get("sectionid"));
                    String sectionName = String.valueOf(sectionMap2.get("sectionname"));
                    String sonPageId = this.getPageCache().get(SUB_SECTION_PAGE + tabKey);
                    IFormView subView = this.getView().getView(sonPageId);
                    if (subView == null) continue;
                    BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u5b50\u9875\u9762\u7f13\u5b58\u4e0d\u4e3a\u7a7a\uff0c\u5f00\u59cb\u8c03\u7528\u5b50\u9875\u9762\u64cd\u4f5c\u65b9\u6cd5\uff0c\u6807\u6bb5\u540d\u79f0\uff1a", (String)"TenOnlineBidEditPlugin_42", (String)"scm-ten-formplugin", (Object[])new Object[0]) + sectionName));
                    if ("save".equals(operateKey) || "submit".equals(operateKey)) {
                        onlineBidEntity.set("id", onlineBidEntity.getPkValue());
                        DynamicObject subDataEntity = subView.getModel().getDataEntity();
                        subDataEntity.set("onlinebidid", onlineBidEntity.getPkValue());
                        if ("submit".equals(operateKey)) {
                            subDataEntity.set("sectionstatus", (Object)MyTenderStatus.TENDERED.getValue());
                        }
                    }
                    OperationResult subOperationResult = subView.invokeOperation(operateKey);
                    BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u5b50\u9875\u9762\u7f13\u5b58\u4e0d\u4e3a\u7a7a\uff0c\u8c03\u7528\u5b50\u9875\u9762\u64cd\u4f5c", (String)"TenOnlineBidEditPlugin_43", (String)"scm-ten-formplugin", (Object[])new Object[0]) + operateKey + ResManager.loadKDString((String)"\u65b9\u6cd5\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a", (String)"TenOnlineBidEditPlugin_44", (String)"scm-ten-formplugin", (Object[])new Object[0]) + subOperationResult.isSuccess() + ResManager.loadKDString((String)" \u4fe1\u606f", (String)"TenOnlineBidEditPlugin_45", (String)"scm-ten-formplugin", (Object[])new Object[0])));
                    if (!subOperationResult.isSuccess()) {
                        DynamicObject[] onlineBidDetailArray;
                        onlineBidEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlineBidEntity});
                        for (DynamicObject onlineBidDetail : onlineBidDetailArray = BusinessDataServiceHelper.load((String)(appId + "_online_bid_detail"), (String)"billstatus,sectionstatus", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidEntity.getPkValue()), new QFilter("sectionname", "in", sectionNameList)})) {
                            onlineBidDetail.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                            onlineBidDetail.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                        }
                        SaveServiceHelper.save((DynamicObject[])onlineBidDetailArray);
                        this.getView().invokeOperation("refresh");
                        String msg = "";
                        List allErrorInfoList = subOperationResult.getAllErrorInfo();
                        for (OperateErrorInfo operateErrorInfo : allErrorInfoList) {
                            msg = operateErrorInfo.getMessage();
                        }
                        ValidateResultCollection validateResultCollection = subOperationResult.getValidateResult();
                        if (validateResultCollection != null) {
                            List validateResultList = validateResultCollection.getValidateErrors();
                            for (ValidateResult validateResult : validateResultList) {
                                List errorInfoList = validateResult.getAllErrorInfo();
                                for (OperateErrorInfo errorInfo : errorInfoList) {
                                    msg = errorInfo.getMessage();
                                }
                            }
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u6807\u6bb5\u6570\u636e\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u6210\u529f\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u8bd5\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%1$s", (String)"TenOnlineBidEditPlugin_34", (String)"scm-ten-formplugin", (Object[])new Object[]{msg}));
                    }
                    subView.invokeOperation("refresh");
                    this.getView().sendFormAction(subView);
                }
            }
            if ("submit".equals(operateKey)) {
                try {
                    this.confirmBidUtil.confirmBid(onlineBidEntity);
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6295\u6807\u6570\u636e\u53cd\u5199\u5f02\u5e38\uff0c\u6570\u636e\u56de\u6eda\u6210\u529f\u3002\u5f02\u5e38\u4fe1\u606f\uff1a%1$s", (String)"TenOnlineBidEditPlugin_33", (String)"scm-ten-formplugin", (Object[])new Object[]{e.getMessage()}));
                }
                finally {
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("revoke".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject onlineBidEntity = this.getModel().getDataEntity(true);
            BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object bidProjectId = formShowParameter.getCustomParam("bidProjectId");
            String appId = (String)formShowParameter.getCustomParam("appId");
            try (TXHandle h = TX.required((String)"revoke");){
                try {
                    BidRevokeUtil.revokeBid(onlineBidEntity);
                    this.getView().invokeOperation("refresh");
                    List<Map<String, Object>> sectionList = this.getSectionList(appId, onlineBidEntity.getPkValue(), bidProjectId);
                    for (Map<String, Object> sectionMap : sectionList) {
                        IFormView subView;
                        String tabKey = (String)sectionMap.get("sectionid");
                        String sonPageId = this.getPageCache().get(SUB_SECTION_PAGE + tabKey);
                        if (sonPageId == null || (subView = this.getView().getView(sonPageId)) == null) continue;
                        subView.invokeOperation("refresh");
                        this.getView().sendFormAction(subView);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u6807\u6210\u529f\u3002", (String)"TenOnlineBidEditPlugin_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
    }

    public List<Map<String, Object>> getSectionList(String tenAppId, Object onlineBidId, Object bidProjectId) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> sectionMap = null;
        DynamicObject onlineBidData = null;
        String projectProperties = "id,bidopentype,bidsection,bidsection.sectionname,enablemultisection";
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)projectProperties);
        List<Object> pkSet = SupplierUtil.getSupplierPkArray();
        if ("resp".equals(tenAppId)) {
            DynamicObject currentSupplier = SupplierUtil.getRESMSupplier();
            pkSet.add(currentSupplier.getPkValue());
        }
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((String)(tenAppId + "_mytender"), (String)"entry,projectsection,sectionname,sectionstatus,fromrebackflag", (QFilter[])new QFilter[]{new QFilter("supplier", "in", pkSet), new QFilter("bidproject", "=", bidProjectId)});
        DynamicObjectCollection tenderEntryCol = myTender.getDynamicObjectCollection("entry");
        if (onlineBidId != null && !"0".equals(onlineBidId.toString())) {
            onlineBidData = BusinessDataServiceHelper.loadSingle((Object)onlineBidId, (String)(tenAppId + "_online_bid"));
        }
        if (onlineBidData != null && !BillStatusEnum.SAVE.getVal().equals(onlineBidData.getString("billstatus"))) {
            DynamicObjectCollection sectionEntryCol = onlineBidData.getDynamicObjectCollection("sectionentry");
            for (DynamicObject sectionEntry : sectionEntryCol) {
                sectionMap = new HashMap<String, Object>();
                String sectionName = sectionEntry.getString("sectionname");
                sectionMap.put("sectionid", sectionEntry.getString("projectsectionid"));
                sectionMap.put("sectionname", sectionName);
                sectionMap.put("sectionstatus", sectionEntry.getString("sectionstatus"));
                sectionMap.put("currentroundflag", sectionEntry.getBoolean("currentroundflag"));
                sectionMap.put("enablemultisection", sectionEntry.getBoolean("enablemultisection"));
                sectionMap.put("fromrebackflag", sectionEntry.getBoolean("fromrebackflag"));
                result.add(sectionMap);
            }
        } else {
            for (DynamicObject tenderEntry : tenderEntryCol) {
                String sectionName = tenderEntry.getString("sectionname");
                String sectionStatus = tenderEntry.getString("sectionstatus");
                DynamicObject projectSection = tenderEntry.getDynamicObject("projectsection");
                sectionMap = new HashMap();
                sectionMap.put("sectionid", String.valueOf(projectSection.getPkValue()));
                sectionMap.put("sectionname", sectionName);
                sectionMap.put("sectionstatus", sectionStatus);
                sectionMap.put("enablemultisection", project.getBoolean("enablemultisection"));
                sectionMap.put("fromrebackflag", tenderEntry.getBoolean("fromrebackflag"));
                if (MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) {
                    sectionMap.put("currentroundflag", Boolean.TRUE);
                } else {
                    sectionMap.put("currentroundflag", Boolean.FALSE);
                }
                result.add(sectionMap);
            }
        }
        return result;
    }

    public void rollbackStatus(String tenAppId, String operateKey, DynamicObject onlineBidEntity) {
        if ("submit".equals(operateKey)) {
            DynamicObject[] subOnlineTenderArray;
            onlineBidEntity.set("billstatus", (Object)"A");
            for (DynamicObject subOnlineTender : subOnlineTenderArray = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid_detail"), (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidEntity.getPkValue())})) {
                subOnlineTender.set("billstatus", (Object)"A");
            }
            SaveServiceHelper.update((DynamicObject[])subOnlineTenderArray);
            SaveServiceHelper.update((DynamicObject)onlineBidEntity);
            this.getView().updateView("billstatus");
        }
    }

    public void validatorRevoke(DynamicObject onlineBidEntity, BeforeDoOperationEventArgs args) {
        long dateTime;
        long nowTime;
        boolean hasPermission;
        DynamicObject bidProject = onlineBidEntity.getDynamicObject("bidproject");
        String bidAppId = bidProject.getString("entitytypeid").split("_")[0];
        DynamicObject org = bidProject.getDynamicObject("org");
        String tenAppId = AppIdUtil.getTenAppId((String)bidAppId);
        if (StringUtils.equals((CharSequence)"ten", (CharSequence)tenAppId) && !(hasPermission = PermissionUtils.checkPermission("QXX0293", (Long)org.getPkValue(), tenAppId, "ten_mytender"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"TenOnlineBidEditPlugin_4", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Boolean isAllowRevoke = RevokeBidUtil.getSystemParameter(bidAppId, (Long)org.getPkValue(), "revoke");
        if (!isAllowRevoke.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_5", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object myTenderId = formShowParameter.getCustomParam("myTenderId");
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"tenderstatus,bidproject,supplier,backbidtype");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()), (String)"bidopentype");
        Date backDeadLineDate = CommonUtil.getBackDeadLineDate((String)myTender.getString("backbidtype"), (Object)project.getPkValue());
        if (backDeadLineDate != null && (nowTime = new Date().getTime()) > (dateTime = backDeadLineDate.getTime())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:MM:SS");
            String str = dateFormat.format(backDeadLineDate.getTime());
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5df2\u5230\u201c\u622a\u6807\u65f6\u95f4%s\u201d\uff0c\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_46", (String)"scm-ten-formplugin", (Object[])new Object[0]), str));
            args.setCancel(true);
            return;
        }
        if (!CommonUtil.checkBidOpenStatus((DynamicObject)project, (DynamicObject)myTender)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8fdb\u884c\u4e2d\u6216\u5df2\u5b8c\u6210\u7684\u5f00\u6807\u4e1a\u52a1\uff0c\u65e0\u6cd5\u8fdb\u884c\u64a4\u6807\u64cd\u4f5c\u3002", (String)"TenOnlineBidEditPlugin_47", (String)"scm-ten-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        boolean fromReBackFlag = false;
        DynamicObjectCollection sectionEntryCol = onlineBidEntity.getDynamicObjectCollection("sectionentry");
        for (DynamicObject sectionEntry : sectionEntryCol) {
            if (!sectionEntry.getBoolean("fromrebackflag")) continue;
            fromReBackFlag = true;
            break;
        }
        if (!fromReBackFlag) {
            DynamicObject[] bidPublishArray = BusinessDataServiceHelper.load((String)(bidAppId + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X"})});
            if (bidPublishArray != null && bidPublishArray.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c06\u8fdb\u884c\u91cd\u65b0\u53d1\u6807\uff0c\u6682\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_48", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject[] supplierInvitationArray = BusinessDataServiceHelper.load((String)(bidAppId + "_supplierinvitation"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX"})});
            if (supplierInvitationArray != null && supplierInvitationArray.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u62db\u6807\u9879\u5c06\u8fdb\u884c\u91cd\u65b0\u53d1\u6807\uff0c\u6682\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_48", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object bidPublishId = this.getModel().getValue("bidpublishid");
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((Object)bidPublishId, (String)FormTypeConstants.getFormConstant((String)"bidpublish", ((Object)((Object)this)).getClass()));
            if (BillStatusEnum.INVALID.getVal().equals(bidPublish.get("billstatus")) || BillStatusEnum.ADJUSTING.getVal().equals(bidPublish.get("billstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u540e\uff0c\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_49", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object tenderSupplierId = myTender.getDynamicObject("supplier").getPkValue();
            DynamicObjectCollection publishSectionColl = bidPublish.getDynamicObjectCollection("bidsection");
            boolean isReTender = false;
            for (int i = 0; i < publishSectionColl.size(); ++i) {
                DynamicObject publishSection = (DynamicObject)publishSectionColl.get(i);
                DynamicObjectCollection supplierEntryColl = publishSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryColl) {
                    Long supplierID = supplierEntry.getDynamicObject("supplier").getLong("id");
                    String tenderStrategy = supplierEntry.getString("tenderstrategy");
                    if (!tenderSupplierId.equals(supplierID) || "UNNEEDBID".equals(tenderStrategy)) continue;
                    isReTender = true;
                }
            }
            if (!isReTender) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u518d\u6b21\u53d1\u6807\u540e\uff0c\u4e0d\u5141\u8bb8\u64a4\u6807\u3002", (String)"TenOnlineBidEditPlugin_49", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("revoke", (IFormPlugin)this);
        String confirmTip = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u64a4\u6807\uff1f", (String)"TenOnlineBidEditPlugin_12", (String)"scm-ten-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        args.setCancel(true);
    }

    public boolean validatorOnlineBidDetail(String appId, String operateKey, DynamicObject onlineBidDetailEntity, IFormView subView) {
        String sectionStatus;
        String selectProperties = "enablemultisection,isratebidding,ismaterialpur,bidopendeadline,doctype,bidtype";
        DynamicObject bidProject = onlineBidDetailEntity.getDynamicObject("bidproject");
        if (bidProject != null) {
            bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(AppIdUtil.getBidAppId((String)appId) + "_project"), (String)selectProperties);
        }
        if ("PRETENDERED".equals(sectionStatus = onlineBidDetailEntity.getString("sectionstatus"))) {
            List busFileList;
            List techFileList;
            Boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
            Boolean isRateBidding = bidProject.getBoolean("isratebidding");
            String backBidType = onlineBidDetailEntity.getString("backbidtype");
            String bidType = bidProject.getString("bidtype");
            String sectionName = onlineBidDetailEntity.getString("sectionname");
            if (subView != null) {
                AttachmentPanel techPanel = (AttachmentPanel)subView.getControl("techattachment");
                techFileList = techPanel.getAttachmentData();
                AttachmentPanel busPanel = (AttachmentPanel)subView.getControl("busattachment");
                busFileList = busPanel.getAttachmentData();
            } else {
                String formId = appId + "_online_bid_detail";
                techFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)onlineBidDetailEntity.getPkValue(), (String)"techattachment");
                busFileList = AttachmentServiceHelper.getAttachments((String)formId, (Object)onlineBidDetailEntity.getPkValue(), (String)"busattachment");
            }
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") || StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
                String str;
                if (!isRateBidding.booleanValue() && !BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
                    DynamicObjectCollection supplierDetail = onlineBidDetailEntity.getDynamicObjectCollection("supplierdetail");
                    for (int i = 0; i < supplierDetail.size(); ++i) {
                        DynamicObject bd_taxrate;
                        DynamicObject row = (DynamicObject)supplierDetail.get(i);
                        if (BidTypeEnum.PROJECT.getValue().equals(bidType) || (bd_taxrate = row.getDynamicObject("bd_taxrate")) != null) continue;
                        if (enableMultiSection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u5206\u5f55\u7a0e\u7387\u540d\u79f0\u3002", (String)"TenOnlineBidEditPlugin_30", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u7a0e\u7387\u540d\u79f0\u3002", (String)"TenOnlineBidEditPlugin_29", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
                    if (techFileList.isEmpty() || techFileList.size() == 0) {
                        if (enableMultiSection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_50", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7684\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_51", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                } else if (BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
                    if (busFileList.isEmpty() && busFileList.size() == 0) {
                        if (enableMultiSection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_52", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_19", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                } else {
                    if (techFileList.isEmpty() || techFileList.size() == 0) {
                        if (enableMultiSection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_50", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7684\u201c\u6280\u672f\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_51", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (busFileList.isEmpty() || busFileList.size() == 0) {
                        if (enableMultiSection.booleanValue()) {
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c%s\u201d\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_52", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName));
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7684\u201c\u5546\u52a1\u6807\u4e66\u9644\u4ef6\u201d\u3002", (String)"TenOnlineBidEditPlugin_19", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
                    Boolean isDeadline = Boolean.TRUE;
                    Date backDeadLineDate = CommonUtil.getBackDeadLineDate((String)backBidType, (Object)bidProject.getPkValue());
                    if (backDeadLineDate != null) {
                        Date date = new Date();
                        int compareTo = date.compareTo(backDeadLineDate);
                        if (compareTo > 0) {
                            isDeadline = Boolean.FALSE;
                        }
                        if (!isDeadline.booleanValue()) {
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:MM:SS");
                            String str2 = dateFormat.format(backDeadLineDate.getTime());
                            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6295\u6807\u65f6\u95f4%1$s\u5df2\u7ecf\u622a\u6b62\u4e0d\u80fd\u8fdb\u884c\u6295\u6807\u3002", (String)"TenOnlineBidEditPlugin_20", (String)"scm-ten-formplugin", (Object[])new Object[0]), str2));
                            return false;
                        }
                    }
                }
                if (!isRateBidding.booleanValue()) {
                    BigDecimal TenderPrice = onlineBidDetailEntity.getBigDecimal("tenderprice");
                    if (TenderPrice.compareTo(BigDecimal.ZERO) < 0) {
                        if (enableMultiSection.booleanValue()) {
                            str = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u6295\u6807\u62a5\u4ef7\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_26", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName);
                            this.getView().showTipNotification(str);
                            return false;
                        }
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6295\u6807\u62a5\u4ef7\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_23", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                } else {
                    BigDecimal rate = onlineBidDetailEntity.getBigDecimal("rate");
                    if (rate == null) {
                        if (enableMultiSection.booleanValue()) {
                            str = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_31", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName);
                            this.getView().showTipNotification(str);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7efc\u5408\u8d39\u7387\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_32", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        }
                        return false;
                    }
                    Integer workDay = onlineBidDetailEntity.getInt("workday");
                    if (workDay < 0) {
                        if (enableMultiSection.booleanValue()) {
                            String str3 = String.format(ResManager.loadKDString((String)"%s\u7684\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_27", (String)"scm-ten-formplugin", (Object[])new Object[0]), sectionName);
                            this.getView().showTipNotification(str3);
                        } else {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5de5\u671f\u201d\u9700\u8f93\u5165\u6709\u6548\u503c\u3002", (String)"TenOnlineBidEditPlugin_25", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

