/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.repair;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.common.util.CommonUtil;

public class TenBidRePair
extends AbstractFormPlugin {
    private static final String TECH_SUFFIX = "_tech";
    private static final String BUS_SUFFIX = "_bus";
    private static final String OTHER_SUFFIX = "_other";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("audit".equals(operateKey)) {
            DynamicObject[] myTenderArray;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
            DynamicObject supplier = dataEntity.getDynamicObject("supplier");
            DynamicObject realBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project", (String)"entitytypeid");
            String appId = realBidProject.getString("entitytypeid").split("_")[0];
            String tenAppId = AppIdUtil.getTenAppId((String)appId);
            ArrayList<QFilter> myTenderQFilterList = new ArrayList<QFilter>();
            myTenderQFilterList.add(new QFilter("bidproject", "=", bidProject.getPkValue()));
            if (supplier != null) {
                myTenderQFilterList.add(new QFilter("supplier", "=", supplier.getPkValue()));
            }
            if ((myTenderArray = BusinessDataServiceHelper.load((String)(tenAppId + "_mytender"), (String)"id", (QFilter[])myTenderQFilterList.toArray(new QFilter[0]))) == null || myTenderArray.length == 0) {
                return;
            }
            for (DynamicObject myTender : myTenderArray) {
                DynamicObject[] onlineBidArray;
                for (DynamicObject onlineBidData : onlineBidArray = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid"), (String)CommonUtil.getAllSelectProperties((String)(tenAppId + "_online_bid")), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)"B"), new QFilter("mytender", "=", myTender.getPkValue())})) {
                    DynamicObject[] onlineBidDetailArray = BusinessDataServiceHelper.load((String)(tenAppId + "_online_bid_detail"), (String)CommonUtil.getAllSelectProperties((String)(tenAppId + "_online_bid_detail")), (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidData.getPkValue())});
                    DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)CommonUtil.getAllSelectProperties((String)(appId + "_bidopen")), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"})}, (String)"createtime asc");
                    if (bidOpenArray == null || bidOpenArray.length == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f00\u6807\u6570\u636e\uff0c\u6570\u636e\u5f02\u5e38", (String)"TenBidRePair_0", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    }
                    this.saveBidOpenData(appId, onlineBidData, onlineBidData.getDynamicObject("supplier"), onlineBidDetailArray, bidOpenArray);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("audit".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            if (operationResult.isSuccess()) {
                dataEntity.set("bizstatus", (Object)"success");
            } else {
                dataEntity.set("bizstatus", (Object)"fail");
            }
            this.getView().updateView("bizstatus");
        }
    }

    public void saveBidOpenData(String appId, DynamicObject onlineBidData, DynamicObject supplier, DynamicObject[] onlineBidDetailArray, DynamicObject[] bidOpenArray) {
        Map map;
        Map busFileMap;
        Map techFileMap;
        ArrayList<Object> onlineBidDetailPkList = new ArrayList<Object>();
        ArrayList<Object> allBidOpenSectionIdList = new ArrayList<Object>();
        HashMap<String, DynamicObject> onlineBidDetailMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
            String sectionStatus = onlineBidDetail.getString("sectionstatus");
            if (!MyTenderStatus.TENDERED.getValue().equals(sectionStatus)) continue;
            String string = onlineBidDetail.getString("sectionname");
            onlineBidDetailMap.put(string, onlineBidDetail);
            onlineBidDetailPkList.add(onlineBidDetail.getPkValue());
        }
        String onlineBidDetailFormId = AppIdUtil.getTenAppId((String)appId) + "_online_bid_detail";
        HashMap<String, List<Map<String, Object>>> fileMap = new HashMap<String, List<Map<String, Object>>>(5);
        List inviteFileList = AttachmentServiceHelper.getAttachments((String)(AppIdUtil.getTenAppId((String)appId) + "_online_bid"), (Object)onlineBidData.getPkValue(), (String)"inviteattachment", (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)inviteFileList)) {
            fileMap.put(onlineBidData.getPkValue().toString(), inviteFileList);
        }
        if (!CollectionUtils.isEmpty((Map)(techFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"techattachment", (boolean)false)))) {
            for (Map.Entry entry : techFileMap.entrySet()) {
                List list = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                fileMap.put((String)entry.getKey() + TECH_SUFFIX, list);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(busFileMap = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"busattachment", (boolean)false)))) {
            for (Map.Entry entry : busFileMap.entrySet()) {
                List fileList = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)fileList)) continue;
                fileMap.put((String)entry.getKey() + BUS_SUFFIX, fileList);
            }
        }
        if (!CollectionUtils.isEmpty((Map)(map = AttachmentServiceHelper.getAttachments((String)onlineBidDetailFormId, (Object[])onlineBidDetailPkList.toArray(), (String)"otherattachment", (boolean)false)))) {
            for (Map.Entry otherFileMapData : map.entrySet()) {
                List fileList = (List)otherFileMapData.getValue();
                if (CollectionUtils.isEmpty((Collection)fileList)) continue;
                fileMap.put((String)otherFileMapData.getKey() + OTHER_SUFFIX, fileList);
            }
        }
        this.setBidOpenData(appId, onlineBidData, onlineBidDetailMap, fileMap, bidOpenArray, supplier, allBidOpenSectionIdList);
        SaveServiceHelper.update((DynamicObject[])bidOpenArray);
        BizLog.log((String)ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199--\u5f00\u6807\u5355\u6210\u529f\uff01", (String)"TenBidRePair_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
    }

    public void setBidOpenData(String appId, DynamicObject onlineBid, HashMap<String, DynamicObject> onlineBidDetailMap, HashMap<String, List<Map<String, Object>>> fileMap, DynamicObject[] bidOpenArray, DynamicObject supplier, List<Object> bidOpenSectionIdList) {
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            HashMap<String, DynamicObject> bidOpenDetailMap = new HashMap<String, DynamicObject>();
            for (DynamicObject bidOpen : bidOpenArray) {
                Object sectionName;
                BizLog.log((String)(ResManager.loadKDString((String)"\u6295\u6807\u53cd\u5199\u5f00\u6807\u5355id\uff1a", (String)"TenBidRePair_2", (String)"scm-ten-formplugin", (Object[])new Object[0]) + bidOpen.getPkValue()));
                DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                    sectionName = bidSection.getString("sectionname");
                    DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        DynamicObject bidOpenSupplier = supplierEntry.getDynamicObject("supplier");
                        DynamicObject onlineBidDetail = onlineBidDetailMap.get(sectionName);
                        if (onlineBidDetail == null || !bidOpenSupplier.getString("id").equals(supplier.getString("id"))) continue;
                        bidOpenSectionIdList.add(bidSection.getPkValue());
                        supplierEntry.set("supplier_istender", (Object)Boolean.TRUE);
                        supplierEntry.set("supplier_tenderdate", (Object)onlineBid.getDate("biddate"));
                        supplierEntry.set("supplier_isfrombackbid", (Object)Boolean.TRUE);
                        supplierEntry.set("supplier_revokebidnumber", (Object)onlineBid.getInt("revokebidnumber"));
                        supplierEntry.set("supplier_manager", onlineBidDetail.get("projectmanage"));
                        supplierEntry.set("supplier_tenderprice", onlineBidDetail.get("tenderprice"));
                        supplierEntry.set("supplier_taxrate", (Object)onlineBidDetail.getBigDecimal("pricevat"));
                        supplierEntry.set("supplier_rate", (Object)onlineBidDetail.getBigDecimal("rate"));
                        supplierEntry.set("supplier_illustration", onlineBidDetail.get("illustration"));
                        supplierEntry.set("supplier_workday", onlineBidDetail.get("workday"));
                        this.copyToEntryAttach(fileMap.get(onlineBid.getPkValue().toString()), supplierEntry, "supplier_tenattach");
                        this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + OTHER_SUFFIX), supplierEntry, "supplier_otherattach");
                        this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + TECH_SUFFIX), supplierEntry, "supplier_techattach");
                        this.copyToEntryAttach(fileMap.get(onlineBidDetail.getPkValue() + BUS_SUFFIX), supplierEntry, "supplier_comattach");
                        supplierEntry.set("tender", (Object)RequestContext.get().getCurrUserId());
                        supplierEntry.set("tenderrecord", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"TenBidRePair_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                        supplierEntry.set("supplier_pricevat", onlineBidDetail.get("tax"));
                        supplierEntry.set("supplier_exceptvat", onlineBidDetail.get("notaxtenderprice"));
                    }
                }
                for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
                    for (DynamicObject bidOpenDetailEntry : bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail")) {
                        DynamicObject bidOpenDetailSupplier = bidOpenDetailEntry.getDynamicObject("pursupplier");
                        if (bidOpenDetailSupplier == null || !bidOpenDetailSupplier.getString("id").equals(supplier.getString("id"))) continue;
                        DynamicObject bidOpenDetailMaterial = bidOpenDetailEntry.getDynamicObject("materialid");
                        String sectionName2 = bidOpenSectionEntry.getString("sectionname");
                        String key = TenBidRePair.createKey(sectionName2, bidOpenDetailEntry, bidOpenDetailMaterial, appId);
                        bidOpenDetailMap.put(key, bidOpenDetailEntry);
                    }
                }
                for (Map.Entry<String, DynamicObject> onlineBidDetailMapData : onlineBidDetailMap.entrySet()) {
                    sectionName = onlineBidDetailMapData.getKey();
                    DynamicObject onlineBidDetail = onlineBidDetailMapData.getValue();
                    for (DynamicObject bidOpenSectionEntry : bidOpen.getDynamicObjectCollection("bidsection")) {
                        if (!((String)sectionName).equals(bidOpenSectionEntry.getString("sectionname"))) continue;
                        DynamicObjectCollection bidOpenDetailColl = bidOpenSectionEntry.getDynamicObjectCollection("supplierdetail");
                        for (DynamicObject onlineBidSupplierDetailEntry : onlineBidDetail.getDynamicObjectCollection("supplierdetail")) {
                            DynamicObject biddingDetailMaterial;
                            String key = TenBidRePair.createKey((String)sectionName, onlineBidSupplierDetailEntry, biddingDetailMaterial = onlineBidSupplierDetailEntry.getDynamicObject("materialid"), appId);
                            if (bidOpenDetailMap.containsKey(key)) {
                                DynamicObject bidOpenDetail = (DynamicObject)bidOpenDetailMap.get(key);
                                bidOpenDetail.set("inclutaxprice", onlineBidSupplierDetailEntry.get("inclutaxprice"));
                                bidOpenDetail.set("inclutaxamount", onlineBidSupplierDetailEntry.get("inclutaxamount"));
                                bidOpenDetail.set("taxrate", onlineBidSupplierDetailEntry.get("taxrate"));
                                bidOpenDetail.set("taxamount", onlineBidSupplierDetailEntry.get("taxamount"));
                                bidOpenDetail.set("excepttaxamount", onlineBidSupplierDetailEntry.get("excepttaxamount"));
                                bidOpenDetail.set("costrate", onlineBidSupplierDetailEntry.get("costrate"));
                                bidOpenDetail.set("bd_taxrate", onlineBidSupplierDetailEntry.get("bd_taxrate"));
                                continue;
                            }
                            DynamicObject newSupplierDetail = bidOpenDetailColl.addNew();
                            newSupplierDetail.set("seq", (Object)bidOpenDetailColl.size());
                            newSupplierDetail.set("pursupplier", (Object)supplier);
                            newSupplierDetail.set("purentrycontent", onlineBidSupplierDetailEntry.get("purentrycontent"));
                            newSupplierDetail.set("purentryproject", onlineBidSupplierDetailEntry.get("purentryproject"));
                            newSupplierDetail.set("materialid", onlineBidSupplierDetailEntry.get("materialid"));
                            newSupplierDetail.set("materialdes", onlineBidSupplierDetailEntry.get("materialdes"));
                            newSupplierDetail.set("qty", onlineBidSupplierDetailEntry.get("qty"));
                            newSupplierDetail.set("inclutaxprice", onlineBidSupplierDetailEntry.get("inclutaxprice"));
                            newSupplierDetail.set("inclutaxamount", onlineBidSupplierDetailEntry.get("inclutaxamount"));
                            newSupplierDetail.set("bd_taxrate", onlineBidSupplierDetailEntry.get("bd_taxrate"));
                            newSupplierDetail.set("taxrate", onlineBidSupplierDetailEntry.get("taxrate"));
                            newSupplierDetail.set("taxamount", onlineBidSupplierDetailEntry.get("taxamount"));
                            newSupplierDetail.set("excepttaxamount", onlineBidSupplierDetailEntry.get("excepttaxamount"));
                            newSupplierDetail.set("costrate", onlineBidSupplierDetailEntry.get("costrate"));
                            if (!"rebm".equals(appId)) continue;
                            newSupplierDetail.set("listnumber", onlineBidSupplierDetailEntry.get("listnumber"));
                            newSupplierDetail.set("listname", onlineBidSupplierDetailEntry.get("listname"));
                            newSupplierDetail.set("resourceitem", onlineBidSupplierDetailEntry.get("resourceitem"));
                        }
                    }
                }
            }
        }
    }

    protected void copyToEntryAttach(List<Map<String, Object>> attachList, DynamicObject supplierEntry, String entryProperty) {
        List attachments = AttachmentUtil.copyToEntryAttachment(attachList);
        DynamicObjectCollection inviteAttachFiles = supplierEntry.getDynamicObjectCollection(entryProperty);
        inviteAttachFiles.clear();
        attachments.stream().forEach(item -> {
            DynamicObject inviteAttach = inviteAttachFiles.addNew();
            inviteAttach.set("fbasedataid", item);
        });
        supplierEntry.set(entryProperty, (Object)inviteAttachFiles);
    }

    public static String createKey(String sectionName, DynamicObject detailEntry, DynamicObject detailMaterial, String appId) {
        StringJoiner stringJoiner = new StringJoiner("|");
        stringJoiner.add(sectionName);
        stringJoiner.add(StringUtils.isEmpty((CharSequence)detailEntry.getString("purentrycontent")) ? "" : detailEntry.getString("purentrycontent"));
        stringJoiner.add(detailMaterial == null ? "" : detailMaterial.getPkValue().toString());
        stringJoiner.add(detailEntry.getDynamicObject("purentryproject") == null ? "" : detailEntry.getDynamicObject("purentryproject").getString("id"));
        stringJoiner.add(detailEntry.getString("materialdes") == null ? "" : detailEntry.getString("materialdes"));
        if ("rebm".equals(appId)) {
            stringJoiner.add(detailEntry.getDynamicObject("resourceitem") == null ? "" : detailEntry.getDynamicObject("resourceitem").getString("id"));
        }
        return stringJoiner.toString();
    }
}

