/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.untender;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.formplugin.util.BidMessageUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class TenUnTenderConfirmEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_MYFIELDCONTAINER = "checkpanel";
    private static final String BTN_CONFIRM = "confirm";
    private static final String BID_PROJECT = "bidproject";
    private static final String ORG = "orgname";
    private static final String CONTACTS = "contacts";
    private static final String PHONE = "phone";
    private static final String ADDRESS = "address";
    private static final String FAX = "fax";
    private static final String EMAIL = "email";
    private static final String REASON = "reason";
    private static final String BILL_NO = "billno";
    private static final String SUPPLIER = "supplierid";
    private static final String MY_TENDER = "mytenderid";

    public void onGetControl(OnGetControlArgs e) {
        if (e.getKey().startsWith("section")) {
            FieldEdit textEdit = new FieldEdit();
            textEdit.setKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object bidProjectPk = parameter.getCustomParam("bidProjectId");
        Object supplierId = parameter.getCustomParam("supplierId");
        Object myTenderId = parameter.getCustomParam("myTenderId");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectPk, (String)FormTypeConstants.getFormConstant((String)"project", ((Object)((Object)this)).getClass()));
        String uid = RequestContext.get().getUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)uid, (String)"bos_user");
        QFilter filter = new QFilter("user", "=", (Object)Long.parseLong(uid));
        DynamicObject partner = BusinessDataServiceHelper.loadSingle((String)"bos_bizpartneruser", (String)"bizpartner,org", (QFilter[])new QFilter[]{filter});
        String appId = this.getAppId();
        if (partner != null) {
            DynamicObject bizpartner = (DynamicObject)partner.get("bizpartner");
            String id = bizpartner.get("id").toString();
            DynamicObject userPartner = SupplierUtil.getPartner();
            if (!"ten".equals(appId)) {
                DynamicObject supplier = SupplierUtil.getRESMSupplier();
                DynamicObject respPartner = supplier.getDynamicObject("bizpartner");
                userPartner = BusinessDataServiceHelper.loadSingle((Object)respPartner.getPkValue(), (String)"bd_bizpartner");
            }
            if (userPartner == null) {
                return;
            }
            this.getModel().setValue(SUPPLIER, supplierId);
            this.getModel().setValue(MY_TENDER, myTenderId);
            this.getModel().setValue(BILL_NO, (Object)new Date().getTime());
            this.getModel().setValue(BID_PROJECT, (Object)bidProject);
            this.getModel().setValue(ORG, userPartner.get("name"));
            this.getModel().setValue(ADDRESS, userPartner.get(ADDRESS));
            this.getModel().setValue(FAX, userPartner.get(FAX));
            this.getModel().setValue(CONTACTS, user.get("name"));
            this.getModel().setValue(PHONE, user.get(PHONE));
            this.getModel().setValue(EMAIL, user.get(EMAIL));
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter parameter = (FormShowParameter)e.getSource();
        Object bidProjectPk = parameter.getCustomParam("bidProjectId");
        Map<String, String> sectionMap = TenUnTenderConfirmEditPlugin.getSection(this.getAppId(), bidProjectPk);
        FlexPanelAp headAp = this.createDynamicPanel(sectionMap);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", KEY_MYFIELDCONTAINER);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("DynamicCreateCardEntry", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void registDynamicProps(MainEntityType newMainType) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object bidProjectPk = parameter.getCustomParam("bidProjectId");
        Map<String, String> sectionMap = TenUnTenderConfirmEditPlugin.getSection(this.getAppId(), bidProjectPk);
        for (String sectionId : sectionMap.keySet()) {
            BooleanProp boolProp1 = new BooleanProp();
            boolProp1.setName("section" + sectionId);
            boolProp1.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u590d\u9009\u6846", (String)"TenUnTenderConfirmEditPlugin_0", (String)"scm-ten-formplugin", (Object[])new Object[0])));
            boolProp1.setDbIgnore(true);
            boolProp1.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)boolProp1);
        }
    }

    private FlexPanelAp createDynamicPanel(Map<String, String> seticonMap) {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setLeft("12px");
        style.setMargin(margin);
        for (Map.Entry<String, String> section : seticonMap.entrySet()) {
            FieldAp checkboxAp = new FieldAp();
            checkboxAp.setId("section" + section.getKey());
            checkboxAp.setKey("section" + section.getKey());
            checkboxAp.setName(new LocaleString(section.getValue()));
            checkboxAp.setBackColor("#FFFFFF");
            checkboxAp.setWidth(new LocaleString("90px"));
            checkboxAp.setStyle(style);
            checkboxAp.setHeight(new LocaleString("20px"));
            checkboxAp.setFireUpdEvt(true);
            CheckBoxField checkboxField = new CheckBoxField();
            checkboxField.setId("section" + section.getKey());
            checkboxField.setKey("section" + section.getKey());
            checkboxField.setShowStyle(1);
            checkboxAp.setField((Field)checkboxField);
            headPanelAp.getItems().add(checkboxAp);
        }
        return headPanelAp;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        Map<String, String> selectSectionMap = this.getSelectBidSection();
        if (operateKey.equals(BTN_CONFIRM)) {
            if (selectSectionMap.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6807\u6bb5", (String)"TenUnTenderConfirmEditPlugin_1", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String phone = dataEntity.getString(PHONE);
            String email = dataEntity.getString(EMAIL);
            String emailRegexRule = "@";
            String emailRegexRule1 = ".";
            String[] split = email.split(emailRegexRule);
            String phoneRegex = "^1[0-9]{10}$";
            if (split == null || split.length <= 1 || split[1].startsWith(emailRegexRule1) || split[1].endsWith(emailRegexRule1) || !split[1].contains(emailRegexRule1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u90ae\u7bb1\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TenUnTenderConfirmEditPlugin_4", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!phone.matches(phoneRegex)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TenUnTenderConfirmEditPlugin_5", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CONFIRM, (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5f03\u6807\u540e\u5c06\u65e0\u6cd5\u53c2\u4e0e\u8be5\u6807\u6bb5\u540e\u7eed\u6295\u6807\u73af\u8282\uff0c\u662f\u5426\u5f03\u6807\uff1f", (String)"TenUnTenderConfirmEditPlugin_7", (String)"scm-ten-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (BTN_CONFIRM.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Map<String, String> selectSectionMap = this.getSelectBidSection();
            DynamicObjectCollection sectionEntryCol = dataEntity.getDynamicObjectCollection("sectionentry");
            ArrayList<String> sectionNameList = new ArrayList<String>(16);
            for (Map.Entry<String, String> selectSectionMapData : selectSectionMap.entrySet()) {
                DynamicObject sectionEntry = sectionEntryCol.addNew();
                sectionEntry.set("sectionname", (Object)selectSectionMapData.getValue());
                sectionNameList.add(selectSectionMapData.getValue());
            }
            String appId = this.getAppId();
            HashSet<String> supplierIds = new HashSet<String>();
            if ("resp".equals(appId)) {
                DynamicObject currentSupplier = SupplierUtil.getRESMSupplier();
                supplierIds.add(currentSupplier.getPkValue().toString());
            } else {
                DynamicObject[] byUser;
                for (DynamicObject temp : byUser = SupplierUtil.getSupplierByUser()) {
                    supplierIds.add(temp.getPkValue().toString());
                }
            }
            this.getView().invokeOperation("save");
            Object bidProjectId = dataEntity.getDynamicObject(BID_PROJECT).getPkValue();
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.updateMyTenderStatus(dataEntity, sectionNameList);
                    this.updateBidOpen(supplierIds, bidProjectId, sectionNameList);
                    BidMessageUtil.sendMsgByUntender(appId, dataEntity);
                    IFormView formView = this.getView().getParentView();
                    formView.showSuccessNotification(ResManager.loadKDString((String)"\u5f03\u6807\u6210\u529f", (String)"TenUnTenderConfirmEditPlugin_3", (String)"scm-ten-formplugin", (Object[])new Object[0]));
                    formView.invokeOperation("refresh");
                    this.getView().sendFormAction(formView);
                    this.getView().invokeOperation("close");
                }
                catch (Exception ex) {
                    h.markRollback();
                    throw ex;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    public void updateMyTenderStatus(DynamicObject dataEntity, List<String> sectionNameList) {
        Long myTenderId = dataEntity.getLong(MY_TENDER);
        DynamicObject myTenderObject = BusinessDataServiceHelper.loadSingle((Object)myTenderId, (String)TenFormTypeConstants.getFormConstant((String)"mytender", ((Object)((Object)this)).getClass()), (String)"id,bidproject,tenderstatus,entry,entry.projectsection,entry.sectionname,entry.sectionstatus,entry.untenderflag");
        DynamicObjectCollection myTenderSectionEntryCol = myTenderObject.getDynamicObjectCollection("entry");
        for (DynamicObject myTenderEntry : myTenderObject.getDynamicObjectCollection("entry")) {
            String sectionName = myTenderEntry.getString("sectionname");
            if (!sectionNameList.contains(sectionName)) continue;
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
            myTenderEntry.set("untenderflag", (Object)Boolean.TRUE);
        }
        ArrayList<String> sectionStatusList = new ArrayList<String>();
        for (DynamicObject myTenderSectionEntry : myTenderSectionEntryCol) {
            String sectionStatus = myTenderSectionEntry.getString("sectionstatus");
            sectionStatusList.add(sectionStatus);
        }
        if (sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue())) {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
        } else if (!sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue()) && sectionStatusList.contains(MyTenderStatus.TENDERED.getValue())) {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
        } else {
            myTenderObject.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
        }
        SaveServiceHelper.update((DynamicObject)myTenderObject);
    }

    public void updateBidOpen(Set<String> supplierPkSet, Object bidProjectId, List<String> selectSectionNameList) {
        String selectBidOpenProperties = "id,entitytypeid,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier, supplierentry.supplier_isinvalid,supplierentry.untenderflag,supplierentry.untendertype,supplierentry.untenderreason, supplierentry.untenderattach,supplierentry.suppliercontact,supplierentry.contactphone,supplierentry.supplier_techattach,supplierentry.supplier_comattach,supplierentry.supplier_tenattach,supplierentry.supplier_otherattach";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bidopen", ((Object)((Object)this)).getClass()), (String)selectBidOpenProperties, (QFilter[])new QFilter[]{new QFilter(BID_PROJECT, "=", bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})});
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            for (DynamicObject bidOpen : bidOpenArray) {
                DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionColl) {
                    String sectionName = bidSection.getString("sectionname");
                    if (!selectSectionNameList.contains(sectionName)) continue;
                    DynamicObjectCollection supplierEntryCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCollection) {
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null || !supplierPkSet.contains(supplier.getString("id"))) continue;
                        supplierEntry.set("supplier_isinvalid", (Object)Boolean.FALSE);
                        supplierEntry.set("untendertype", (Object)"0");
                        supplierEntry.set("untenderflag", (Object)Boolean.TRUE);
                        supplierEntry.set("untenderreason", dataEntity.get(REASON));
                        supplierEntry.set("suppliercontact", dataEntity.get(CONTACTS));
                        supplierEntry.set("contactphone", dataEntity.get(PHONE));
                        supplierEntry.getDynamicObjectCollection("supplier_techattach").clear();
                        supplierEntry.getDynamicObjectCollection("supplier_comattach").clear();
                        supplierEntry.getDynamicObjectCollection("supplier_tenattach").clear();
                        supplierEntry.getDynamicObjectCollection("supplier_otherattach").clear();
                        List fileList = AttachmentServiceHelper.getAttachments((String)(this.getAppId() + "_untender_confirm"), (Object)this.getModel().getDataEntity(true).getPkValue(), (String)"attachmentpanel");
                        List attachments = AttachmentUtil.copyToEntryAttachment((List)fileList);
                        DynamicObjectCollection untenderAttachs = supplierEntry.getDynamicObjectCollection("untenderattach");
                        untenderAttachs.clear();
                        attachments.stream().forEach(item -> {
                            DynamicObject untenderAttach = untenderAttachs.addNew();
                            untenderAttach.set("fbasedataid", item);
                        });
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])bidOpenArray);
        }
    }

    public Map<String, String> getSelectBidSection() {
        HashMap<String, String> selectSectionMap = new HashMap<String, String>();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject bidProject = dataEntity.getDynamicObject(BID_PROJECT);
        Map<String, String> sectionMap = TenUnTenderConfirmEditPlugin.getSection(this.getAppId(), bidProject.getPkValue());
        for (Map.Entry<String, String> checkSectionData : sectionMap.entrySet()) {
            String key = checkSectionData.getKey();
            Boolean isCheck = (Boolean)dataEntity.get("section" + key);
            if (!isCheck.booleanValue()) continue;
            selectSectionMap.put(key, checkSectionData.getValue());
        }
        return selectSectionMap;
    }

    private String getAppId() {
        return ((Object)((Object)this)).getClass().getPackage().getName().split("\\.")[2];
    }

    public static Map<String, String> getSection(String appId, Object bidProjectId) {
        TreeMap<String, String> sectionMap = new TreeMap<String, String>();
        List<Object> pkSet = SupplierUtil.getSupplierPkArray();
        if ("resp".equals(appId)) {
            DynamicObject currentSupplier = SupplierUtil.getRESMSupplier();
            pkSet.add(currentSupplier.getPkValue());
        }
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((String)(appId + "_mytender"), (String)"entry,projectsection,sectionname,sectionstatus", (QFilter[])new QFilter[]{new QFilter("supplier", "in", pkSet), new QFilter(BID_PROJECT, "=", bidProjectId)});
        DynamicObjectCollection tenderEntryCol = myTender.getDynamicObjectCollection("entry");
        for (DynamicObject tenderEntry : tenderEntryCol) {
            String sectionName = tenderEntry.getString("sectionname");
            String sectionStatus = tenderEntry.getString("sectionstatus");
            DynamicObject projectSection = tenderEntry.getDynamicObject("projectsection");
            if (!MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) continue;
            sectionMap.put(String.valueOf(projectSection.getPkValue()), sectionName);
        }
        return sectionMap;
    }
}

