/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.BidMessageUtil;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;
import kd.scm.ten.formplugin.util.TenderRecordUtil;

public class BidRevokeUtil {
    public static synchronized void revokeBid(DynamicObject onlineBidEntity) {
        DynamicObject bidProject = onlineBidEntity.getDynamicObject("bidproject");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        if ((bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_project"))) != null) {
            Object orgPk = bidProject.getDynamicObject("org").getPkValue();
            DynamicObject supplier = null;
            if ("bid".equals(appId)) {
                supplier = SupplierUtil.getSupplierByOrg(bidProject.getPkValue(), orgPk);
            } else if ("rebm".equals(appId)) {
                supplier = SupplierUtil.getRESMSupplier();
            }
            String tenAppId = AppIdUtil.getTenAppId((String)appId);
            ArrayList<String> currentSectionList = new ArrayList<String>();
            DynamicObjectCollection sectionEntryCol = onlineBidEntity.getDynamicObjectCollection("sectionentry");
            for (DynamicObject sectionEntry : sectionEntryCol) {
                String sectionStatus = sectionEntry.getString("sectionstatus");
                String sectionName = sectionEntry.getString("sectionname");
                Boolean currentRoundFlag = sectionEntry.getBoolean("currentroundflag");
                if (!currentRoundFlag.booleanValue() || !MyTenderStatus.TENDERED.getValue().equals(sectionStatus)) continue;
                sectionEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                currentSectionList.add(sectionName);
            }
            String onlineBidDetailFormId = tenAppId + "_online_bid_detail";
            DynamicObject[] onlineBidDetailArray = BusinessDataServiceHelper.load((String)onlineBidDetailFormId, (String)CommonUtil.getAllSelectProperties((String)onlineBidDetailFormId), (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidEntity.getPkValue()), new QFilter("sectionname", "in", currentSectionList)});
            String bidOpenFormId = appId + "_bidopen";
            DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)bidOpenFormId, (String)CommonUtil.getAllSelectProperties((String)bidOpenFormId), (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "in", (Object)new String[]{"D", "A"})});
            if (bidOpenArray != null && bidOpenArray.length > 0) {
                BidRevokeUtil.revokeBidOpenData(appId, onlineBidEntity, onlineBidDetailArray, bidOpenArray, supplier, bidProject);
                BidRevokeUtil.revokeUpdateMyTenderStatus(tenAppId, onlineBidEntity, currentSectionList);
                int revokeBidNumber = onlineBidEntity.getInt("revokebidnumber");
                onlineBidEntity.set("revokebidnumber", (Object)(revokeBidNumber + 1));
                onlineBidEntity.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                onlineBidEntity.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                onlineBidEntity.set("biddate", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlineBidEntity});
                TenderRecordUtil.createTenderRecordDataV2(onlineBidEntity, appId, false, currentSectionList, bidOpenArray);
                BidMessageUtil.sendRevokeBidMessage(appId, onlineBidEntity, bidProject, bidOpenArray[0], supplier);
            }
        }
    }

    public static void revokeBidOpenData(String bidAppId, DynamicObject onlineBid, DynamicObject[] onlineBidDetailArray, DynamicObject[] bidOpenArray, DynamicObject supplier, DynamicObject bidProject) {
        HashMap<String, DynamicObject> onlineBidDetailMap = new HashMap<String, DynamicObject>();
        for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
            onlineBidDetail.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
            onlineBidDetail.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
            String sectionName = onlineBidDetail.getString("sectionname");
            onlineBidDetailMap.put(sectionName, onlineBidDetail);
        }
        boolean isIllegal = false;
        for (DynamicObject bidOpen : bidOpenArray) {
            DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                String sectionName = bidSection.getString("sectionname");
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntryColl.size(); ++j) {
                    DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                    DynamicObject bidOpenSupplier = supplierEntry.getDynamicObject("supplier");
                    DynamicObject onlineBidDetail = (DynamicObject)onlineBidDetailMap.get(sectionName);
                    if (onlineBidDetail == null || !bidOpenSupplier.getPkValue().toString().equals(supplier.getPkValue().toString())) continue;
                    supplierEntry.set("supplier_istender", (Object)Boolean.FALSE);
                    supplierEntry.set("supplier_revokebidnumber", (Object)onlineBid.getInt("revokebidnumber"));
                    supplierEntry.set("supplier_tenderdate", null);
                    supplierEntry.set("supplier_isfrombackbid", (Object)Boolean.TRUE);
                    supplierEntry.set("supplier_manager", null);
                    supplierEntry.set("supplier_tenderprice", null);
                    supplierEntry.set("supplier_taxrate", null);
                    supplierEntry.set("supplier_rate", null);
                    supplierEntry.set("supplier_illustration", null);
                    supplierEntry.set("supplier_workday", null);
                    supplierEntry.set("supplier_ip", (Object)IsIllegalBidUtil.getLoginIp());
                    supplierEntry.set("supplier_pricevat", null);
                    supplierEntry.set("supplier_exceptvat", null);
                    supplierEntry.getDynamicObjectCollection("supplier_techattach").clear();
                    supplierEntry.getDynamicObjectCollection("supplier_comattach").clear();
                    supplierEntry.getDynamicObjectCollection("supplier_tenattach").clear();
                    supplierEntry.getDynamicObjectCollection("supplier_otherattach").clear();
                    supplierEntry.set("tender", (Object)RequestContext.get().getCurrUserId());
                    String entityName = "bid".equals(bidAppId) ? "bid_tenderrecord" : "rebm_tenderrecord";
                    isIllegal = IsIllegalBidUtil.isIllegalBidInOpen((Long)supplier.getPkValue(), (Long)bidProject.getPkValue(), bidSection.getString("sectionname"), RequestContext.get().getLoginIP(), entityName);
                    supplierEntry.set("isillegalbid", (Object)isIllegal);
                }
                DynamicObjectCollection supplierDetailColl = bidSection.getDynamicObjectCollection("supplierdetail");
                for (DynamicObject bidOpendDetail : supplierDetailColl) {
                    if (bidOpendDetail == null) continue;
                    DynamicObject purSupplier = bidOpendDetail.getDynamicObject("pursupplier");
                    if (bidOpendDetail == null || purSupplier == null || supplier == null || !StringUtils.equals((CharSequence)supplier.getPkValue().toString(), (CharSequence)purSupplier.getPkValue().toString())) continue;
                    bidOpendDetail.set("inclutaxprice", null);
                    bidOpendDetail.set("inclutaxamount", null);
                    bidOpendDetail.set("taxrate", null);
                    bidOpendDetail.set("taxamount", null);
                    bidOpendDetail.set("excepttaxamount", null);
                    bidOpendDetail.set("costrate", null);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])bidOpenArray);
        SaveServiceHelper.save((DynamicObject[])onlineBidDetailArray);
    }

    public static void revokeUpdateMyTenderStatus(String appId, DynamicObject onlineBidData, List<String> currentSectionList) {
        DynamicObject myTender = onlineBidData.getDynamicObject("mytender");
        DynamicObject[] onlineBidDetailArray = BusinessDataServiceHelper.load((String)(appId + "_online_bid_detail"), (String)"supplier,sectionname", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidData.getPkValue()), new QFilter("sectionname", "in", currentSectionList)});
        ArrayList<String> sectionNameList = new ArrayList<String>(16);
        for (DynamicObject onlineBidDetail : onlineBidDetailArray) {
            sectionNameList.add(onlineBidDetail.getString("sectionname"));
        }
        DynamicObject myTenderObject = BusinessDataServiceHelper.loadSingle((Object)myTender.getPkValue(), (String)(appId + "_mytender"), (String)"bidproject,tenderstatus,biddingdate,entry,entry.projectsection,entry.sectionname,entry.sectionstatus");
        DynamicObjectCollection myTenderSectionEntryCol = myTenderObject.getDynamicObjectCollection("entry");
        for (DynamicObject myTenderEntry : myTenderSectionEntryCol) {
            String sectionName = myTenderEntry.getString("sectionname");
            if (!sectionNameList.contains(sectionName)) continue;
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
        }
        myTenderObject.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
        myTenderObject.set("biddingdate", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{myTenderObject});
    }

    public static void removeAllFileBySupplier(Object supplierId, List<Object> sectionIdList, boolean isResp) {
        String entityName = "bid_supplier_file";
        if (isResp) {
            entityName = "rebm_supplier_file";
        }
        QFilter filter = new QFilter("supplierid", "=", supplierId);
        QFilter filter1 = new QFilter("sectionid", "in", sectionIdList);
        QFilter filter2 = new QFilter("status", "=", (Object)"A");
        DynamicObject[] supplierFiles = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter, filter1, filter2});
        if (supplierFiles.length > 0) {
            Object[] idArr = Arrays.stream(supplierFiles).map(DataEntityBase::getPkValue).toArray();
            DeleteServiceHelper.delete((IDataEntityType)supplierFiles[0].getDataEntityType(), (Object[])idArr);
        }
    }
}

