/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;

public class CopyFileToBidOpenUtil
implements Runnable {
    private String appId;
    private DynamicObject onlineBid;
    private DynamicObject[] bidOpenArray;
    private Map<Object, DynamicObject> supplierMap;
    private HashMap<String, DynamicObject> onlineBidDetailMap;
    private List<Map<String, Object>> inviteFileList;
    private Map<String, List<Map<String, Object>>> techFileMap;
    private Map<String, List<Map<String, Object>>> busFileMap;
    private Map<String, List<Map<String, Object>>> otherFileMap;

    public CopyFileToBidOpenUtil(String appId, DynamicObject onlineBid, DynamicObject[] bidOpenArray, Map<Object, DynamicObject> supplierMap, HashMap<String, DynamicObject> onlineBidDetailMap, List<Map<String, Object>> inviteFileList, Map<String, List<Map<String, Object>>> techFileMap, Map<String, List<Map<String, Object>>> busFileMap, Map<String, List<Map<String, Object>>> otherFileMap) {
        this.appId = appId;
        this.onlineBid = onlineBid;
        this.bidOpenArray = bidOpenArray;
        this.supplierMap = supplierMap;
        this.onlineBidDetailMap = onlineBidDetailMap;
        this.inviteFileList = inviteFileList;
        this.techFileMap = techFileMap;
        this.busFileMap = busFileMap;
        this.otherFileMap = otherFileMap;
    }

    @Override
    public void run() {
        String fileFormId = this.appId + "_supplier_file";
        for (DynamicObject bidOpen : this.bidOpenArray) {
            DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            bidSectionColl.forEach(bidSection -> {
                DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                String sectionName = bidSection.getString("sectionname");
                supplierEntryColl.forEach(supplierEntry -> {
                    DynamicObject onlineBidDetail;
                    Object supplierId = supplierEntry.getDynamicObject("supplier").getPkValue();
                    DynamicObject tempSupplier = this.supplierMap.get(supplierId);
                    if (tempSupplier != null && (onlineBidDetail = this.onlineBidDetailMap.get(sectionName)) != null) {
                        List<Map<String, Object>> busFileList;
                        List<Map<String, Object>> techFileList;
                        DeleteServiceHelper.delete((String)fileFormId, (QFilter[])new QFilter[]{new QFilter("sectionid", "=", bidSection.getPkValue()), new QFilter("supplierid", "=", supplierId)});
                        DynamicObject techFile = BusinessDataServiceHelper.newDynamicObject((String)fileFormId);
                        techFile.set("id", (Object)ID.genLongId());
                        techFile.set("sectionid", bidSection.getPkValue());
                        techFile.set("status", (Object)"A");
                        techFile.set("supplierid", supplierId);
                        techFile.set("type", (Object)"techFile");
                        DynamicObject tenFile = BusinessDataServiceHelper.newDynamicObject((String)fileFormId);
                        tenFile.set("id", (Object)ID.genLongId());
                        tenFile.set("sectionid", bidSection.getPkValue());
                        tenFile.set("status", (Object)"A");
                        tenFile.set("supplierid", supplierId);
                        tenFile.set("type", (Object)"tenFile");
                        DynamicObject comFile = BusinessDataServiceHelper.newDynamicObject((String)fileFormId);
                        comFile.set("id", (Object)ID.genLongId());
                        comFile.set("sectionid", bidSection.getPkValue());
                        comFile.set("status", (Object)"A");
                        comFile.set("supplierid", supplierId);
                        comFile.set("type", (Object)"comFile");
                        DynamicObject otherFile = BusinessDataServiceHelper.newDynamicObject((String)fileFormId);
                        otherFile.set("id", (Object)ID.genLongId());
                        otherFile.set("sectionid", bidSection.getPkValue());
                        otherFile.set("status", (Object)"A");
                        otherFile.set("supplierid", supplierId);
                        otherFile.set("type", (Object)"otherFile");
                        ArrayList<DynamicObject> saveFileDataList = new ArrayList<DynamicObject>();
                        List<Map<String, Object>> otherFileList = this.otherFileMap.get(onlineBidDetail.getPkValue().toString());
                        if (!CollectionUtils.isEmpty(otherFileList)) {
                            saveFileDataList.add(otherFile);
                        }
                        if (!CollectionUtils.isEmpty(techFileList = this.techFileMap.get(onlineBidDetail.getPkValue().toString()))) {
                            saveFileDataList.add(techFile);
                        }
                        if (!CollectionUtils.isEmpty(busFileList = this.busFileMap.get(onlineBidDetail.getPkValue().toString()))) {
                            saveFileDataList.add(comFile);
                        }
                        if (!CollectionUtils.isEmpty(this.inviteFileList)) {
                            saveFileDataList.add(tenFile);
                        }
                        if (!CollectionUtils.isEmpty(saveFileDataList)) {
                            DynamicObject[] saveData = new DynamicObject[saveFileDataList.size()];
                            SaveServiceHelper.save((DynamicObject[])saveFileDataList.toArray(saveData));
                        }
                        try (TXHandle h = TX.requiresNew();){
                            try {
                                if (!CollectionUtils.isEmpty(techFileList)) {
                                    BidFileHelper.copyFileToBillByPk((String)fileFormId, (Object)techFile.getPkValue(), (String)"attachmentpanelap", techFileList);
                                }
                                if (!CollectionUtils.isEmpty(busFileList)) {
                                    BidFileHelper.copyFileToBillByPk((String)fileFormId, (Object)comFile.getPkValue(), (String)"attachmentpanelap", busFileList);
                                }
                                if (!CollectionUtils.isEmpty(otherFileList)) {
                                    BidFileHelper.copyFileToBillByPk((String)fileFormId, (Object)otherFile.getPkValue(), (String)"attachmentpanelap", otherFileList);
                                }
                                if (!CollectionUtils.isEmpty(this.inviteFileList)) {
                                    BidFileHelper.copyFileToBillByPk((String)fileFormId, (Object)tenFile.getPkValue(), (String)"attachmentpanelap", this.inviteFileList);
                                }
                            }
                            catch (Throwable ex) {
                                h.markRollback();
                                throw ex;
                            }
                        }
                    }
                });
            });
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public DynamicObject getOnlineBid() {
        return this.onlineBid;
    }

    public void setOnlineBid(DynamicObject onlineBid) {
        this.onlineBid = onlineBid;
    }

    public DynamicObject[] getBidOpenArray() {
        return this.bidOpenArray;
    }

    public void setBidOpenArray(DynamicObject[] bidOpenArray) {
        this.bidOpenArray = bidOpenArray;
    }

    public Map<Object, DynamicObject> getSupplierMap() {
        return this.supplierMap;
    }

    public void setSupplierMap(Map<Object, DynamicObject> supplierMap) {
        this.supplierMap = supplierMap;
    }

    public HashMap<String, DynamicObject> getOnlineBidDetailMap() {
        return this.onlineBidDetailMap;
    }

    public void setOnlineBidDetailMap(HashMap<String, DynamicObject> onlineBidDetailMap) {
        this.onlineBidDetailMap = onlineBidDetailMap;
    }

    public List<Map<String, Object>> getInviteFileList() {
        return this.inviteFileList;
    }

    public void setInviteFileList(List<Map<String, Object>> inviteFileList) {
        this.inviteFileList = inviteFileList;
    }

    public Map<String, List<Map<String, Object>>> getTechFileMap() {
        return this.techFileMap;
    }

    public void setTechFileMap(Map<String, List<Map<String, Object>>> techFileMap) {
        this.techFileMap = techFileMap;
    }

    public Map<String, List<Map<String, Object>>> getBusFileMap() {
        return this.busFileMap;
    }

    public void setBusFileMap(Map<String, List<Map<String, Object>>> busFileMap) {
        this.busFileMap = busFileMap;
    }

    public Map<String, List<Map<String, Object>>> getOtherFileMap() {
        return this.otherFileMap;
    }

    public void setOtherFileMap(Map<String, List<Map<String, Object>>> otherFileMap) {
        this.otherFileMap = otherFileMap;
    }
}

