/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class IsIllegalBidUtil {
    private static final String OPEN = "open";
    private static final String PUBLISH = "publish";
    private static final String ANSWER = "answer";
    private static final String CLAFITY = "clafity";

    public static boolean isIllegalBidInOpen(long supplierId, long bidprojectId, String sectionname, String ip, String entityName) {
        DynamicObjectCollection records;
        boolean exists = false;
        DynamicObjectCollection selfRecords = QueryServiceHelper.query((String)entityName, (String)"ip", (QFilter[])new QFilter[]{new QFilter("supplier", "=", (Object)supplierId), new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("sectionname", "=", (Object)sectionname)});
        HashSet<String> ips = new HashSet<String>(16);
        ips.add(ip);
        if (selfRecords != null && selfRecords.size() > 0) {
            List hisIps = selfRecords.stream().map(e -> e.getString("ip")).collect(Collectors.toList());
            ips.addAll(hisIps);
        }
        if ((records = QueryServiceHelper.query((String)entityName, (String)"supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "!=", (Object)supplierId), new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("sectionname", "=", (Object)sectionname), new QFilter("ip", "in", ips)})) != null && records.size() > 0) {
            exists = true;
        }
        if (exists) {
            List<Long> suppliers = records.stream().map(e -> e.getLong("supplier")).collect(Collectors.toList());
            IsIllegalBidUtil.setOtherSupplierIllegalBid(suppliers, bidprojectId, sectionname, ip, OPEN, entityName.split("_")[0]);
            DynamicObject[] tenderrecords = BusinessDataServiceHelper.load((String)entityName, (String)"isillegalbid", (QFilter[])new QFilter[]{new QFilter("supplier", "in", suppliers), new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("sectionname", "=", (Object)sectionname)});
            if (tenderrecords.length > 0) {
                for (DynamicObject tenderrecord : tenderrecords) {
                    tenderrecord.set("isillegalbid", (Object)Boolean.TRUE);
                }
                SaveServiceHelper.save((DynamicObject[])tenderrecords);
            }
        }
        return exists;
    }

    public static boolean isIllegalBidInPublish(long supplierId, long bidprojectId, String ip, String entityName) {
        DynamicObjectCollection records;
        boolean exists = false;
        DynamicObjectCollection selfRecords = QueryServiceHelper.query((String)entityName, (String)"downdocip", (QFilter[])new QFilter[]{new QFilter("supplier", "=", (Object)supplierId), new QFilter("bidproject", "=", (Object)bidprojectId)});
        HashSet<String> ips = new HashSet<String>(16);
        ips.add(ip);
        if (selfRecords != null && selfRecords.size() > 0) {
            List hisIps = selfRecords.stream().map(e -> e.getString("downdocip")).collect(Collectors.toList());
            ips.addAll(hisIps);
        }
        if ((records = QueryServiceHelper.query((String)entityName, (String)"supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "!=", (Object)supplierId), new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("downdocip", "in", ips)})) != null && records.size() > 0) {
            exists = true;
        }
        if (exists) {
            List<Long> suppliers = records.stream().map(e -> e.getLong("supplier")).collect(Collectors.toList());
            IsIllegalBidUtil.setOtherSupplierIllegalBid(suppliers, bidprojectId, null, ip, PUBLISH, entityName.split("_")[0]);
            DynamicObject[] record = BusinessDataServiceHelper.load((String)entityName, (String)"supplier,isillegalbid", (QFilter[])new QFilter[]{new QFilter("supplier", "in", suppliers), new QFilter("bidproject", "=", (Object)bidprojectId)});
            if (record.length > 0) {
                for (DynamicObject tenderrecord : record) {
                    tenderrecord.set("isillegalbid", (Object)Boolean.TRUE);
                }
                SaveServiceHelper.save((DynamicObject[])record);
            }
        }
        return exists;
    }

    public static boolean isIllegalBidInAnswerQuestionReco(long supplierId, long bidprojectId, String ip, String entityName, String quesTitle) {
        DynamicObject[] answerReco = BusinessDataServiceHelper.load((String)entityName, (String)"bidanswerquestiontheme,bid_answerquestions_list,proposedunit,questionip,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("bidanswerquestiontheme", "=", (Object)quesTitle), new QFilter("bid_answerquestions_list.proposedunit.id", "!=", (Object)supplierId), new QFilter("bid_answerquestions_list.questionip", "=", (Object)ip)});
        boolean exsit = false;
        if (answerReco != null && answerReco.length > 0) {
            exsit = true;
            IsIllegalBidUtil.setOtherSupplierIllegalBidInAnswer(answerReco, supplierId, ip);
        }
        return exsit;
    }

    public static boolean isIllegalBidInClafity(long bidProjectId, long supplierId, String clarifyTheme, String entityName, String ip) {
        boolean exsit = false;
        DynamicObject[] clafitys = BusinessDataServiceHelper.load((String)entityName, (String)"bidsection,supplierentry,clarifysupplier,isillegalbid,ip", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId), new QFilter("clarifytheme", "=", (Object)clarifyTheme), new QFilter("bidsection.supplierentry.clarifysupplier.id", "!=", (Object)supplierId), new QFilter("bidsection.supplierentry.ip", "=", (Object)ip), new QFilter("billstatus", "!=", (Object)"INVALID").or(new QFilter("billstatus", "!=", (Object)"INVALIDXX"))});
        if (clafitys != null && clafitys.length > 0) {
            exsit = true;
            IsIllegalBidUtil.setOtherSupplierIllegalBidInClifity(clafitys, supplierId, ip);
        }
        return exsit;
    }

    protected static void setOtherSupplierIllegalBid(List<Long> supplierIds, long bidprojectId, String sectionname, String ip, String source, String appId) {
        switch (source) {
            case "open": {
                DynamicObject bidOpen = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidopen"), (String)"bidsection,sectionname,supplierentry,supplier,supplier_ip,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("billstatus", "!=", (Object)"XX")});
                if (bidOpen == null) {
                    return;
                }
                IsIllegalBidUtil.setOtherSupplierIllegalBidInOpenAndPublish(bidOpen, supplierIds, sectionname, ip, "supplier_ip");
                break;
            }
            case "publish": {
                DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(appId + "_bidpublish"), (String)"bidsection,sectionname,supplierentry,supplier,downdocip,isillegalbid", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidprojectId), new QFilter("billstatus", "!=", (Object)"XX")});
                if (bidPublish == null) {
                    return;
                }
                IsIllegalBidUtil.setOtherSupplierIllegalBidInOpenAndPublish(bidPublish, supplierIds, sectionname, ip, "downdocip");
                break;
            }
        }
    }

    protected static void setOtherSupplierIllegalBidInOpenAndPublish(DynamicObject dataEntity, List<Long> supplierId, String sectionname, String ip, String ipName) {
        DynamicObjectCollection bidsection = dataEntity.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : bidsection) {
            String sectionName = section.getString("sectionname");
            if (sectionname != null && !StringUtils.equals((CharSequence)sectionName, (CharSequence)sectionname)) continue;
            DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierRow : supplierentry) {
                DynamicObject supplier = supplierRow.getDynamicObject("supplier");
                String qip = supplierRow.getString(ipName);
                if (supplier == null || !supplierId.contains((Long)supplier.getPkValue()) || !StringUtils.equals((CharSequence)qip, (CharSequence)ip)) continue;
                supplierRow.set("isillegalbid", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    protected static void setOtherSupplierIllegalBidInAnswer(DynamicObject[] answerReco, long supplierId, String ip) {
        for (DynamicObject answer : answerReco) {
            DynamicObjectCollection entry = answer.getDynamicObjectCollection("bid_answerquestions_list");
            for (DynamicObject row : entry) {
                DynamicObject proposedunit = row.getDynamicObject("proposedunit");
                if (proposedunit == null) continue;
                String qip = row.getString("questionip");
                if (supplierId == (Long)proposedunit.getPkValue() || !StringUtils.equals((CharSequence)ip, (CharSequence)qip)) continue;
                row.set("isillegalbid", (Object)Boolean.TRUE);
            }
        }
        SaveServiceHelper.save((DynamicObject[])answerReco);
    }

    protected static void setOtherSupplierIllegalBidInClifity(DynamicObject[] clafitys, long supplierId, String ip) {
        for (DynamicObject clafity : clafitys) {
            DynamicObjectCollection bidsection = clafity.getDynamicObjectCollection("bidsection");
            for (DynamicObject section : bidsection) {
                DynamicObjectCollection supplierentry = section.getDynamicObjectCollection("supplierentry");
                for (DynamicObject row : supplierentry) {
                    DynamicObject clarifysupplier = row.getDynamicObject("clarifysupplier");
                    String qip = row.getString("ip");
                    if (clarifysupplier == null || supplierId == (Long)clarifysupplier.getPkValue() || !StringUtils.equals((CharSequence)ip, (CharSequence)qip)) continue;
                    row.set("isillegalbid", (Object)Boolean.TRUE);
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])clafitys);
    }

    public static String getLoginIp() {
        String loginIP = RequestContext.get().getLoginIP();
        if (loginIP == null || loginIP.isEmpty()) {
            return null;
        }
        if (loginIP.contains(",")) {
            loginIP = loginIP.split(",")[0];
        }
        return loginIP;
    }
}

