/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.enums.BidBackTypeEnum;
import kd.scm.bid.common.enums.BidTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.AttachmentUtil;
import kd.scm.ten.common.util.CommonUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;

public class OnlineBidUtil {
    public static synchronized Object createOnlineBid(String tenAppId, DynamicObject onlineBidHistory) {
        DynamicObject onlineBidHistoryData = BusinessDataServiceHelper.loadSingle((Object)onlineBidHistory.getPkValue(), (String)(tenAppId + "_online_bid"));
        if (onlineBidHistoryData != null) {
            List unDealSectionNameList;
            DynamicObject onlineBidDetailData;
            String bidAppId = AppIdUtil.getBidAppId((String)tenAppId);
            Boolean isEnableList = Boolean.FALSE;
            if ("resp".equals(tenAppId)) {
                Object bidProjectId = onlineBidHistoryData.getDynamicObject("bidproject").getPkValue();
                DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)(bidAppId + "_project"), (String)"isenablelist");
                isEnableList = bidProject.getBoolean("isenablelist");
            }
            MainEntityType onlineBidEntityType = EntityMetadataCache.getDataEntityType((String)(tenAppId + "_online_bid"));
            DynamicObject onlineBidData = new DynamicObject((DynamicObjectType)onlineBidEntityType);
            Long onlineBidId = ID.genLongId();
            DynamicObjectUtils.copy((DynamicObject)onlineBidHistoryData, (DynamicObject)onlineBidData);
            onlineBidData.set("id", (Object)onlineBidId);
            onlineBidData.set("billstatus", (Object)"A");
            onlineBidData.set("creator", (Object)RequestContext.get().getCurrUserId());
            onlineBidData.set("createtime", (Object)new Date());
            onlineBidData.set("creator", (Object)RequestContext.get().getCurrUserId());
            onlineBidData.set("auditor", null);
            onlineBidData.set("auditdate", null);
            onlineBidData.set("modifier", null);
            onlineBidData.set("modifytime", null);
            onlineBidData.set("sourcebillid", onlineBidHistoryData.getPkValue());
            int currentRounds = onlineBidHistoryData.getInt("rounds") + 1;
            onlineBidData.set("rounds", (Object)currentRounds);
            onlineBidData.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u6b21", (String)"OnlineBidUtil_0", (String)"scm-ten-formplugin", (Object[])new Object[0]), CommonUtil.toChinese((String)(currentRounds + ""))));
            DynamicObject bidProject = onlineBidHistoryData.getDynamicObject("bidproject");
            Object bidProjectId = bidProject.getPkValue();
            DynamicObject bidPublish = BusinessDataServiceHelper.loadSingle((String)(AppIdUtil.getBidAppId((String)tenAppId) + "_bidpublish"), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("billstatus", "not in", (Object)new String[]{"X", "J"})});
            if (bidPublish != null) {
                onlineBidData.set("bidpublishid", bidPublish.getPkValue());
            }
            List<Object> pkSet = SupplierUtil.getSupplierPkArray();
            if ("resp".equals(tenAppId)) {
                DynamicObject currentSupplier = SupplierUtil.getRESMSupplier();
                pkSet.add(currentSupplier.getPkValue());
            }
            DynamicObject myTender = BusinessDataServiceHelper.loadSingle((String)(tenAppId + "_mytender"), (String)"supplier,backbidway,backbidtype,node,entry,projectsection,sectionname,sectionstatus,fromrebackflag", (QFilter[])new QFilter[]{new QFilter("supplier", "in", pkSet), new QFilter("bidproject", "=", bidProjectId)});
            onlineBidData.set("backbidway", myTender.get("backbidway"));
            onlineBidData.set("backbidtype", myTender.get("backbidtype"));
            onlineBidData.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
            onlineBidData.set("node", (Object)myTender.getString("node"));
            onlineBidData.set("biddate", null);
            String backBidType = myTender.getString("backbidtype");
            if (isEnableList.booleanValue()) {
                if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
                    BidFileHelper.copyFileFromAToB((String)(tenAppId + "_online_bid"), (Object)onlineBidHistoryData.getPkValue(), (String)"inviteattachment", (String)(tenAppId + "_online_bid"), (Object)onlineBidData.getPkValue(), (String)"inviteattachment");
                }
            } else {
                BidFileHelper.copyFileFromAToB((String)(tenAppId + "_online_bid"), (Object)onlineBidHistoryData.getPkValue(), (String)"inviteattachment", (String)(tenAppId + "_online_bid"), (Object)onlineBidData.getPkValue(), (String)"inviteattachment");
            }
            StringBuilder sectionNameSb = new StringBuilder();
            DynamicObjectCollection tenderEntryCol = myTender.getDynamicObjectCollection("entry");
            ArrayList<Object> toTenderSectionNameList = new ArrayList<Object>();
            ArrayList<Object> fromBackSectionNameList = new ArrayList<Object>();
            for (DynamicObject tenderEntry : tenderEntryCol) {
                String sectionName = tenderEntry.getString("sectionname");
                String sectionStatus = tenderEntry.getString("sectionstatus");
                if (!MyTenderStatus.PRETENDERED.getValue().equals(sectionStatus)) continue;
                toTenderSectionNameList.add(sectionName);
                String value = (String)sectionName + ";";
                sectionNameSb.append(value);
                boolean fromrebackflag = tenderEntry.getBoolean("fromrebackflag");
                if (!fromrebackflag) continue;
                fromBackSectionNameList.add(sectionName);
            }
            if (sectionNameSb.length() > 0) {
                onlineBidData.set("sectionnamelist", (Object)sectionNameSb.toString());
            }
            DynamicObjectCollection sectionEntryCol = onlineBidData.getDynamicObjectCollection("sectionentry");
            HashMap<String, String> sectionStatusMap = new HashMap<String, String>();
            for (DynamicObject sectionEntry : sectionEntryCol) {
                String sectionName = sectionEntry.getString("sectionname");
                String sectionStatus = sectionEntry.getString("sectionstatus");
                if (toTenderSectionNameList.contains(sectionName)) {
                    sectionEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                    sectionEntry.set("currentroundflag", (Object)Boolean.TRUE);
                    sectionStatusMap.put(sectionName, MyTenderStatus.PRETENDERED.getValue());
                    if (fromBackSectionNameList.contains(sectionName)) {
                        sectionEntry.set("fromrebackflag", (Object)Boolean.TRUE);
                        continue;
                    }
                    sectionEntry.set("fromrebackflag", (Object)Boolean.FALSE);
                    continue;
                }
                sectionEntry.set("currentroundflag", (Object)Boolean.FALSE);
                sectionStatusMap.put(sectionName, sectionStatus);
            }
            ArrayList<DynamicObject> subOnlineBidDetailList = new ArrayList<DynamicObject>();
            String onlineBidDetailFormId = tenAppId + "_online_bid_detail";
            DynamicObject[] subTempOnlineTenderArray = BusinessDataServiceHelper.load((String)onlineBidDetailFormId, (String)"id", (QFilter[])new QFilter[]{new QFilter("onlinebidid", "=", onlineBidHistoryData.getPkValue())});
            List<DynamicObject> clarifyQuestionHistoryList = OnlineBidUtil.getLastClarifyQuestion(bidProject, onlineBidData.getDynamicObject("supplier").getPkValue());
            ArrayList<String> dealSectionNameList = new ArrayList<String>();
            MainEntityType onlineBidDetailEntityType = EntityMetadataCache.getDataEntityType((String)onlineBidDetailFormId);
            DynamicObjectType onlineBidDetailType = new DynamicObject((DynamicObjectType)onlineBidDetailEntityType).getDynamicObjectType();
            if (subTempOnlineTenderArray != null && subTempOnlineTenderArray.length > 0) {
                Object[] subTempOnlineBidDetailArray = new Object[subTempOnlineTenderArray.length];
                for (int i = 0; i < subTempOnlineTenderArray.length; ++i) {
                    subTempOnlineBidDetailArray[i] = subTempOnlineTenderArray[i].getPkValue();
                }
                DynamicObject[] subOnlineTenderArray = BusinessDataServiceHelper.load((Object[])subTempOnlineBidDetailArray, (DynamicObjectType)onlineBidDetailType);
                for (int i = 0; i < subOnlineTenderArray.length; ++i) {
                    DynamicObjectCollection listentry;
                    DynamicObject subOnlineTender = subOnlineTenderArray[i];
                    String sectionName = subOnlineTender.getString("sectionname");
                    Long onlineBidDetailId = ID.genLongId();
                    onlineBidDetailData = new DynamicObject((DynamicObjectType)onlineBidDetailEntityType);
                    DynamicObjectUtils.copy((DynamicObject)subOnlineTender, (DynamicObject)onlineBidDetailData);
                    onlineBidDetailData.set("id", (Object)onlineBidDetailId);
                    onlineBidDetailData.set("onlinebidid", (Object)onlineBidId);
                    if (toTenderSectionNameList.contains(sectionName)) {
                        onlineBidDetailData.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                    }
                    onlineBidDetailData.set("sectionstatus", sectionStatusMap.get(subOnlineTender.getString("sectionname")));
                    onlineBidDetailData.set("backbidway", myTender.get("backbidway"));
                    onlineBidDetailData.set("backbidtype", myTender.get("backbidtype"));
                    Boolean exitFlag = OnlineBidUtil.copyByClarifyQuestionHistoryBill(clarifyQuestionHistoryList, onlineBidDetailData, bidProject, isEnableList, backBidType);
                    if (!exitFlag.booleanValue() && !isEnableList.booleanValue()) {
                        BidFileHelper.copyFileFromAToB((String)onlineBidDetailFormId, (Object)subOnlineTender.getPkValue(), (String)"techattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailId, (String)"techattachment");
                        BidFileHelper.copyFileFromAToB((String)onlineBidDetailFormId, (Object)subOnlineTender.getPkValue(), (String)"busattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailId, (String)"busattachment");
                        BidFileHelper.copyFileFromAToB((String)onlineBidDetailFormId, (Object)subOnlineTender.getPkValue(), (String)"otherattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailId, (String)"otherattachment");
                    }
                    if (fromBackSectionNameList.contains(subOnlineTender.getString("sectionname"))) {
                        Object supplierId = myTender.getDynamicObject("supplier").getPkValue();
                        OnlineBidUtil.copyDescAndAttachFromReBackBid(sectionName, myTender.getString("backbidtype"), supplierId, bidProjectId, onlineBidDetailData);
                    }
                    if (isEnableList.booleanValue()) {
                        onlineBidDetailData.set("tenderprice", null);
                        onlineBidDetailData.set("pricevat", null);
                        onlineBidDetailData.set("tax", null);
                        onlineBidDetailData.set("notaxtenderprice", null);
                        onlineBidDetailData.set("rate", null);
                        DynamicObjectCollection listEntryCOl = onlineBidDetailData.getDynamicObjectCollection("listentry");
                        listEntryCOl.clear();
                        DynamicObjectCollection supplierDetailCol = onlineBidDetailData.getDynamicObjectCollection("supplierdetail");
                        for (DynamicObject supplierDetail : supplierDetailCol) {
                            supplierDetail.set("inclutaxprice", null);
                            supplierDetail.set("inclutaxamount", null);
                            supplierDetail.set("bd_taxrate", null);
                            supplierDetail.set("taxamount", null);
                            supplierDetail.set("excepttaxamount", null);
                            supplierDetail.set("costrate", null);
                        }
                        if (!exitFlag.booleanValue() && BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
                            BidFileHelper.copyFileFromAToB((String)onlineBidDetailFormId, (Object)subOnlineTender.getPkValue(), (String)"techattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailId, (String)"techattachment");
                        }
                    }
                    subOnlineBidDetailList.add(onlineBidDetailData);
                    dealSectionNameList.add(sectionName);
                    if (!"resp".equals(tenAppId) || (listentry = onlineBidDetailData.getDynamicObjectCollection("listentry")) == null || listentry.isEmpty()) continue;
                    ((DynamicObject)listentry.get(0)).set("isnewupload", (Object)Boolean.FALSE);
                }
            }
            if (toTenderSectionNameList != null && toTenderSectionNameList.size() > 0 && (unDealSectionNameList = toTenderSectionNameList.stream().filter(t -> dealSectionNameList != null && !dealSectionNameList.contains(t)).collect(Collectors.toList())) != null && unDealSectionNameList.size() > 0) {
                bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(AppIdUtil.getBidAppId((String)tenAppId) + "_project"));
                String bidType = bidProject.getString("bidtype");
                DynamicObjectCollection projectSectionCol = bidProject.getDynamicObjectCollection("bidsection");
                for (DynamicObject projectSection : projectSectionCol) {
                    String sectionName = projectSection.getString("sectionname");
                    if (!unDealSectionNameList.contains(sectionName)) continue;
                    onlineBidDetailData = new DynamicObject((DynamicObjectType)onlineBidDetailEntityType);
                    onlineBidDetailData.set("id", (Object)ID.genLongId());
                    onlineBidDetailData.set("onlinebidid", (Object)onlineBidId);
                    onlineBidDetailData.set("mytenderid", myTender.getPkValue());
                    onlineBidDetailData.set("bidproject", bidProject.getPkValue());
                    onlineBidDetailData.set("billstatus", (Object)BillStatusEnum.SAVE.getVal());
                    onlineBidDetailData.set("projectsectionid", projectSection.getPkValue());
                    onlineBidDetailData.set("sectionname", (Object)sectionName);
                    onlineBidDetailData.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED.getValue());
                    onlineBidDetailData.set("backbidway", myTender.get("backbidway"));
                    onlineBidDetailData.set("backbidtype", myTender.get("backbidtype"));
                    onlineBidDetailData.set("workday", projectSection.get("workload"));
                    onlineBidData.set("creator", (Object)RequestContext.get().getCurrUserId());
                    DynamicObjectCollection supplierDetailCol = onlineBidDetailData.getDynamicObjectCollection("supplierdetail");
                    DynamicObjectCollection projectEntryCol = projectSection.getDynamicObjectCollection("projectentry");
                    for (DynamicObject projectEntry : projectEntryCol) {
                        DynamicObject supplierDetail;
                        supplierDetail = supplierDetailCol.addNew();
                        supplierDetail.set("purentrycontent", projectEntry.get("purentrycontent"));
                        supplierDetail.set("materialid", projectEntry.get("materialid"));
                        supplierDetail.set("baseunit", projectEntry.get("baseunit"));
                        supplierDetail.set("purentryproject", projectEntry.get("purentryproject"));
                        supplierDetail.set("materialdes", projectEntry.get("materialdes"));
                        supplierDetail.set("qty", projectEntry.get("qty"));
                        if (!BidTypeEnum.RESOURCE.getValue().equals(bidType)) continue;
                        supplierDetail.set("resourceitem", projectEntry.get("resourceitem"));
                    }
                    subOnlineBidDetailList.add(onlineBidDetailData);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{onlineBidData});
            if (subOnlineBidDetailList != null && subOnlineBidDetailList.size() > 0) {
                DynamicObject[] subOnlineBidDetailArray = new DynamicObject[subOnlineBidDetailList.size()];
                subOnlineBidDetailList.toArray(subOnlineBidDetailArray);
                SaveServiceHelper.save((DynamicObject[])subOnlineBidDetailArray);
            }
            if (clarifyQuestionHistoryList != null && clarifyQuestionHistoryList.size() > 0) {
                for (DynamicObject clarifyQuestionHistory : clarifyQuestionHistoryList) {
                    clarifyQuestionHistory.set("is_again_bidding", (Object)2);
                }
                DynamicObject[] clarifyQuestionHistoryArray = new DynamicObject[clarifyQuestionHistoryList.size()];
                clarifyQuestionHistoryList.toArray(clarifyQuestionHistoryArray);
                SaveServiceHelper.update((DynamicObject[])clarifyQuestionHistoryArray);
            }
            return onlineBidId;
        }
        return null;
    }

    protected static void copyDescAndAttachFromReBackBid(String sectionName, String backBidType, Object supplierId, Object bidProjectId, DynamicObject dataEntity) {
        String publicdescription;
        String appId = dataEntity.getDynamicObjectType().getName().split("_")[0];
        String bidAppId = "ten".equalsIgnoreCase(appId) ? "bid" : "rebm";
        DynamicObject[] reBackBids = BusinessDataServiceHelper.load((String)(bidAppId + "_rebackbid"), (String)"publicdescription,bidsection,sectionname,supplierentry,supplier,description,rebackbidflag,attachment", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProjectId), new QFilter("type", "=", (Object)("TECHANDBUSS".equals(backBidType) ? "MULTI" : backBidType)), new QFilter("billstatus", "=", (Object)"C")}, (String)"auditdate desc");
        if (reBackBids.length == 0) {
            return;
        }
        DynamicObject rebackBid = reBackBids[0];
        DynamicObjectCollection bidsection = rebackBid.getDynamicObjectCollection("bidsection");
        Optional<DynamicObject> sectionEntry = bidsection.stream().filter(section -> section.getString("sectionname").equals(sectionName)).findFirst();
        if (!sectionEntry.isPresent()) {
            return;
        }
        DynamicObjectCollection supplierentry = sectionEntry.get().getDynamicObjectCollection("supplierentry");
        Optional<DynamicObject> supEntry = supplierentry.stream().filter(entry -> entry.getBoolean("rebackbidflag")).filter(entry -> String.valueOf(entry.getDynamicObject("supplier").getPkValue()).equals(String.valueOf(supplierId))).findFirst();
        if (!supEntry.isPresent()) {
            return;
        }
        DynamicObject entry2 = supEntry.get();
        StringBuilder description = new StringBuilder();
        String privateDesc = entry2.getString("description");
        if (privateDesc != null && !privateDesc.isEmpty()) {
            description.append(OnlineBidUtil.getPrivateDesc());
            description.append(privateDesc);
            description.append('\n');
        }
        if ((publicdescription = rebackBid.getString("publicdescription")) != null && !publicdescription.isEmpty()) {
            description.append(OnlineBidUtil.getpublicdescription());
            description.append(publicdescription);
        }
        dataEntity.set("rebackbiddesc", (Object)description.toString());
        DynamicObjectCollection attachments = entry2.getDynamicObjectCollection("attachment");
        HashSet<Object> attachIdSet = new HashSet<Object>(16);
        if (attachments.size() > 0) {
            for (DynamicObject attachment : attachments) {
                DynamicObject data = attachment.getDynamicObject("fbasedataid");
                Object attachId = data.getPkValue();
                attachIdSet.add(attachId);
            }
        }
        AttachmentUtil.copyAttachFieldToAttachPanelByAttachId(attachIdSet, (String)dataEntity.getDataEntityType().getName(), (Object)dataEntity.get("id"), (String)"rebackbidattach");
        BidFileHelper.copyFileFromAToB((String)(bidAppId + "_rebackbid"), (Object)rebackBid.getPkValue(), (String)"pubattachmentpanel", (String)dataEntity.getDataEntityType().getName(), (Object)dataEntity.getPkValue(), (String)"rebackbidattach");
    }

    public static String getpublicdescription() {
        return ResManager.loadKDString((String)"\u516c\u5171\u8bf4\u660e\uff1a", (String)"OnlineBidUtil_1", (String)"scm-ten-formplugin", (Object[])new Object[0]);
    }

    public static String getPrivateDesc() {
        return ResManager.loadKDString((String)"\u4e13\u5c5e\u8bf4\u660e\uff1a", (String)"OnlineBidUtil_2", (String)"scm-ten-formplugin", (Object[])new Object[0]);
    }

    public static List<DynamicObject> getLastClarifyQuestion(DynamicObject project, Object supplierId) {
        Long projectId = project.getLong("id");
        QFilter bidProjectFilter = new QFilter("bidproject", "=", (Object)projectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        QFilter reTenderFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"CLARIFIED");
        QFilter isBidDingFilter = new QFilter("is_again_bidding", "!=", (Object)"2");
        DynamicObject[] clarifyQuestionColl = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id,is_again_bidding,createtime,clarifysupplier,clarifytype", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, reTenderFilter, statusFilter, isBidDingFilter}, (String)"createtime desc");
        List<Object> clarifyQuestionList = new ArrayList<DynamicObject>();
        HashMap<String, DynamicObject> sectionNameMap = new HashMap<String, DynamicObject>();
        for (DynamicObject clarifyQuestion : clarifyQuestionColl) {
            String key;
            String clarifySupplier = clarifyQuestion.getString("clarifysupplier");
            String[] values = clarifySupplier.split("&&");
            String clarifySectionName = "";
            String clarifyType = clarifyQuestion.getString("clarifytype");
            if (values.length == 3) {
                clarifySectionName = values[2];
            }
            if (sectionNameMap.containsKey(key = clarifySectionName + clarifyType)) continue;
            sectionNameMap.put(key, clarifyQuestion);
        }
        if (sectionNameMap.size() > 0) {
            clarifyQuestionList = sectionNameMap.values().stream().sorted(Comparator.comparingLong(c -> ((DynamicObject)c).getDate("createtime").getTime()).reversed()).collect(Collectors.toList());
        }
        return clarifyQuestionList;
    }

    public static Boolean copyByClarifyQuestionHistoryBill(List<DynamicObject> clarifyQuestionHisList, DynamicObject onlineBidDetailData, DynamicObject bidProject, Boolean isEnableList, String backBidType) {
        Boolean flag = Boolean.FALSE;
        if (clarifyQuestionHisList == null) {
            return flag;
        }
        Boolean enableMultiSection = bidProject.getBoolean("enablemultisection");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        String sectionName = onlineBidDetailData.getString("sectionname");
        for (DynamicObject clarifyQuestionHistory : clarifyQuestionHisList) {
            String clarifySectionName;
            Object clarifyQuestionHisId = clarifyQuestionHistory.get("id");
            clarifyQuestionHistory = BusinessDataServiceHelper.loadSingle((Object)clarifyQuestionHisId, (String)(appId + "_questionclarify"));
            DynamicObjectCollection sectionColl = clarifyQuestionHistory.getDynamicObjectCollection("bidsection");
            if (enableMultiSection.booleanValue() && !StringUtils.equals((CharSequence)sectionName, (CharSequence)(clarifySectionName = ((DynamicObject)sectionColl.get(0)).getString("sectionname")))) continue;
            String clarifyFormIde = appId + "_questionclarify";
            String onlineBidDetailFormId = AppIdUtil.getTenAppId((String)appId) + "_online_bid_detail";
            if (!isEnableList.booleanValue()) {
                BidFileHelper.copyFileFromAToB((String)clarifyFormIde, (Object)clarifyQuestionHisId, (String)"techattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailData.getPkValue(), (String)"techattachment");
                BidFileHelper.copyFileFromAToB((String)clarifyFormIde, (Object)clarifyQuestionHisId, (String)"otherattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailData.getPkValue(), (String)"otherattachment");
                BidFileHelper.copyFileFromAToB((String)clarifyFormIde, (Object)clarifyQuestionHisId, (String)"commercattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailData.getPkValue(), (String)"busattachment");
            } else if (BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
                BidFileHelper.copyFileFromAToB((String)clarifyFormIde, (Object)clarifyQuestionHisId, (String)"techattachment", (String)onlineBidDetailFormId, (Object)onlineBidDetailData.getPkValue(), (String)"techattachment");
            }
            String clarifyType = clarifyQuestionHistory.getString("clarifytype");
            if (!"TECHNICAL".equals(clarifyType)) {
                onlineBidDetailData.set("tenderprice", clarifyQuestionHistory.get("tenderprice"));
                onlineBidDetailData.set("notaxtenderprice", clarifyQuestionHistory.get("notaxtenderprice"));
                onlineBidDetailData.set("pricevat", (Object)clarifyQuestionHistory.getBigDecimal("pricevat"));
                onlineBidDetailData.set("tax", clarifyQuestionHistory.get("tax"));
                onlineBidDetailData.set("projectmanage", clarifyQuestionHistory.get("projectmanage"));
                onlineBidDetailData.set("workday", clarifyQuestionHistory.get("workday"));
                onlineBidDetailData.set("rate", (Object)clarifyQuestionHistory.getBigDecimal("rate"));
                DynamicObjectCollection supplierDetailColl = onlineBidDetailData.getDynamicObjectCollection("supplierdetail");
                DynamicObjectCollection supplierDetailHistoryColl = ((DynamicObject)sectionColl.get(0)).getDynamicObjectCollection("supplierdetail");
                for (int j = 0; j < supplierDetailColl.size(); ++j) {
                    ((DynamicObject)supplierDetailColl.get(j)).set("inclutaxprice", ((DynamicObject)supplierDetailHistoryColl.get(j)).get("inclutaxprice"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("inclutaxamount", ((DynamicObject)supplierDetailHistoryColl.get(j)).get("inclutaxamount"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("bd_taxrate", ((DynamicObject)supplierDetailHistoryColl.get(j)).get("bd_taxrate"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("taxrate", (Object)((DynamicObject)supplierDetailHistoryColl.get(j)).getBigDecimal("taxrate"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("taxamount", ((DynamicObject)supplierDetailHistoryColl.get(j)).get("taxamount"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("excepttaxamount", ((DynamicObject)supplierDetailHistoryColl.get(j)).get("excepttaxamount"));
                    ((DynamicObject)supplierDetailColl.get(j)).set("costrate", (Object)((DynamicObject)supplierDetailHistoryColl.get(j)).getBigDecimal("costrate"));
                }
            }
            clarifyQuestionHistory.set("is_again_bidding", (Object)2);
            flag = Boolean.TRUE;
        }
        if (clarifyQuestionHisList != null && clarifyQuestionHisList.size() > 0) {
            DynamicObject[] clarifyQuestionArray = new DynamicObject[clarifyQuestionHisList.size()];
            SaveServiceHelper.update((DynamicObject[])clarifyQuestionHisList.toArray(clarifyQuestionArray));
        }
        return flag;
    }

    protected DynamicObject getFileRecordBus(Object supplierId, Object sectionId, String appId, String type, String selectFields) {
        QFilter qFilter1 = new QFilter("supplierid", "=", supplierId);
        QFilter qFilter2 = new QFilter("sectionid", "=", sectionId);
        QFilter qFilter3 = new QFilter("type", "=", (Object)type);
        return QueryServiceHelper.queryOne((String)(appId + "_bustalk_file"), (String)selectFields, (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
    }
}

