/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ResmSupplierBlackUtil {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
    private static final String acctId = CacheKeyUtil.getAcctId() + "_";

    public static List<Object> getBlackSupplierIdList() {
        String[] supplierIdArr = cache.getSetValues(acctId + "resm_black");
        return Arrays.stream(supplierIdArr).map(id -> Long.parseLong(id)).collect(Collectors.toList());
    }

    public static List<Object> getOrgBlackSupplierIdList(Object orgId) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> supplierIdList = ResmSupplierBlackUtil.getBlackSupplierIdList();
        for (Object supplierId : supplierIdList) {
            List<Object> orgList = ResmSupplierBlackUtil.getBlackOrgList(supplierId);
            if (CollectionUtils.isEmpty(orgList) || !orgList.contains(orgId)) continue;
            result.add(supplierId);
        }
        return result;
    }

    public static List<Object> getBlackOrgList(Object supplierId) {
        String[] orgIdArr = cache.getSetValues(acctId + supplierId.toString());
        return Arrays.stream(orgIdArr).map(orgId -> Long.parseLong(orgId)).collect(Collectors.toList());
    }

    public static List<Object> getFrozenGroups(Object supplierId, Object orgId) {
        DynamicObject[] frozenRangs;
        ArrayList<Object> result = new ArrayList<Object>();
        for (DynamicObject frozenRang : frozenRangs = BusinessDataServiceHelper.load((String)"resm_frozen_info", (String)"group", (QFilter[])new QFilter[]{new QFilter("supplier", "=", supplierId), new QFilter("frozen_org", "=", orgId), new QFilter("status", "=", (Object)Character.valueOf('0'))})) {
            DynamicObject group = frozenRang.getDynamicObject("group");
            if (group == null) continue;
            result.add(group.getPkValue());
        }
        return result;
    }

    public static List<Object> getUnqualifiredGroups(Object supplierId, Object orgId) {
        DynamicObject[] unqualifiredRangs;
        ArrayList<Object> result = new ArrayList<Object>();
        for (DynamicObject unqualifiredRang : unqualifiredRangs = BusinessDataServiceHelper.load((String)"resm_unqualifired_info", (String)"group", (QFilter[])new QFilter[]{new QFilter("supplier", "=", supplierId), new QFilter("unqualifired_org", "=", orgId), new QFilter("status", "=", (Object)Character.valueOf('0'))})) {
            DynamicObject group = unqualifiredRang.getDynamicObject("group");
            if (group == null) continue;
            result.add(group.getPkValue());
        }
        return result;
    }
}

