/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.common.constant.TenFormTypeConstants;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;
import kd.scm.ten.formplugin.util.SupplierUtil;
import kd.scm.ten.formplugin.util.TenderRecordUtil;

public class RevokeBidUtil {
    private static final String REVOKEBIDNUMBER = "revokebidnumber";

    public String selectString() {
        return "id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.supplier_istender,supplierentry.supplier_tenderdate,supplierentry.supplier_manager,supplierentry.supplier_pricevat,supplierentry.supplier_tenderprice,supplierentry.supplier_exceptvat,supplierentry.supplier_rate,supplierentry.supplier_illustration,supplierentry.supplier_isfrombackbid,supplierentry.supplier_workday,supplierentry.supplier_ip,supplierentry.supplier_taxrate,supplierentry.supplier_revokebidnumber,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.qty,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate,entitytypeid,tender,isillegalbid,tenderrecord";
    }

    public void saveUnSubmitBidOpenData(DynamicObject data, DynamicObject bidopen, DynamicObject supplier, int index) {
        boolean isResp = false;
        HashSet<Object> supplierIdSet = new HashSet<Object>(16);
        String entitytypeid = bidopen.getString("entitytypeid");
        if (entitytypeid != null && entitytypeid.equals("rebm_bidopen")) {
            isResp = true;
            supplierIdSet.add(supplier.getPkValue());
        } else {
            DynamicObject[] supplierByUser;
            for (DynamicObject tempSupplier : supplierByUser = SupplierUtil.getSupplierByUser()) {
                supplierIdSet.add(tempSupplier.getPkValue());
            }
        }
        List<Map<String, String>> list = this.getIdAndName(data);
        QFilter filter1 = new QFilter("mytender.id", "=", data.getPkValue());
        QFilter filter2 = new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal());
        DynamicObject bidding = null;
        bidding = isResp ? BusinessDataServiceHelper.loadSingleFromCache((String)"resp_bidding", (String)"revokebidnumber,billstatus", (QFilter[])new QFilter[]{filter1, filter2}) : BusinessDataServiceHelper.loadSingleFromCache((String)"ten_bidding", (String)"revokebidnumber,billstatus", (QFilter[])new QFilter[]{filter1, filter2});
        DynamicObjectCollection bidsectioncoll = bidopen.getDynamicObjectCollection("bidsection");
        String ip = IsIllegalBidUtil.getLoginIp();
        for (int i = 0; i < bidsectioncoll.size(); ++i) {
            DynamicObject bidsection = (DynamicObject)bidsectioncoll.get(i);
            DynamicObjectCollection suppliereEntryColl = bidsection.getDynamicObjectCollection("supplierentry");
            for (int j = 0; j < suppliereEntryColl.size(); ++j) {
                DynamicObject supplierentry = (DynamicObject)suppliereEntryColl.get(j);
                DynamicObject supplier1 = (DynamicObject)supplierentry.get("supplier");
                if (!supplierIdSet.contains(supplier1.getPkValue())) continue;
                for (int k = 0; k < list.size(); ++k) {
                    Map<String, String> map = list.get(k);
                    if (!map.get("name").equals(bidsection.get("sectionname").toString())) continue;
                    supplierentry.set("supplier_istender", (Object)Boolean.FALSE);
                    if (bidding != null) {
                        if (index == 0) {
                            supplierentry.set("supplier_revokebidnumber", (Object)(bidding.getInt(REVOKEBIDNUMBER) + 1));
                        } else {
                            supplierentry.set("supplier_revokebidnumber", (Object)bidding.getInt(REVOKEBIDNUMBER));
                        }
                    }
                    supplierentry.set("supplier_tenderdate", null);
                    supplierentry.set("supplier_isfrombackbid", (Object)Boolean.TRUE);
                    supplierentry.set("supplier_manager", null);
                    supplierentry.set("supplier_tenderprice", null);
                    supplierentry.set("supplier_taxrate", null);
                    supplierentry.set("supplier_rate", null);
                    supplierentry.set("supplier_illustration", null);
                    supplierentry.set("supplier_workday", null);
                    supplierentry.set("supplier_ip", (Object)ip);
                    supplierentry.set("supplier_pricevat", null);
                    supplierentry.set("supplier_exceptvat", null);
                    supplierentry.set("tender", (Object)RequestContext.get().getCurrUserId());
                    DynamicObject bidproject = data.getDynamicObject("bidproject");
                    String entityName = isResp ? "rebm_tenderrecord" : "bid_tenderrecord";
                    boolean isIllegal = IsIllegalBidUtil.isIllegalBidInOpen((Long)supplier.getPkValue(), (Long)bidproject.getPkValue(), bidsection.getString("sectionname"), ip, entityName);
                    supplierentry.set("isillegalbid", (Object)isIllegal);
                }
            }
            DynamicObjectCollection supplierDetailColl = bidsection.getDynamicObjectCollection("supplierdetail");
            for (DynamicObject bidOpendDetail : supplierDetailColl) {
                DynamicObject purSupplier = bidOpendDetail.getDynamicObject("pursupplier");
                if (purSupplier == null || !supplierIdSet.contains(purSupplier.getPkValue())) continue;
                bidOpendDetail.set("inclutaxprice", null);
                bidOpendDetail.set("inclutaxamount", null);
                bidOpendDetail.set("taxrate", null);
                bidOpendDetail.set("taxamount", null);
                bidOpendDetail.set("excepttaxamount", null);
                bidOpendDetail.set("costrate", null);
            }
            this.removeAllFileBySupplier(supplier.getPkValue(), bidsection.getPkValue(), isResp);
        }
        if (index == 0) {
            this.revokeUpdateMyTenderStatus(data, isResp);
            if (bidding != null) {
                bidding.set(REVOKEBIDNUMBER, (Object)(bidding.getInt(REVOKEBIDNUMBER) + 1));
                bidding.set("billstatus", (Object)"A");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidding});
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidopen});
        TenderRecordUtil.createTenderRecordData(data, isResp ? "rebm" : "bid", false, list, bidopen.getPkValue());
    }

    private void revokeUpdateMyTenderStatus(DynamicObject mytender, boolean isResp) {
        String entityName = "ten_mytender";
        if (isResp) {
            entityName = "resp_mytender";
        }
        DynamicObject myTenderObject = BusinessDataServiceHelper.loadSingle((Object)mytender.getPkValue(), (String)entityName, (String)"bidproject,tenderstatus,entry,entry.projectsection,entry.sectionstatus");
        myTenderObject.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
        for (DynamicObject myTenderEntry : myTenderObject.getDynamicObjectCollection("entry")) {
            if (MyTenderStatus.UNINVITED.getValue().equals(myTenderEntry.getString("sectionstatus"))) continue;
            myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
        }
        SaveServiceHelper.update((DynamicObject)myTenderObject);
    }

    private List<Map<String, String>> getIdAndName(DynamicObject myTender) {
        DynamicObject bidProjectF7 = (DynamicObject)myTender.get("bidproject");
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()), (String)"enablemultisection");
        Boolean enablemultisection = bidProject.getBoolean("enablemultisection");
        DynamicObjectCollection entryColll = myTender.getDynamicObjectCollection("entry");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashSet<Long> set = new HashSet<Long>(16);
        for (int i = 0; i < entryColll.size(); ++i) {
            Object projectSectionId = ((DynamicObject)entryColll.get(i)).get("projectsection_id");
            set.add(Long.parseLong(projectSectionId.toString()));
        }
        QFilter filter = new QFilter("id", "in", set);
        DynamicObject[] projectsection = BusinessDataServiceHelper.load((String)TenFormTypeConstants.getFormConstant((String)"projectsection_f7", this.getClass()), (String)"sectionname", (QFilter[])new QFilter[]{filter});
        for (int i = 0; i < entryColll.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryColll.get(i);
            String projectSectionId = entry.getString("projectsection_id");
            Object sectionStatus = entry.get("sectionstatus");
            String pk = entry.getPkValue().toString();
            if (sectionStatus.equals("UNINVITED")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", pk);
            map.put("projectSectionId", projectSectionId);
            map.put("enablemultisection", enablemultisection.toString());
            for (int j = 0; j < projectsection.length; ++j) {
                String tempId = projectsection[j].getPkValue().toString();
                if (!tempId.equals(projectSectionId)) continue;
                map.put("name", projectsection[j].getString("sectionname"));
            }
            list.add(map);
        }
        return list;
    }

    public void removeAllFileBySupplier(Object supplierId, Object sectionId, boolean isResp) {
        String entityName = "bid_supplier_file";
        List<Long> array = new ArrayList<Long>();
        if (isResp) {
            entityName = "rebm_supplier_file";
            array.add(Long.parseLong(sectionId.toString()));
        } else {
            Set<String> pkSet = SupplierUtil.getSupplierPkSet();
            array = pkSet.stream().map(item -> Long.parseLong(item)).collect(Collectors.toList());
        }
        QFilter filter = new QFilter("supplierid", "in", array);
        QFilter filter1 = new QFilter("sectionid", "=", sectionId);
        QFilter filter2 = new QFilter("status", "=", (Object)"A");
        DynamicObject[] supplierFiles = BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter, filter1, filter2});
        if (supplierFiles.length > 0) {
            Object[] idArr = Arrays.stream(supplierFiles).map(DataEntityBase::getPkValue).toArray();
            DeleteServiceHelper.delete((IDataEntityType)supplierFiles[0].getDataEntityType(), (Object[])idArr);
        }
    }

    public static boolean getSystemParameter(String appNumber, Long orgId, String enable) {
        if (orgId == 0L) {
            return false;
        }
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        AppParam appParam = new AppParam(appId, "02", orgId, Long.valueOf(0L));
        Object obj = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)enable);
        if (obj != null) {
            return (Boolean)obj;
        }
        return false;
    }
}

