/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BidTypeEnum;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;

public class TenBiddingExportUtil {
    public final String[] tenHeadArray = ResManager.loadKDString((String)"id,\u62db\u6807\u5185\u5bb9,\u91c7\u8d2d\u9879\u76ee,\u542b\u7a0e\u4ef7,\u7a0e\u7387(%),\u7a0e\u989d,\u4e0d\u542b\u7a0e\u4ef7", (String)"TenBiddingExportUtil_0", (String)"scm-ten-formplugin", (Object[])new Object[0]).split(",");
    public static final String[] tenDataField = "id,purentrycontent,purentryproject,inclutaxamount,taxrate,taxamount,excepttaxamount".split(",");
    public final String[] materialpurHeadArray = ResManager.loadKDString((String)"id,\u91c7\u8d2d\u9879\u76ee,\u4ea7\u54c1\u7f16\u7801,\u4ea7\u54c1\u540d\u79f0,\u89c4\u683c\u578b\u53f7,\u8ba1\u91cf\u5355\u4f4d,\u4ea7\u54c1\u63cf\u8ff0,\u6570\u91cf,\u542b\u7a0e\u5355\u4ef7,\u542b\u7a0e\u603b\u4ef7,\u7a0e\u7387\u540d\u79f0ID,\u7a0e\u7387\u540d\u79f0Value,\u7a0e\u7387\u540d\u79f0,\u7a0e\u7387(%),\u7a0e\u989d,\u4e0d\u542b\u7a0e\u4ef7", (String)"TenBiddingExportUtil_8", (String)"scm-ten-formplugin", (Object[])new Object[0]).split(",");
    public static final String[] materialpurDataField = "id,purentryproject,materialid,name,modelnum,baseunit,materialdes,qty,inclutaxprice,inclutaxamount,bd_taxrate_id,bd_taxrate_value,bd_taxrate,taxrate,taxamount,excepttaxamount".split(",");
    public final String[] resourcepurHeadArray = ResManager.loadKDString((String)"id,\u91c7\u8d2d\u9879\u76ee,\u8d44\u6e90\u7f16\u7801,\u8d44\u6e90\u540d\u79f0,\u89c4\u683c\u578b\u53f7,\u8ba1\u91cf\u5355\u4f4d,\u4ea7\u54c1\u63cf\u8ff0,\u6570\u91cf,\u542b\u7a0e\u5355\u4ef7,\u542b\u7a0e\u603b\u4ef7,\u7a0e\u7387\u540d\u79f0ID,\u7a0e\u7387\u540d\u79f0Value,\u7a0e\u7387\u540d\u79f0,\u7a0e\u7387(%),\u7a0e\u989d,\u4e0d\u542b\u7a0e\u4ef7", (String)"TenBiddingExportUtil_9", (String)"scm-ten-formplugin", (Object[])new Object[0]).split(",");
    public static final String[] resourcepurDataField = "id,purentryproject,resourceitem,resitemname,resourcemodel,measureunit,materialdes,qty,inclutaxprice,inclutaxamount,bd_taxrate_id,bd_taxrate_value,bd_taxrate,taxrate,taxamount,excepttaxamount".split(",");
    public final String[] rateHeadArray = ResManager.loadKDString((String)"id,\u62db\u6807\u5185\u5bb9,\u91c7\u8d2d\u9879\u76ee,\u8d39\u7387(%)", (String)"TenBiddingExportUtil_10", (String)"scm-ten-formplugin", (Object[])new Object[0]).split(",");
    public static final String[] rateDataField = "id,purentrycontent,purentryproject,costrate".split(",");

    public static String exportEntry(DynamicObjectCollection collection, DynamicObject bidPeoject) {
        String fileName = String.format(ResManager.loadKDString((String)"\u62a5\u4ef7\u660e\u7ec6%s.xlsx", (String)"TenBiddingExportUtil_3", (String)"scm-ten-formplugin", (Object[])new Object[0]), System.currentTimeMillis());
        SXSSFWorkbook wb = new SXSSFWorkbook(5000);
        TenBiddingExportUtil.createRow(wb, collection, bidPeoject);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e1) {
            BizLog.log((String)e1.getMessage());
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        if (wb != null) {
            try {
                wb.close();
            }
            catch (IOException e2) {
                BizLog.log((String)e2.getMessage());
            }
        }
        return url;
    }

    protected static void createRow(SXSSFWorkbook wb, DynamicObjectCollection collection, DynamicObject bidProject) {
        Cell cell;
        String[] dataField;
        String[] headArray;
        XSSFDataFormat format = (XSSFDataFormat)wb.createDataFormat();
        SXSSFSheet sheet = wb.createSheet("sheet1");
        sheet.trackAllColumnsForAutoSizing();
        sheet.protectSheet("");
        int index = 0;
        CellStyle secondeStyle = wb.createCellStyle();
        secondeStyle.setFillForegroundColor(IndexedColors.TAN.getIndex());
        secondeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        SXSSFRow row = sheet.createRow(index);
        String bidType = bidProject.getString("bidtype");
        boolean isRateBidding = bidProject.getBoolean("isratebidding");
        TenBiddingExportUtil tenBiddingExportUtil1 = new TenBiddingExportUtil();
        if (isRateBidding) {
            if (BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                headArray = tenBiddingExportUtil1.rateHeadArray;
                dataField = rateDataField;
            } else {
                headArray = new String[]{};
                dataField = new String[]{};
            }
        } else if (BidTypeEnum.MATERIAL.getValue().equals(bidType)) {
            headArray = tenBiddingExportUtil1.materialpurHeadArray;
            dataField = materialpurDataField;
        } else if (BidTypeEnum.RESOURCE.getValue().equals(bidType)) {
            headArray = tenBiddingExportUtil1.resourcepurHeadArray;
            dataField = resourcepurDataField;
        } else {
            headArray = tenBiddingExportUtil1.tenHeadArray;
            dataField = tenDataField;
        }
        String bdTaxRateIdName = ResManager.loadKDString((String)"\u7a0e\u7387\u540d\u79f0ID", (String)"TenBiddingExportUtil_5", (String)"scm-ten-formplugin", (Object[])new Object[0]);
        String bdTaxRateValueName = ResManager.loadKDString((String)"\u7a0e\u7387\u540d\u79f0Value", (String)"TenBiddingExportUtil_6", (String)"scm-ten-formplugin", (Object[])new Object[0]);
        for (int i = 0; i < headArray.length; ++i) {
            sheet.autoSizeColumn(i);
            sheet.setColumnWidth(i, Math.min(65280, sheet.getColumnWidth(i) * 18 / 10));
            CellStyle mustFillColumnStyle = wb.createCellStyle();
            mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            mustFillColumnStyle.setFillForegroundColor(IndexedColors.TAN.getIndex());
            mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            Font mheadFont = wb.createFont();
            mheadFont.setColor(IndexedColors.BLACK1.getIndex());
            mustFillColumnStyle.setFont(mheadFont);
            cell = row.createCell(i);
            String headName = headArray[i];
            if (i == 0 || bdTaxRateIdName.equals(headName) || bdTaxRateValueName.equals(headName)) {
                sheet.setColumnHidden(i, true);
            }
            cell.setCellStyle(mustFillColumnStyle);
            cell.setCellValue(headName);
        }
        if (BidTypeEnum.MATERIAL.getValue().equals(bidType)) {
            TenBiddingExportUtil.createDataDropDownListSheet(sheet, wb, "bd_taxrate", 12);
        } else if (BidTypeEnum.RESOURCE.getValue().equals(bidType)) {
            TenBiddingExportUtil.createDataDropDownListSheet(sheet, wb, "bd_taxrate", 12);
        }
        CellStyle commonAlterableStyle = wb.createCellStyle();
        commonAlterableStyle.setLocked(true);
        CellStyle alterableStyle = wb.createCellStyle();
        alterableStyle.setLocked(true);
        CellStyle nolockedStyle = wb.createCellStyle();
        nolockedStyle.setLocked(false);
        nolockedStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"0.00"));
        int pricePrecision = 0;
        int amtPrecision = 0;
        DynamicObject currency = bidProject.getDynamicObject("currency");
        if (currency != null) {
            amtPrecision = currency.getInt("amtprecision");
            pricePrecision = currency.getInt("priceprecision");
        }
        String amtPrecisionScaleStr = TenBiddingExportUtil.getFormatScale(amtPrecision);
        String pricePrecisionScaleStr = TenBiddingExportUtil.getFormatScale(pricePrecision);
        for (int i = 0; i < collection.size(); ++i) {
            row = sheet.createRow(++index);
            DynamicObject dynamicObject = (DynamicObject)collection.get(i);
            DynamicObject material = null;
            DynamicObject resourceitem = null;
            block47: for (int j = 0; j < headArray.length; ++j) {
                cell = row.createCell(j);
                String value = "";
                String function = "";
                Double doubleValue = 0.0;
                DynamicObject bdTaxRate = null;
                switch (dataField[j]) {
                    case "id": 
                    case "purentrycontent": 
                    case "materialdes": {
                        cell.setCellStyle(commonAlterableStyle);
                        value = dynamicObject.getString(dataField[j]);
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "purentryproject": {
                        cell.setCellStyle(commonAlterableStyle);
                        DynamicObject purentryproject = dynamicObject.getDynamicObject(dataField[j]);
                        if (purentryproject != null) {
                            value = purentryproject.getLocaleString("name").getLocaleValue();
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "materialid": {
                        cell.setCellStyle(commonAlterableStyle);
                        material = dynamicObject.getDynamicObject(dataField[j]);
                        value = material.getString("number");
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "name": 
                    case "modelnum": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (material != null) {
                            value = material.getString(dataField[j]);
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "baseunit": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (material != null) {
                            value = dynamicObject.getDynamicObject(dataField[j]) != null ? dynamicObject.getDynamicObject(dataField[j]).getString("name") : "";
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "resourceitem": {
                        cell.setCellStyle(commonAlterableStyle);
                        resourceitem = dynamicObject.getDynamicObject(dataField[j]);
                        value = resourceitem.getString("number");
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "resitemname": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (resourceitem != null) {
                            value = resourceitem.getString("name");
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "resourcemodel": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (resourceitem != null) {
                            value = resourceitem.getString("model");
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "measureunit": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (resourceitem != null) {
                            value = dynamicObject.getDynamicObject("baseunit") == null ? "" : dynamicObject.getDynamicObject("baseunit").getString("name");
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "inclutaxamount": {
                        if (!BidTypeEnum.PROJECT.getValue().equals(bidType)) {
                            alterableStyle.setDataFormat(format.getFormat(amtPrecisionScaleStr));
                            cell.setCellStyle(alterableStyle);
                            function = TenBiddingExportUtil.getInclutAxamount(dataField, cell, pricePrecision, amtPrecision);
                            cell.setCellFormula(function);
                            continue block47;
                        }
                        nolockedStyle.setDataFormat(format.getFormat(amtPrecisionScaleStr));
                        cell.setCellStyle(nolockedStyle);
                        BigDecimal inclutaxamount = dynamicObject.getBigDecimal(dataField[j]);
                        if (inclutaxamount == null) {
                            inclutaxamount = BigDecimal.ZERO;
                        }
                        doubleValue = inclutaxamount.setScale(amtPrecision, 4).doubleValue();
                        cell.setCellValue(doubleValue.doubleValue());
                        continue block47;
                    }
                    case "inclutaxprice": {
                        nolockedStyle.setDataFormat(format.getFormat(pricePrecisionScaleStr));
                        cell.setCellStyle(nolockedStyle);
                        BigDecimal inclutaxprice = dynamicObject.getBigDecimal(dataField[j]);
                        if (inclutaxprice == null) {
                            inclutaxprice = BigDecimal.ZERO;
                        }
                        doubleValue = inclutaxprice.setScale(pricePrecision, 4).doubleValue();
                        cell.setCellValue(doubleValue.doubleValue());
                        continue block47;
                    }
                    case "costrate": {
                        nolockedStyle.setDataFormat(format.getFormat("0.00"));
                        cell.setCellStyle(nolockedStyle);
                        doubleValue = dynamicObject.getBigDecimal(dataField[j]).setScale(2, 4).doubleValue();
                        cell.setCellValue(doubleValue.doubleValue());
                        continue block47;
                    }
                    case "bd_taxrate_value": {
                        cell.setCellStyle(commonAlterableStyle);
                        function = TenBiddingExportUtil.getExceptValueFormula(dataField, cell);
                        cell.setCellFormula(function);
                        continue block47;
                    }
                    case "bd_taxrate_id": {
                        cell.setCellStyle(commonAlterableStyle);
                        function = TenBiddingExportUtil.getExceptIdFormula(dataField, cell);
                        cell.setCellFormula(function);
                        continue block47;
                    }
                    case "bd_taxrate": {
                        cell.setCellStyle(nolockedStyle);
                        bdTaxRate = dynamicObject.getDynamicObject(dataField[j]);
                        String cellValue = "";
                        if (bdTaxRate != null) {
                            cellValue = bdTaxRate.getString("name");
                        }
                        cell.setCellValue(cellValue);
                        continue block47;
                    }
                    case "taxrate": {
                        if (BidTypeEnum.MATERIAL.getValue().equals(bidType) || BidTypeEnum.RESOURCE.getValue().equals(bidType)) {
                            cell.setCellStyle(commonAlterableStyle);
                            function = TenBiddingExportUtil.getExceptTaxRate(dataField, cell);
                            cell.setCellFormula(function);
                            continue block47;
                        }
                        cell.setCellStyle(nolockedStyle);
                        if (dynamicObject.getBigDecimal(dataField[j]).compareTo(BigDecimal.ZERO) > 0) {
                            doubleValue = dynamicObject.getBigDecimal(dataField[j]).setScale(2, 4).doubleValue();
                        }
                        cell.setCellValue(doubleValue.doubleValue());
                        continue block47;
                    }
                    case "qty": {
                        cell.setCellStyle(commonAlterableStyle);
                        if (dynamicObject.getBigDecimal(dataField[j]).compareTo(BigDecimal.ZERO) > 0) {
                            DynamicObject baseunit = dynamicObject.getDynamicObject("baseunit");
                            value = baseunit != null ? dynamicObject.getBigDecimal(dataField[j]).setScale(baseunit.getInt("precision"), 4).toString() : dynamicObject.getBigDecimal(dataField[j]).setScale(4, 4).toString();
                        }
                        cell.setCellValue(value);
                        continue block47;
                    }
                    case "taxamount": {
                        function = TenBiddingExportUtil.getTaxamount(dataField, cell, amtPrecision);
                        alterableStyle.setDataFormat(format.getFormat(amtPrecisionScaleStr));
                        cell.setCellStyle(alterableStyle);
                        cell.setCellFormula(function);
                        continue block47;
                    }
                    case "excepttaxamount": {
                        function = TenBiddingExportUtil.getExcepttAxamount(dataField, cell, amtPrecision);
                        alterableStyle.setDataFormat(format.getFormat(amtPrecisionScaleStr));
                        cell.setCellStyle(alterableStyle);
                        cell.setCellFormula(function);
                        continue block47;
                    }
                }
            }
        }
    }

    public static void createDataDropDownListSheet(SXSSFSheet sheet, SXSSFWorkbook wb, String newSheetName, int columnIndex) {
        Name categoryName = wb.getName(newSheetName);
        if (null == categoryName) {
            SXSSFSheet hiddenSheet = wb.createSheet(newSheetName);
            int hiddenSheetIndex = wb.getSheetIndex(newSheetName);
            hiddenSheet.enableLocking();
            TenBiddingExportUtil.setTaxRateData(hiddenSheet);
            categoryName = wb.createName();
            categoryName.setNameName(newSheetName);
            categoryName.setRefersToFormula(newSheetName + "!$A$1:" + newSheetName + "!$A$500");
            wb.setSheetHidden(hiddenSheetIndex, true);
            TenBiddingExportUtil.dataValidate(sheet, newSheetName, columnIndex);
        }
    }

    public static void setTaxRateData(SXSSFSheet hiddenSheet) {
        Map<String, DynamicObject> taxRateMap = TenBiddingExportUtil.getTaxRates();
        int i = 0;
        for (Map.Entry<String, DynamicObject> taxRateMapData : taxRateMap.entrySet()) {
            SXSSFRow newRow = hiddenSheet.createRow(i);
            newRow.createCell(0).setCellValue(taxRateMapData.getKey());
            DynamicObject bdTaxRate = taxRateMapData.getValue();
            if (bdTaxRate != null) {
                newRow.createCell(1).setCellValue(bdTaxRate.getBigDecimal("taxrate").doubleValue());
                newRow.createCell(2).setCellValue(bdTaxRate.getPkValue().toString());
            } else {
                newRow.createCell(1).setCellValue(0.0);
                newRow.createCell(2).setCellValue(0.0);
            }
            ++i;
        }
    }

    private static Map<String, DynamicObject> getTaxRates() {
        DynamicObject[] taxrates = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"name,taxrate", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        LinkedHashMap<String, DynamicObject> taxRateMap = new LinkedHashMap<String, DynamicObject>(16);
        for (int i = 0; i < taxrates.length; ++i) {
            DynamicObject taxRate = taxrates[i];
            String taxRateName = taxRate.getString("name");
            taxRateMap.put(taxRateName, taxRate);
        }
        return taxRateMap;
    }

    public static void dataValidate(SXSSFSheet sheet, String newSheetName, int columnIndex) {
        String strFormula = newSheetName + "!$A$1:$A$500";
        XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(1, 65535, columnIndex, columnIndex);
        DataValidationHelper help = sheet.getDataValidationHelper();
        DataValidation validation = help.createValidation((DataValidationConstraint)constraint, cellRangeAddressList);
        validation.createErrorBox(ResManager.loadKDString((String)"\u8f93\u5165\u9519\u8bef\uff0c\u53ea\u80fd\u4e0b\u62c9\u9009\u62e9\u3002", (String)"TenBiddingExportUtil_11", (String)"scm-ten-formplugin", (Object[])new Object[0]), "");
        validation.setEmptyCellAllowed(true);
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    protected static String getInclutAxamount(String[] dataField, Cell cell, int pricePrecision, int amtPrecision) {
        String qty = TenBiddingExportUtil.getCellColumn(dataField, "qty");
        String inclutaxprice = TenBiddingExportUtil.getCellColumn(dataField, "inclutaxprice");
        int index = cell.getRowIndex() + 1;
        return "ROUND(ROUND(" + qty + index + ",4)*ROUND(" + inclutaxprice + index + "," + pricePrecision + ")," + amtPrecision + ")";
    }

    protected static String getExceptTaxRate(String[] dataField, Cell cell) {
        String bdTaxRate = TenBiddingExportUtil.getCellColumn(dataField, "bd_taxrate_value");
        int index = cell.getRowIndex() + 1;
        return "ROUND(ROUND(" + bdTaxRate + index + ",2), 2)";
    }

    public static String getExceptValueFormula(String[] dataField, Cell cell) {
        String position = TenBiddingExportUtil.getCellColumn(dataField, "bd_taxrate") + (cell.getRowIndex() + 1);
        return "IFERROR(INDEX(bd_taxrate!A1:B500,MATCH(" + position + ",bd_taxrate!A:A,0),2),0.0)";
    }

    public static String getExceptIdFormula(String[] dataField, Cell cell) {
        String position = TenBiddingExportUtil.getCellColumn(dataField, "bd_taxrate") + (cell.getRowIndex() + 1);
        return "IFERROR(INDEX(bd_taxrate!A1:C500,MATCH(" + position + ",bd_taxrate!A:A,0),3),\"0\")";
    }

    protected static String getExcepttAxamount(String[] dataField, Cell cell, int amtPrecision) {
        String inclutaxamount = TenBiddingExportUtil.getCellColumn(dataField, "inclutaxamount");
        String taxamount = TenBiddingExportUtil.getCellColumn(dataField, "taxamount");
        int index = cell.getRowIndex() + 1;
        return "ROUND(ROUND(" + inclutaxamount + index + "," + amtPrecision + ")-ROUND(" + taxamount + index + "," + amtPrecision + "), " + amtPrecision + ")";
    }

    protected static String getTaxamount(String[] dataField, Cell cell, int amtPrecision) {
        String inclutaxamount = TenBiddingExportUtil.getCellColumn(dataField, "inclutaxamount");
        String taxrate = TenBiddingExportUtil.getCellColumn(dataField, "taxrate");
        int index = cell.getRowIndex() + 1;
        return "ROUND(ROUND(" + inclutaxamount + index + "," + amtPrecision + ")*ROUND(" + taxrate + index + ",2)/100/(1+ROUND(" + taxrate + index + ",2)/100), " + amtPrecision + ")";
    }

    public static String getCellColumn(String[] list, String cellname) {
        String col = "";
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.equals(cellname)) continue;
            col = TenBiddingExportUtil.getColumnIndex(i);
            return col;
        }
        return null;
    }

    public static String getColumnIndex(int i) {
        String str = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z";
        String[] yw = str.split(",");
        if (i <= 25) {
            return yw[i];
        }
        if (i >= 26 && i < 52) {
            return "A" + yw[i -= 26];
        }
        return null;
    }

    public String getCellStringValue(Row row, int index) {
        String value = "";
        Cell cell = row.getCell(index);
        if (cell != null) {
            CellType resultType;
            CellType cellType = cell.getCellType();
            value = cellType.equals((Object)CellType.NUMERIC) ? cell.getNumericCellValue() + "" : (cellType.equals((Object)CellType.FORMULA) ? ((resultType = cell.getCachedFormulaResultType()).equals((Object)CellType.NUMERIC) ? cell.getNumericCellValue() + "" : cell.getStringCellValue()) : cell.getStringCellValue());
        }
        return value;
    }

    public static String getFormatScale(int i) {
        if (i == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0.0");
        for (int k = 1; k < i; ++k) {
            stringBuilder.append("0");
        }
        return stringBuilder.toString();
    }
}

