/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.formplugin.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.ten.formplugin.util.IsIllegalBidUtil;

public class TenderRecordUtil {
    public static void createTenderRecordData(DynamicObject dataEntity, String appId, boolean isTender, List<Map<String, String>> list, Object openId) {
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        DynamicObject supplier = dataEntity.getDynamicObject("supplier");
        if (bidProject == null || supplier == null) {
            return;
        }
        if (list.size() > 0) {
            String ip = IsIllegalBidUtil.getLoginIp();
            for (Map<String, String> map : list) {
                String entityName = "bid".equals(appId) ? "bid_tenderrecord" : "rebm_tenderrecord";
                DynamicObject tenderrecord = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                tenderrecord.set("tender", (Object)RequestContext.get().getCurrUserId());
                tenderrecord.set("ip", (Object)ip);
                tenderrecord.set("operatetime", (Object)new Date());
                tenderrecord.set("supplier", (Object)supplier);
                tenderrecord.set("bidproject", (Object)bidProject);
                tenderrecord.set("type", (Object)(isTender ? "TENDRE" : "WITHDRAW"));
                tenderrecord.set("sectionname", (Object)map.get("name"));
                tenderrecord.set("curbidopenid", openId);
                boolean isIllegal = IsIllegalBidUtil.isIllegalBidInOpen((Long)supplier.getPkValue(), (Long)bidProject.getPkValue(), map.get("name"), ip, entityName);
                tenderrecord.set("isillegalbid", (Object)isIllegal);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tenderrecord});
            }
            String entityName = "bid".equals(appId) ? "bid_iprecord" : "rebm_iprecord";
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject.set("bidproject", (Object)bidProject);
            dynamicObject.set("stage", (Object)(isTender ? "tender" : "recall"));
            dynamicObject.set("supplier", (Object)supplier);
            dynamicObject.set("ip", (Object)ip);
            dynamicObject.set("operationtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void createTenderRecordDataV2(DynamicObject dataEntity, String appId, boolean isTender, List<String> sectionList, DynamicObject[] bidOpenArray) {
        DynamicObject bidProject = dataEntity.getDynamicObject("bidproject");
        DynamicObject supplier = dataEntity.getDynamicObject("supplier");
        if (bidProject == null || supplier == null) {
            return;
        }
        if (!CollectionUtils.isEmpty(sectionList)) {
            String ip = IsIllegalBidUtil.getLoginIp();
            ArrayList<DynamicObject> tenderRecordList = new ArrayList<DynamicObject>();
            for (DynamicObject bidOpen : bidOpenArray) {
                for (String sectionName : sectionList) {
                    String entityName = "bid".equals(appId) ? "bid_tenderrecord" : "rebm_tenderrecord";
                    DynamicObject tenderRecord = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
                    tenderRecord.set("tender", (Object)RequestContext.get().getCurrUserId());
                    tenderRecord.set("ip", (Object)ip);
                    tenderRecord.set("operatetime", (Object)new Date());
                    tenderRecord.set("supplier", (Object)supplier);
                    tenderRecord.set("bidproject", (Object)bidProject);
                    tenderRecord.set("type", (Object)(isTender ? "TENDRE" : "WITHDRAW"));
                    tenderRecord.set("sectionname", (Object)sectionName);
                    tenderRecord.set("curbidopenid", bidOpen.getPkValue());
                    boolean isIllegal = IsIllegalBidUtil.isIllegalBidInOpen((Long)supplier.getPkValue(), (Long)bidProject.getPkValue(), sectionName, ip, entityName);
                    tenderRecord.set("isillegalbid", (Object)isIllegal);
                    tenderRecordList.add(tenderRecord);
                }
            }
            if (!CollectionUtils.isEmpty(tenderRecordList)) {
                DynamicObject[] saveData = new DynamicObject[tenderRecordList.size()];
                SaveServiceHelper.save((DynamicObject[])tenderRecordList.toArray(saveData));
            }
            String entityName = "bid".equals(appId) ? "bid_iprecord" : "rebm_iprecord";
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityName);
            dynamicObject.set("bidproject", (Object)bidProject);
            dynamicObject.set("stage", (Object)(isTender ? "tender" : "recall"));
            dynamicObject.set("supplier", (Object)supplier);
            dynamicObject.set("ip", (Object)ip);
            dynamicObject.set("operationtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }
}

