/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.common.enums.BidBackTypeEnum;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import org.apache.commons.lang.StringUtils;

public class CommonUtil {
    public static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"CommonUtil_0", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"CommonUtil_1", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"CommonUtil_2", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"CommonUtil_3", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"CommonUtil_4", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"CommonUtil_5", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"CommonUtil_6", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"CommonUtil_7", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"CommonUtil_8", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"CommonUtil_9", (String)"scm-ten-common", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"CommonUtil_10", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CommonUtil_11", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CommonUtil_12", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"CommonUtil_13", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CommonUtil_10", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CommonUtil_11", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CommonUtil_12", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"CommonUtil_14", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"CommonUtil_10", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"CommonUtil_11", (String)"scm-ten-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"CommonUtil_12", (String)"scm-ten-common", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                result.append(s1[num]);
                result.append(s2[n - 2 - i]);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }

    public static Date getBackDeadLineDate(String backBidType, Object projectId) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bid_project", (String)"bidopendeadline,techbackbidtime,busbackbidtime");
        if (BidBackTypeEnum.TECHANDBUSS.getValue().equals(backBidType)) {
            return bidProject.getDate("bidopendeadline");
        }
        if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
            return bidProject.getDate("techbackbidtime");
        }
        if (BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
            return bidProject.getDate("busbackbidtime");
        }
        return null;
    }

    public static String getBackDeadLineDateFiled(String backBidType) {
        if (BidBackTypeEnum.TECHANDBUSS.getValue().equals(backBidType)) {
            return "bidopendeadline";
        }
        if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
            return "techbackbidtime";
        }
        if (BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
            return "busbackbidtime";
        }
        return null;
    }

    public static Date getOpenDeadLineDateFiled(DynamicObject bidProject) {
        Date bidOpenDeadLine = null;
        if (bidProject != null) {
            DynamicObject realBidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getLong("id"), (String)"bid_project", (String)"id, bidopentype, bidopentime, techopenbidtime");
            String bidOpenType = realBidProject.getString("bidopentype");
            bidOpenDeadLine = StringUtils.isBlank((String)bidOpenType) || "UNIONOPEN".equals(bidOpenType) ? realBidProject.getDate("bidopentime") : realBidProject.getDate("techopenbidtime");
        }
        return bidOpenDeadLine;
    }

    public static List<String> getUnderTenderSectionList(Object bidProjectId, List<Object> supplierIds) {
        ArrayList<String> result = new ArrayList<String>();
        DynamicObject myTender = BusinessDataServiceHelper.loadSingle((String)"ten_mytender", (String)"entry,projectsection,sectionname,sectionstatus", (QFilter[])new QFilter[]{new QFilter("supplier", "in", supplierIds), new QFilter("bidproject", "=", bidProjectId)});
        if (myTender != null) {
            DynamicObjectCollection tenderEntryCol = myTender.getDynamicObjectCollection("entry");
            for (DynamicObject tenderEntry : tenderEntryCol) {
                String sectionName = tenderEntry.getString("sectionname");
                String sectionStatus = tenderEntry.getString("sectionstatus");
                if (!MyTenderStatus.UNTENDERED.getValue().equals(sectionStatus)) continue;
                result.add(sectionName);
            }
        }
        return result;
    }

    public static boolean checkBidOpenStatus(DynamicObject project, DynamicObject myTender) {
        block8: {
            QFilter billStatusQfilter;
            QFilter projectQfilter;
            String backBidType;
            block9: {
                String bidOpenType;
                block7: {
                    backBidType = myTender.getString("backbidtype");
                    bidOpenType = project.getString("bidopentype");
                    projectQfilter = new QFilter("bidproject.id", "=", project.getPkValue());
                    billStatusQfilter = new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX", "J"});
                    if (!BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenType)) break block7;
                    DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{projectQfilter, billStatusQfilter});
                    for (int i = 0; i < bidOpenArr.length; ++i) {
                        DynamicObject tempOpen = bidOpenArr[i];
                        if (BillStatusEnum.DISBEGIN.getVal().equals(tempOpen.getString("billstatus")) || BillStatusEnum.SAVE.getVal().equals(tempOpen.getString("billstatus"))) continue;
                        return false;
                    }
                    break block8;
                }
                if (!BidBackTypeEnum.TECHANDBUSS.getValue().equals(backBidType)) break block9;
                if (!BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenType)) break block8;
                QFilter openTypeQfilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{projectQfilter, billStatusQfilter, openTypeQfilter});
                for (int i = 0; i < bidOpenArr.length; ++i) {
                    DynamicObject tempOpen = bidOpenArr[i];
                    if (BillStatusEnum.DISBEGIN.getVal().equals(tempOpen.getString("billstatus")) || BillStatusEnum.SAVE.getVal().equals(tempOpen.getString("billstatus"))) continue;
                    return false;
                }
                break block8;
            }
            if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
                QFilter openTypeQfilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{projectQfilter, billStatusQfilter, openTypeQfilter});
                for (int i = 0; i < bidOpenArr.length; ++i) {
                    DynamicObject tempOpen = bidOpenArr[i];
                    if (BillStatusEnum.DISBEGIN.getVal().equals(tempOpen.getString("billstatus")) || BillStatusEnum.SAVE.getVal().equals(tempOpen.getString("billstatus"))) continue;
                    return false;
                }
            } else if (BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType)) {
                QFilter openTypeQfilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                DynamicObject[] bidOpenArr = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)"billstatus,opentype", (QFilter[])new QFilter[]{projectQfilter, billStatusQfilter, openTypeQfilter});
                for (int i = 0; i < bidOpenArr.length; ++i) {
                    DynamicObject tempOpen = bidOpenArr[i];
                    if (BillStatusEnum.DISBEGIN.getVal().equals(tempOpen.getString("billstatus")) || BillStatusEnum.SAVE.getVal().equals(tempOpen.getString("billstatus"))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getSelectProperties(String entityNumber) {
        return CommonUtil.getAllSelectProperties(entityNumber);
    }

    public static String getAllSelectProperties(String entityNumber) {
        HashSet<String> selectors = new HashSet<String>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allEntities = dataEntityType.getAllEntities();
        for (Map.Entry mapData : allEntities.entrySet()) {
            EntityType entityType = (EntityType)mapData.getValue();
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                if (StringUtils.isBlank((String)property.getAlias())) continue;
                selectors.add(property.getName());
            }
        }
        selectors.removeIf(p -> p.endsWith("_id") && selectors.contains(p.substring(0, p.length() - 3)));
        return StringUtils.join(selectors, (char)',');
    }
}

