/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.ten.business.bill.ITenQuestionClarifyService;

public class ITenQuestionClarifyServiceImpl
implements ITenQuestionClarifyService {
    @Override
    public DynamicObject getUnclarifiedData(Object bidprojectId, Object supplierId) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        QFilter isAgainBiddingFilter = new QFilter("is_again_bidding", "!=", (Object)"1");
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifydeadlineFilter, billstatusFilter, isAgainBiddingFilter});
        return clarifyQest;
    }

    @Override
    public Boolean judgeHaveClarifiedData(Object bidprojectId, Object currentSupplierID) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(currentSupplierID + "%"));
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue()).or(new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue())).or(new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.NOCLARIFIED.getValue()));
        QFilter replyFilter = new QFilter("replystatus", "!=", (Object)"B");
        DynamicObject[] clarifyQests = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, billstatusFilter, replyFilter});
        if (clarifyQests.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean judgeHaveClarifiedDataInFailure(Object bidprojectId, Object currentSupplierID) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(currentSupplierID + "%"));
        QFilter supplierlookstatusFilter = new QFilter("supplierlookstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue()).or(new QFilter("supplierlookstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue())).or(new QFilter("supplierlookstatus", "=", (Object)ClarifyStatusEnum.NOCLARIFIED.getValue()));
        DynamicObject[] clarifyQests = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, supplierlookstatusFilter});
        if (clarifyQests.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void refreshCurrentQCListData(Object bidprojectId, Object currentSupplierID) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(currentSupplierID + "%"));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id,billstatus,clarifydeadline", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter});
        if (datas.length > 0) {
            String billstatus = datas[0].getString("billstatus");
            if (ClarifyStatusEnum.INVALID.getValue().equals(billstatus)) {
                return;
            }
        } else {
            return;
        }
        ArrayList<DynamicObject> refreshdatas = new ArrayList<DynamicObject>();
        Date now = new Date();
        for (DynamicObject qc : datas) {
            Date clarifydeadline = qc.getDate("clarifydeadline");
            if (clarifydeadline == null) {
                // empty if block
            }
            if (!now.after(clarifydeadline)) continue;
            String billstatus = qc.getString("billstatus");
            if (!ClarifyStatusEnum.UNCLARIFIED.getValue().equals(billstatus)) continue;
            qc.set("billstatus", (Object)ClarifyStatusEnum.NOCLARIFIED.getValue());
            refreshdatas.add(qc);
        }
        if (!refreshdatas.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])refreshdatas.toArray(new DynamicObject[refreshdatas.size()]));
        }
    }

    @Override
    public Boolean checkClarifyDeadline(Object clarifyId) {
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((Object)clarifyId, (String)"bid_questionclarify", (String)"clarifydeadline");
        Date clarifydeadline = clarifyQest.getDate("clarifydeadline");
        Date now = new Date();
        if (clarifydeadline != null && now.compareTo(clarifydeadline) >= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkClarifyStatus(Object clarifyId) {
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((Object)clarifyId, (String)"bid_questionclarify", (String)"billstatus");
        String billstatus = clarifyQest.getString("billstatus");
        if (!ClarifyStatusEnum.UNCLARIFIED.getValue().equals(billstatus)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

