/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.ten.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.ten.business.bill.IMyTenderService;
import kd.scm.ten.common.util.AppIdUtil;
import kd.scm.ten.common.util.CommonUtil;

public class MyTenderServiceImpl
implements IMyTenderService {
    @Override
    public void refreshMyTenderBiddingStatus(Object supplierId, String appId) {
        DynamicObject[] toUnTenderArr = this.getToUnTenderData(appId, supplierId);
        HashSet<String> unTenderProjectSupplierSectionSet = new HashSet<String>();
        HashSet<Object> unTenderBidProjectIdList = new HashSet<Object>();
        if (toUnTenderArr != null && toUnTenderArr.length > 0) {
            for (DynamicObject dynamicObject : toUnTenderArr) {
                Object bidProjectId = dynamicObject.getDynamicObject("bidproject").getPkValue();
                for (DynamicObject myTenderEntry : dynamicObject.getDynamicObjectCollection("entry")) {
                    if (!myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.PRETENDERED.getValue())) continue;
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
                    String sectionName = myTenderEntry.getString("sectionname");
                    String key = bidProjectId + "_" + (String)sectionName + "_" + supplierId;
                    unTenderProjectSupplierSectionSet.add(key);
                    unTenderBidProjectIdList.add(bidProjectId);
                }
            }
        }
        this.updateMyTenderStatus(toUnTenderArr);
        this.updateBidOpenUnTenderStatus(appId, unTenderProjectSupplierSectionSet, unTenderBidProjectIdList, true);
        DynamicObject[] toPreTenderArr = this.getToPreTenderData(appId, supplierId);
        HashSet<String> preTenderProjectSupplierSectionSet = new HashSet<String>();
        HashSet<Object> preTenderBidProjectSet = new HashSet<Object>();
        if (toPreTenderArr != null && toPreTenderArr.length > 0) {
            for (DynamicObject myTender3 : toPreTenderArr) {
                for (DynamicObject myTenderEntry : myTender3.getDynamicObjectCollection("entry")) {
                    if (!myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNTENDERED.getValue()) || myTenderEntry.getBoolean("untenderflag")) continue;
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
                    Object bidProjectId = myTender3.getDynamicObject("bidproject").getPkValue();
                    String sectionName = myTenderEntry.getString("sectionname");
                    String key = bidProjectId + "_" + sectionName + "_" + supplierId;
                    preTenderProjectSupplierSectionSet.add(key);
                    preTenderBidProjectSet.add(bidProjectId);
                }
            }
        }
        this.updateBidOpenUnTenderStatus(appId, preTenderProjectSupplierSectionSet, preTenderBidProjectSet, false);
        String string = appId.equals("ten") ? "bid_bidpublish" : "rebm_bidpublish";
        DynamicObject[] publishs = BusinessDataServiceHelper.load((String)string, (String)"billno,bidproject,billstatus,bidsection.sectionname,supplierentry.supplier,supplierentry.invalidflag", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "in", preTenderBidProjectSet), new QFilter("billstatus", "=", (Object)"P").or(new QFilter("billstatus", "=", (Object)"C"))});
        HashMap projectSupplierAndInvalidStatus = new HashMap(16);
        for (int i = 0; i < publishs.length; ++i) {
            DynamicObjectCollection bidSectionColl = publishs[i].getDynamicObjectCollection("bidsection");
            DynamicObject bidProject = publishs[i].getDynamicObject("bidproject");
            HashMap<Long, String> supplierAndInvalidStatus = new HashMap<Long, String>();
            for (int j = 0; j < bidSectionColl.size(); ++j) {
                DynamicObjectCollection supplierEntryColl = ((DynamicObject)bidSectionColl.get(j)).getDynamicObjectCollection("supplierentry");
                for (int k = 0; k < supplierEntryColl.size(); ++k) {
                    String invalid = ((DynamicObject)supplierEntryColl.get(k)).getString("invalidflag");
                    DynamicObject supplier = ((DynamicObject)supplierEntryColl.get(k)).getDynamicObject("supplier");
                    if (supplier == null) continue;
                    supplierAndInvalidStatus.put((Long)supplier.getPkValue(), invalid);
                }
            }
            projectSupplierAndInvalidStatus.put((Long)bidProject.getPkValue(), supplierAndInvalidStatus);
        }
        if (toPreTenderArr == null || toPreTenderArr.length == 0) {
            return;
        }
        Map<Object, Object> tenderMap = Arrays.stream(toPreTenderArr).collect(Collectors.toMap(DataEntityBase::getPkValue, myTender -> myTender.getDynamicObject("bidproject").getPkValue(), (v1, v2) -> v1));
        DynamicObject[] bidProjectArr = BusinessDataServiceHelper.load((Object[])tenderMap.values().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_project"));
        Map<Object, DynamicObject> bidProjectMap = Arrays.stream(bidProjectArr).collect(Collectors.toMap(DataEntityBase::getPkValue, item -> item));
        HashMap tenderProjectMap = new HashMap();
        tenderMap.entrySet().forEach(item -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)tenderProjectMap.put(item.getKey(), bidProjectMap.get(item.getValue()));
        });
        for (DynamicObject myTender4 : toPreTenderArr) {
            DynamicObject bidProject = (DynamicObject)tenderProjectMap.get(myTender4.getPkValue());
            if (bidProject == null) continue;
            Map supplierAndInvalidStatusMap = projectSupplierAndInvalidStatus.getOrDefault(bidProject.getPkValue(), new HashMap(0));
            String tenderStatus = myTender4.getString("tenderstatus");
            DynamicObject supplier = myTender4.getDynamicObject("supplier");
            QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
            qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
            boolean isHasOpen = QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])qFilter.toArray());
            if (!supplierAndInvalidStatusMap.isEmpty()) {
                String invalid = (String)supplierAndInvalidStatusMap.get(supplier.getLong("id"));
                if (!StringUtils.isEmpty((CharSequence)invalid) && !"0".equals(invalid)) continue;
                this.setEntrySectionStatus(bidProject, isHasOpen, tenderStatus, myTender4);
                continue;
            }
            this.setEntrySectionStatus(bidProject, isHasOpen, tenderStatus, myTender4);
        }
        this.updateMyTenderStatus(toPreTenderArr);
    }

    public void updateMyTenderStatus(DynamicObject[] toUpdateMyTenderArray) {
        ArrayList<String> sectionStatusList = new ArrayList<String>();
        if (toUpdateMyTenderArray != null && toUpdateMyTenderArray.length > 0) {
            for (DynamicObject myTender : toUpdateMyTenderArray) {
                sectionStatusList.clear();
                DynamicObjectCollection myTenderSectionEntryCol = myTender.getDynamicObjectCollection("entry");
                for (DynamicObject myTenderSectionEntry : myTenderSectionEntryCol) {
                    String sectionStatus = myTenderSectionEntry.getString("sectionstatus");
                    sectionStatusList.add(sectionStatus);
                }
                if (sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue())) {
                    myTender.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
                    continue;
                }
                if (!sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue()) && sectionStatusList.contains(MyTenderStatus.TENDERED.getValue())) {
                    myTender.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
                    continue;
                }
                myTender.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
            }
            SaveServiceHelper.save((DynamicObject[])toUpdateMyTenderArray);
        }
    }

    public void updateBidOpenUnTenderStatus(String appId, Set<String> projectSupplierSectionSet, Set<Object> bidProjectIdList, boolean flag) {
        String selectBidOpenProperties = "id,bidproject,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier, supplierentry.supplier_isinvalid,supplierentry.untenderflag,supplierentry.untendertype,supplierentry.untenderreason, supplierentry.untenderfile";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(AppIdUtil.getBidAppId((String)appId) + "_bidopen"), (String)selectBidOpenProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdList), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})});
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            BizLog.log((String)"\u903e\u671f\u672a\u6295\u6807\uff0c\u5f00\u59cb\u66f4\u65b0\u5f00\u6807\u8868\u5355\u4e0a\u7684\u5f03\u6807\u72b6\u6001");
            for (DynamicObject bidOpen : bidOpenArray) {
                Object bidProjectId = bidOpen.getDynamicObject("bidproject").getPkValue();
                DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionColl) {
                    String sectionName = bidSection.getString("sectionname");
                    DynamicObjectCollection supplierEntryCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCollection) {
                        Object supplierId = supplierEntry.getDynamicObject("supplier").getPkValue();
                        Boolean supplierInvalidFlag = supplierEntry.getBoolean("supplier_isinvalid");
                        String unTenderType = supplierEntry.getString("untendertype");
                        String key = bidProjectId + "_" + sectionName + "_" + supplierId;
                        if (!projectSupplierSectionSet.contains(key) || supplierInvalidFlag.booleanValue()) continue;
                        if (flag) {
                            BizLog.log((String)("\u903e\u671f\u672a\u6295\u6807\uff0c\u66f4\u65b0\u5f00\u6807\u8868\u5355id\uff1a" + bidOpen.getPkValue() + " \u6807\u6bb5\u540d\u79f0\uff1a" + sectionName + " \u4f9b\u5e94\u5546id\uff1a" + supplierId));
                            supplierEntry.set("untendertype", (Object)"1");
                            supplierEntry.set("untenderflag", (Object)Boolean.TRUE);
                            supplierEntry.set("untenderreason", (Object)ResManager.loadKDString((String)"\u903e\u671f\u672a\u6295\u6807", (String)"MyTenderServiceImpl_0", (String)"scm-ten-business", (Object[])new Object[0]));
                            continue;
                        }
                        if (!"1".equals(unTenderType)) continue;
                        BizLog.log((String)("\u66f4\u65b0\u5f03\u6807\u4fe1\u606f\uff0c\u66f4\u65b0\u5f00\u6807\u8868\u5355id\uff1a" + bidOpen.getPkValue() + " \u6807\u6bb5\u540d\u79f0\uff1a" + sectionName + " \u4f9b\u5e94\u5546id\uff1a" + supplierId));
                        supplierEntry.set("untendertype", null);
                        supplierEntry.set("untenderflag", (Object)Boolean.FALSE);
                        supplierEntry.set("untenderreason", null);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])bidOpenArray);
        }
    }

    public DynamicObject[] getToUnTenderData(String appId, Object supplierId) {
        DynamicObject[] toUnTenderArr;
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        ArrayList<QFilter> toUnTenderQFilterList = new ArrayList<QFilter>();
        toUnTenderQFilterList.add(new QFilter("tenderstatus", "=", (Object)MyTenderStatus.PRETENDERED));
        if (supplierId != null) {
            toUnTenderQFilterList.add(new QFilter("supplier", "=", supplierId));
        }
        if (!"ten".equals(appId)) {
            appId = "resp";
        }
        if ((toUnTenderArr = BusinessDataServiceHelper.load((String)(appId + "_mytender"), (String)"id,supplier,backbidtype,bidproject,tenderstatus,entry.id,entry.sectionstatus,entry.sectionname", (QFilter[])toUnTenderQFilterList.toArray(new QFilter[0]))).length > 0) {
            Date date = new Date();
            for (DynamicObject myTender : toUnTenderArr) {
                String backBidType = myTender.getString("backbidtype");
                DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                if (bidProject == null || MyTenderServiceImpl.bidOpenFlag(bidProject)) continue;
                for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                    int compareTo;
                    Date backDeadLineDate = CommonUtil.getBackDeadLineDate((String)backBidType, (Object)bidProject.getPkValue());
                    BizLog.log((String)("\u6295\u6807\u72b6\u6001\u66f4\u65b0\uff0c\u5f85\u6295\u6807\u6570\u636e: " + bidProject.getString("name") + " \u622a\u6b62\u65f6\u95f4\uff1a " + backDeadLineDate));
                    if (backDeadLineDate == null || (compareTo = date.compareTo(backDeadLineDate)) <= 0 || myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
                    BizLog.log((String)("\u6295\u6807\u72b6\u6001\u66f4\u65b0\uff0c\u65b0\u589e\u5f85\u6295\u6807\u6570\u636e: " + myTender.getPkValue()));
                    resultList.add(myTender);
                }
            }
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            resultList.toArray(resultArray);
            return resultArray;
        }
        return null;
    }

    public DynamicObject[] getToPreTenderData(String appId, Object supplierId) {
        DynamicObject[] toUnTenderArr;
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        ArrayList<QFilter> toPreTenderQFilterList = new ArrayList<QFilter>();
        toPreTenderQFilterList.add(new QFilter("tenderstatus", "=", (Object)MyTenderStatus.UNTENDERED));
        if (supplierId != null) {
            toPreTenderQFilterList.add(new QFilter("supplier", "=", supplierId));
        }
        if (!"ten".equals(appId)) {
            appId = "resp";
        }
        if ((toUnTenderArr = BusinessDataServiceHelper.load((String)(appId + "_mytender"), (String)"id,supplier,backbidtype,bidproject,tenderstatus,entry.sectionstatus,entry.sectionname,entry.untenderflag", (QFilter[])toPreTenderQFilterList.toArray(new QFilter[0]))).length > 0) {
            Date date = new Date();
            for (DynamicObject myTender : toUnTenderArr) {
                String backBidType = myTender.getString("backbidtype");
                DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                if (bidProject == null || MyTenderServiceImpl.bidOpenFlag(bidProject)) continue;
                Date backDeadLineDate = CommonUtil.getBackDeadLineDate((String)backBidType, (Object)bidProject.getPkValue());
                BizLog.log((String)("\u6295\u6807\u72b6\u6001\u66f4\u65b0\uff0c\u5f03\u6807\u6570\u636e: " + bidProject.getString("name") + " \u622a\u6b62\u65f6\u95f4\uff1a " + backDeadLineDate));
                if (backDeadLineDate != null) {
                    int compareTo = date.compareTo(backDeadLineDate);
                    if (compareTo >= 0) continue;
                    BizLog.log((String)("\u6295\u6807\u72b6\u6001\u66f4\u65b0\uff0c\u65b0\u589e\u5f85\u5f03\u6807\u6570\u636e\uff1a" + myTender.getPkValue()));
                    resultList.add(myTender);
                    continue;
                }
                QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
                qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
                boolean isHasOpen = QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])qFilter.toArray());
                if (isHasOpen) continue;
                resultList.add(myTender);
            }
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            resultList.toArray(resultArray);
            return resultArray;
        }
        return null;
    }

    public static boolean bidOpenFlag(DynamicObject bidProject) {
        QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
        return QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])qFilter.toArray());
    }

    public void setEntrySectionStatus(DynamicObject bidProject, boolean isHasOpen, String tenderStatus, DynamicObject myTender) {
        block4: {
            Date backDeadLineDate;
            block3: {
                String backBidType = myTender.getString("backbidtype");
                backDeadLineDate = CommonUtil.getBackDeadLineDate((String)backBidType, (Object)bidProject.getPkValue());
                if (backDeadLineDate != null) break block3;
                if (isHasOpen || MyTenderStatus.UNTENDERED.getValue().equals(tenderStatus)) break block4;
                for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                    if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue()) || myTenderEntry.getBoolean("untenderflag")) continue;
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
                }
                break block4;
            }
            Date date = new Date();
            for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue()) || myTenderEntry.getBoolean("untenderflag")) continue;
                int compareTo = date.compareTo(backDeadLineDate);
                if (compareTo < 0) {
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
                    continue;
                }
                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
            }
        }
    }
}

