/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.comptpl;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.pds.common.comptpl.PdsCompTplContext;
import kd.scm.pds.common.comptpl.PdsCompTplServiceImpl;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndQuoteBillCompTplServiceImpl
extends PdsCompTplServiceImpl {
    public void beforeDoOperation(PdsCompTplContext context) {
        String opKey;
        this.initParam(context);
        BeforeDoOperationEventArgs evt = context.getBeforeDoOperationEventArgs();
        Map checkResult = FeatureCheckUtil.checkTndFeature();
        if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
            evt.setCancel(true);
            evt.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
        switch (opKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                long billId = PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue());
                String billNo = this.getModel().getDataEntity().getString("billno");
                QFilter qFilters = new QFilter("billno", "=", (Object)billNo).and("id", "!=", (Object)billId);
                if (QueryServiceHelper.exists((String)"tnd_quotebill", (QFilter[])qFilters.toArray())) {
                    PdsCommonUtils.setBillNo((String)"tnd_quotebill", (DynamicObject)this.getModel().getDataEntity());
                }
                super.beforeDoOperation(context);
                break;
            }
            case "audit": {
                OperationResult result = this.getView().invokeOperation("submit");
                if (result.isSuccess()) break;
                evt.setCancel(true);
                return;
            }
            default: {
                super.beforeDoOperation(context);
            }
        }
    }

    public boolean isShowComponent(String compKey) {
        if (this.isEmpty(compKey)) {
            return false;
        }
        return super.isShowComponent(compKey);
    }

    protected boolean isEmpty(String compKey) {
        boolean isEmpty = false;
        DynamicObject obj = this.getModel().getDataEntity();
        DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
        String entry_entity = "entryentity";
        if ("src_purlist_item".equals(compKey)) {
            entry_entity = "itementity";
        }
        if ("tnd_biddoc_query".equals(compKey)) {
            return false;
        }
        if (null != compDataObj) {
            DynamicObjectCollection cols = compDataObj.getDynamicObjectCollection(entry_entity);
            if (cols.size() == 0) {
                isEmpty = true;
            }
        } else {
            isEmpty = true;
        }
        return isEmpty;
    }
}

