/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndClarifySendMeg
implements IEventServicePlugin {
    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        HashMap<String, List<Long>> userIdMaps = new HashMap<String, List<Long>>(16);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        userIdMaps.put(billId, this.getUserIds(billId, ((EntityEvent)evt).getEntityNumber()));
        return userIdMaps;
    }

    private List<Long> getUserIds(String billId, String entityNumber) {
        DynamicObject configObj;
        ArrayList<Long> userIds = new ArrayList<Long>(16);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityNumber, (String)"project", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(billId))});
        long projectId = obj.getLong("project");
        if (projectId == 0L) {
            return userIds;
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"src_project");
        userIds.add(projectObj.getLong("creator.id"));
        DynamicObject projectManObj = TemplateUtil.getCompData((DynamicObject)projectObj, (String)"src_project_man");
        if (Objects.nonNull(projectManObj)) {
            DynamicObjectCollection rows = projectManObj.getDynamicObjectCollection("entryentity");
            userIds.addAll(rows.stream().filter(row -> this.bizRoleNumber().contains(row.getString("bizrole.number"))).map(row -> row.getLong("bidder.id")).collect(Collectors.toList()));
        }
        if (Objects.nonNull(configObj = TemplateUtil.getCompData((DynamicObject)projectObj, (String)"src_bidopen_config"))) {
            DynamicObjectCollection confRows = configObj.getDynamicObjectCollection("entryentity");
            confRows.forEach(row -> userIds.addAll(MultiBasedataUtils.getBasedataIdSet((DynamicObject)row, (String)"scorer")));
        }
        return userIds.stream().distinct().collect(Collectors.toList());
    }

    private List<String> bizRoleNumber() {
        return Collections.singletonList("SYS001");
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> urlMaps = new HashMap<String, String>(8);
        String billId = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        String operation = ((EntityEvent)evt).getOperation();
        urlMaps.put(billId, this.getUrl(billId, operation));
        return urlMaps;
    }

    protected String getUrl(String billId, String operation) {
        StringBuilder url = new StringBuilder();
        String domainContextUrl = UrlService.getDomainContextUrl();
        String accountId = RequestContext.get().getAccountId();
        url.append(domainContextUrl);
        if (operation.equals("urgemessage")) {
            url.append("?formId=bos_list");
            url.append("&type=list");
            url.append("&billFormId=");
            url.append("src_question");
        } else {
            url.append("?formId=");
            url.append("src_question");
            url.append("&pkId=");
            url.append(Long.parseLong(billId));
        }
        url.append("&accountId=");
        url.append(accountId);
        return url.toString();
    }
}

