/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.extplugin.openapi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.openapi.IQueryList;
import kd.scm.pds.common.extplugin.openapi.QueryContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndApplyUtils;

public class TndApplyQueryListPlugin
implements IQueryList {
    public QFilter getFilter(QueryContext context) {
        QFilter qFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_apply", null, null);
        if (context.isFilterByParams()) {
            QFilter paramfilter = this.buildQfilterByParams(context.getParamMap());
            if (Objects.nonNull(qFilter) && Objects.nonNull(paramfilter)) {
                qFilter.and(paramfilter);
            }
            BizLog.log((String)("###TndApplyQueryListPlugin getFilter:" + paramfilter));
        }
        return qFilter;
    }

    private QFilter buildQfilterByParams(Map<String, Object> paramMap) {
        QFilter qfilter = null;
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            Object paramVal = param.getValue();
            String paramValStr = String.valueOf(paramVal);
            if ("*".equals(paramValStr)) continue;
            QFilter paramFilter = null;
            if ("start_date".equals(param.getKey())) {
                paramFilter = new QFilter("billdate", ">=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("end_date".equals(param.getKey())) {
                paramFilter = new QFilter("billdate", "<=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("search_text".equals(param.getKey())) {
                paramFilter = new QFilter("billno", "match", (Object)paramValStr);
                paramFilter.or("bidname", "match", (Object)paramValStr);
            } else if ("start_stopbiddate".equals(param.getKey())) {
                paramFilter = new QFilter("stopbiddate", ">=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("end_stopbiddate".equals(param.getKey())) {
                paramFilter = new QFilter("stopbiddate", "<=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (null == paramFilter) continue;
            if (null == qfilter) {
                qfilter = paramFilter;
                continue;
            }
            qfilter.and(paramFilter);
        }
        return qfilter;
    }

    public Set<String> getSelectSet(QueryContext context) {
        String selectFields = "id,billno,billstatus,auditdate,modifytime,createtime,parentid,lastupdatetime,billdate,bizstatus,suppliertype,bidname,replydate,tendertype,purdecision,enrollstatus,stopbiddate,ismultipackage,tieredtype,applytime,org.name";
        String[] selectArray = selectFields.split(",");
        HashSet<String> selectSet = new HashSet<String>(selectArray.length);
        for (String field : selectArray) {
            selectSet.add(field.trim());
        }
        return selectSet;
    }

    public String getOrderBys(QueryContext context) {
        return "billdate desc, createtime desc";
    }

    public DynamicObject[] handleQueryData(QueryContext context, DynamicObject[] objs) {
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        ArrayList<Long> projectIds = new ArrayList<Long>(objs.length);
        for (DynamicObject obj : objs) {
            projectIds.add(obj.getLong("id"));
        }
        Set<Long> enrollIds = TndApplyUtils.getEnrollIds(supplierIds, projectIds);
        Set<Long> inviteIds = TndApplyUtils.getInviteIds(supplierIds, projectIds);
        ArrayList<DynamicObject> handleObjs = new ArrayList<DynamicObject>(objs.length);
        Object paramVal = context.getParamMap().get("enrollstatus");
        String paramValStr = String.valueOf(paramVal);
        List enrollStatus = new ArrayList();
        boolean filterEnrollStatus = false;
        if (!"*".equals(paramValStr) && paramVal instanceof List) {
            filterEnrollStatus = true;
            enrollStatus = (List)paramVal;
        }
        for (DynamicObject obj : objs) {
            String enrolStatus = TndApplyUtils.getEnrollStatus(obj, enrollIds, inviteIds, obj.getDate("replydate"), obj.getDate("stopbiddate"));
            if (filterEnrollStatus) {
                if (!enrollStatus.contains(enrolStatus)) continue;
                obj.set("enrollstatus", (Object)enrolStatus);
                handleObjs.add(obj);
                continue;
            }
            obj.set("enrollstatus", (Object)enrolStatus);
            handleObjs.add(obj);
        }
        return handleObjs.toArray(new DynamicObject[0]);
    }
}

