/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.extplugin.openapi;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.openapi.IQueryList;
import kd.scm.pds.common.extplugin.openapi.QueryContext;

public class TndProjectQueryListPlugin
implements IQueryList {
    public QFilter getFilter(QueryContext context) {
        QFilter inviteFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_project", null, null);
        QFilter openFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_apply", null, null);
        QFilter qfilter = inviteFilter.or(openFilter);
        if (context.isFilterByParams()) {
            QFilter paramfilter = this.buildQfilterByParams(context.getParamMap());
            if (Objects.nonNull(qfilter) && Objects.nonNull(paramfilter)) {
                qfilter.and(paramfilter);
            }
            BizLog.log((String)("###TndProjectQueryListPlugin getFilter:" + paramfilter));
        }
        return qfilter;
    }

    private QFilter buildQfilterByParams(Map<String, Object> paramMap) {
        QFilter qfilter = null;
        for (Map.Entry<String, Object> param : paramMap.entrySet()) {
            Object paramVal = param.getValue();
            String paramValStr = String.valueOf(paramVal);
            if ("*".equals(paramValStr)) continue;
            QFilter paramFilter = null;
            if ("start_date".equals(param.getKey())) {
                paramFilter = new QFilter("billdate", ">=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("end_date".equals(param.getKey())) {
                paramFilter = new QFilter("billdate", "<=", (Object)DateUtil.string2date((String)paramValStr, (String)"yyyy-MM-dd HH:mm:ss"));
            } else if ("search_text".equals(param.getKey())) {
                paramFilter = new QFilter("billno", "match", (Object)paramValStr);
                paramFilter.or("bidname", "match", (Object)paramValStr);
            } else if ("billstatus".equals(param.getKey())) {
                paramFilter = paramVal instanceof List ? new QFilter("openstatus", "in", paramVal) : new QFilter("openstatus", "=", paramVal);
            }
            if (null == paramFilter) continue;
            if (null == qfilter) {
                qfilter = paramFilter;
                continue;
            }
            qfilter.and(paramFilter);
        }
        return qfilter;
    }

    public Set<String> getSelectSet(QueryContext context) {
        String selectFields = "id,billno,openstatus,bidname,billdate,org,sourcetype,org.id,sourcetype.id";
        String[] selectArray = selectFields.split(",");
        HashSet<String> selectSet = new HashSet<String>(selectArray.length);
        for (String field : selectArray) {
            selectSet.add(field.trim());
        }
        return selectSet;
    }

    public String getOrderBys(QueryContext context) {
        return "billdate desc, createtime desc";
    }
}

