/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;

public class TndNodeStatusHandlerAptitude
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
        qFilter.and("supplier", "in", (Object)context.getSupplierList());
        context.setFilters(new QFilter[]{qFilter});
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,billno,project.bidname billname,project.aptitudedate aptitudedate,createtime billdate, project.aptitudedate enddate,cfmstatus bizstatus,'' remark,'' biztype";
        context.setSelectFields(selectFields);
        context.setOrderBy("createtime");
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String status = row.getString("bizstatus");
        if (status.equals("C") || status.equals("D")) {
            return status;
        }
        if (row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        return status.equals("A") ? "B" : status;
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        return super.getNodeName(context, row);
    }

    public Date getBillDate(SrcNodeStatusContext context, DynamicObject row) {
        return row.getDate("billdate");
    }
}

