/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;

public class TndNodeStatusHandlerQuestion
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        if (context.isConfirm()) {
            QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
            String supplierField = null;
            supplierField = "bd_supplier".equals(context.getSupplierType()) ? "supplier" : "supplier.supplier";
            QFilter supplierFilter = new QFilter(supplierField, "in", (Object)context.getSupplierList());
            supplierFilter.or("supplierscope.fbasedataid", "in", (Object)context.getSupplierList());
            qFilter.and(supplierFilter);
            context.setFilters(new QFilter[]{qFilter});
        } else {
            context.setFilters(null);
        }
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,project.billno billno,project.bidname billname,createtime billdate, project.stopbiddate enddate,billstatus bizstatus,content remark,publishtype,replycontent,questype biztype,duedate";
        context.setSelectFields(selectFields);
        context.setOrderBy("createtime");
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        String bizType = row.getString("biztype");
        String nodeName = context.getNodeObj().getString("biznode.name");
        if (bizType == null || bizType.trim().equals("")) {
            return nodeName;
        }
        if (bizType.equals("1")) {
            return String.format(ResManager.loadKDString((String)"%1$s(\u6280\u672f)", (String)"TndNodeStatusHandlerQuestion_3", (String)"scm-tnd-common", (Object[])new Object[0]), nodeName);
        }
        if (bizType.equals("2")) {
            return String.format(ResManager.loadKDString((String)"%1$s(\u5546\u52a1)", (String)"TndNodeStatusHandlerQuestion_4", (String)"scm-tnd-common", (Object[])new Object[0]), nodeName);
        }
        return String.format(ResManager.loadKDString((String)"%1$s(\u5176\u4ed6)", (String)"TndNodeStatusHandlerQuestion_5", (String)"scm-tnd-common", (Object[])new Object[0]), nodeName);
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String publishtype = row.getString("publishtype");
        String replycontent = row.getString("replycontent");
        if (publishtype.equals("1") || publishtype.equals("4")) {
            String dateField;
            if (replycontent != null && replycontent.length() > 0) {
                return ProcessStatusEnums.PROCESSED.getValue();
            }
            String string = dateField = null != row.getDataEntityType().getProperties().get((Object)"enddate") ? "enddate" : "duedate";
            if (row.getDate(dateField) != null && row.getDate(dateField).before(TimeServiceHelper.now())) {
                return ProcessStatusEnums.CLOSED.getValue();
            }
            return ProcessStatusEnums.PROCESSING.getValue();
        }
        return ProcessStatusEnums.PROCESSED.getValue();
    }
}

