/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;

public class TndNodeStatusHandlerQuote
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        if (context.isConfirm()) {
            QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
            if ("bd_supplier".equals(context.getSupplierType())) {
                qFilter.and("supplier", "in", (Object)context.getSupplierList());
            } else {
                qFilter.and("supplier.supplier", "in", (Object)context.getSupplierList());
            }
            context.setFilters(new QFilter[]{qFilter});
        } else {
            context.setFilters(null);
        }
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,billno,project.bidname billname,project.planopendate planopendate,billdate, deadline enddate,billstatus bizstatus,'' remark,'' biztype,iscompete,turns,vieturns";
        context.setSelectFields(selectFields);
        context.setOrderBy("billdate");
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String status = row.getString("bizstatus");
        if (status.equals("C") || status.equals("D")) {
            return status;
        }
        if (!row.getBoolean("iscompete") && row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        return status.equals("A") ? "B" : status;
    }

    public String getNodeName(SrcNodeStatusContext context, DynamicObject row) {
        if (row.getBoolean("iscompete")) {
            StringBuilder sb = new StringBuilder().append(ResManager.loadKDString((String)"\u7535\u5b50\u7ade\u4ef7", (String)"TndNodeStatusHandlerQuote_0", (String)"scm-tnd-common", (Object[])new Object[0]));
            sb.append('(').append(QuoteTurnsEnums.getTurnsName((String)row.getString("turns"))).append('_');
            sb.append(VieTurnsEnums.getTurnsName((String)row.getString("vieturns"))).append(')');
            return sb.toString();
        }
        return QuoteTurnsEnums.getTurnsName((String)row.getString("turns"));
    }

    public Date getBillDate(SrcNodeStatusContext context, DynamicObject row) {
        if (row.getBoolean("iscompete") && null != row.getDate("planopendate")) {
            return row.getDate("planopendate");
        }
        return row.getDate("billdate");
    }
}

