/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.nodestatus;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProcessStatusEnums;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;

public class TndNodeStatusHandlerTender
extends SrcNodeStatusHandler {
    private static final long serialVersionUID = 1L;

    public void getNodeStatusFilter(SrcNodeStatusContext context) {
        if (context.isConfirm()) {
            QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
            if ("bd_supplier".equals(context.getSupplierType())) {
                qFilter.and("supplier", "in", (Object)context.getSupplierList());
            } else {
                qFilter.and("supplier.supplier", "in", (Object)context.getSupplierList());
            }
            context.setFilters(new QFilter[]{qFilter});
        } else {
            context.setFilters(null);
        }
    }

    public void getNodeStatusFields(SrcNodeStatusContext context) {
        String selectFields = "id,billno,project.bidname billname,billdate, deadline enddate,billstatus bizstatus,turns remark,'' biztype";
        context.setSelectFields(selectFields);
        context.setOrderBy("billdate");
    }

    public String getBizStatus(SrcNodeStatusContext context, DynamicObject row) {
        String status = row.getString("bizstatus");
        if (status.equals("C") || status.equals("D")) {
            return status;
        }
        if (row.getDate("enddate") != null && row.getDate("enddate").before(TimeServiceHelper.now())) {
            return ProcessStatusEnums.CLOSED.getValue();
        }
        return status.equals("A") ? "B" : status;
    }
}

