/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.question.clarify;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.question.IPdsQuestionHandler;
import kd.scm.pds.common.question.PdsQuestionContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.PdsOrderByUtils;
import kd.scm.pds.common.util.TemplateUtil;

public class TndQuestionClarifyProChg
implements IPdsQuestionHandler {
    private static final long serialVersionUID = 1L;

    public void process(PdsQuestionContext context) {
        if (context.getView().getModel().getDataEntity().getBoolean("isclarify")) {
            this.propertyChanged(context);
        }
    }

    protected void propertyChanged(PdsQuestionContext context) {
        String key;
        switch (key = context.getProChgArgs().getProperty().getName()) {
            case "project": 
            case "package": {
                this.createPurlistEntryData(context);
                break;
            }
        }
    }

    public void createPurlistEntryData(PdsQuestionContext context) {
        long projectId = context.getView().getModel().getDataEntity().getLong("project.id");
        QFilter qfilter = new QFilter("project", "=", (Object)projectId);
        long packageId = context.getView().getModel().getDataEntity().getLong("package.id");
        if (packageId > 0L) {
            qfilter.and("package", "=", (Object)packageId);
        }
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        qfilter.and("supplier", "in", (Object)supplierList);
        Set entryStatus = PdsCommonUtils.buildSet((String[])new String[]{ProjectStatusEnums.QUOTED.getValue()});
        long sourceFlowId = context.getView().getModel().getDataEntity().getLong("project.srctype.id");
        String priceClarifyType = PdsCommonUtils.object2String((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isPriceClarifyAfterBidOpen", (Object)"0", (long)projectId), (String)"0");
        if (!"0".equals(priceClarifyType)) {
            String openStatus = context.getView().getModel().getDataEntity().getString("project.openstatus");
            if (!(BidOpenStatusEnums.NOOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.TECOPEN.getValue().equals(openStatus) || BidOpenStatusEnums.NEGOTIATE.getValue().equals(openStatus))) {
                entryStatus.add(ProjectStatusEnums.OPENED.getValue());
            }
        }
        qfilter.and("entrystatus", "in", (Object)entryStatus);
        if (!QueryServiceHelper.exists((String)"src_purlistf7", (QFilter[])qfilter.toArray())) {
            context.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u62a5\u4ef7\u5355\u3002\u8bf7\u68c0\u67e5\u6d41\u7a0b\u53c2\u6570\uff1a\u7b54\u7591\u6f84\u6e05--\u5f00\u6807\u540e\u5141\u8bb8\u8fdb\u884c\u4ef7\u683c\u6f84\u6e05", (String)"TndQuestionClarifyProChg_0", (String)"scm-tnd-common", (Object[])new Object[0]));
            return;
        }
        String orderBy = PdsOrderByUtils.getOrderByString((String)"orderby001");
        Set excFields = PdsCommonUtils.buildSet((String[])new String[]{"isnew"});
        TemplateUtil.loadCompEntryData((IFormView)context.getView(), (String)"src_purlistf7", (QFilter)qfilter, (Set)excFields, (String)"entryentity", (String)orderBy, (boolean)false);
        this.initEntryNewValue(context);
    }

    public void initEntryNewValue(PdsQuestionContext context) {
        int count = context.getView().getModel().getEntryRowCount("entryentity");
        DynamicObject newObj = context.getView().getModel().getEntryRowEntity("entryentity", 0);
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)newObj);
        context.getView().getModel().beginInit();
        for (int index = 0; index < count; ++index) {
            this.setEntryNewValue(context, properties, index);
        }
        context.getView().getModel().endInit();
        context.getView().updateView("entryentity");
    }

    public void setEntryNewValue(PdsQuestionContext context, List<String> properties, int index) {
        for (String fieldName : properties) {
            if (!fieldName.contains("_new")) continue;
            context.getView().getModel().setValue(fieldName, context.getView().getModel().getValue(fieldName.substring(0, fieldName.lastIndexOf(95) <= 0 ? fieldName.length() : fieldName.lastIndexOf(95)), index), index);
        }
    }
}

