/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class TndInviteLetterUtil {
    public static void confirmInvite(Object inviteLetterid) {
        DynamicObject inviteLetter = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(inviteLetterid.toString()), (String)"tnd_inviteletter");
        inviteLetter.set("cfmstatus", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        inviteLetter.set("cfmdate", (Object)new Date());
        inviteLetter.set("refusenote", (Object)"");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteLetter});
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)inviteLetter.getDynamicObject("project"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)inviteLetter.getDynamicObject("supplier"));
        if (projectId > 0L) {
            TndInviteLetterUtil.rewriteToInviteSupplier(projectId, true, false, "", supplierId);
        }
        TndInviteLetterUtil.updateNoticeSupplier(inviteLetter.getLong("billid"), ConfirmStatusEnum.CONFIRM.getVal(), supplierId);
    }

    public static void refuseInvite(Object inviteLetterid, String refuseNote) {
        DynamicObject inviteLetter = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(inviteLetterid.toString()), (String)"tnd_inviteletter");
        inviteLetter.set("cfmstatus", (Object)ConfirmStatusEnum.REJECT.getVal());
        inviteLetter.set("cfmdate", (Object)new Date());
        inviteLetter.set("refusenote", (Object)refuseNote);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteLetter});
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)inviteLetter.getDynamicObject("project"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)inviteLetter.getDynamicObject("supplier"));
        if (projectId > 0L) {
            TndInviteLetterUtil.rewriteToInviteSupplier(projectId, false, true, refuseNote, supplierId);
        }
        TndInviteLetterUtil.updateNoticeSupplier(inviteLetter.getLong("billid"), ConfirmStatusEnum.REJECT.getVal(), supplierId);
    }

    private static void rewriteToInviteSupplier(long inviteLetterid, boolean isconfirm, boolean isabandon, String abandonreason, long supplierId) {
        String selectFiled = "entrysupplier.suppliertype,entrysupplier.supplier,isconfirm,isabandon,abandonreason";
        QFilter filter = new QFilter("parentid", "=", (Object)String.valueOf(inviteLetterid));
        DynamicObject inviteSupplier = BusinessDataServiceHelper.loadSingle((String)"src_supplier_invite", (String)selectFiled, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection supplierEntryColl = inviteSupplier.getDynamicObjectCollection("entrysupplier");
        for (DynamicObject supplierEntry : supplierEntryColl) {
            long entrySupplierId = SrmCommonUtil.getPkValue((DynamicObject)supplierEntry.getDynamicObject("supplier"));
            if (entrySupplierId != supplierId) continue;
            supplierEntry.set("isconfirm", (Object)isconfirm);
            supplierEntry.set("isabandon", (Object)isabandon);
            supplierEntry.set("abandonreason", (Object)abandonreason);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{inviteSupplier});
        TndInviteLetterUtil.updateInviteSupplier(inviteLetterid, isconfirm, isabandon, abandonreason, supplierId);
    }

    private static void updateNoticeSupplier(long inviteLetterid, String cfmstatus, long supplierId) {
        String selectFiled = "supplierentry.suppliertype,supplierentry.supplier,supplierentry.cfmstatus";
        QFilter filter = new QFilter("id", "=", (Object)inviteLetterid);
        DynamicObject noticesup = BusinessDataServiceHelper.loadSingle((String)"pds_noticesupplier", (String)selectFiled, (QFilter[])new QFilter[]{filter});
        if (noticesup != null) {
            DynamicObjectCollection supplierentryCols = noticesup.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentryCols) {
                long entrySupplierId = SrmCommonUtil.getPkValue((DynamicObject)supplierentry.getDynamicObject("supplier"));
                if (entrySupplierId != supplierId) continue;
                supplierentry.set("cfmstatus", (Object)cfmstatus);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{noticesup});
    }

    private static void updateInviteSupplier(long inviteLetterid, boolean isconfirm, boolean isabandon, String abandonreason, long supplierId) {
        String selectFiled = "suppliertype,supplier,isconfirm,isabandon,abandonreason";
        QFilter filter = new QFilter("entryparentid", "=", (Object)String.valueOf(inviteLetterid));
        filter.or("billid", "=", (Object)inviteLetterid);
        DynamicObject[] supplierCompDatas = BusinessDataServiceHelper.load((String)"src_bidopensupplier", (String)selectFiled, (QFilter[])new QFilter[]{filter});
        if (supplierCompDatas != null && supplierCompDatas.length > 0) {
            ArrayList<DynamicObject> updateSupplier = new ArrayList<DynamicObject>();
            for (int i = 0; i < supplierCompDatas.length; ++i) {
                DynamicObject supplierObject = supplierCompDatas[i];
                long entrySupplierId = SrmCommonUtil.getPkValue((DynamicObject)supplierObject.getDynamicObject("supplier"));
                if (entrySupplierId != supplierId) continue;
                supplierObject.set("isconfirm", (Object)isconfirm);
                supplierObject.set("isabandon", (Object)isabandon);
                supplierObject.set("abandonreason", (Object)abandonreason);
                updateSupplier.add(supplierObject);
            }
            if (updateSupplier != null && updateSupplier.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateSupplier.toArray(new DynamicObject[updateSupplier.size()]));
            }
        }
    }

    public static List<Long> getProjectByConfirmInviteLetter() {
        QFilter inviteFilter = new QFilter("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        List supIdsList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        if (supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString())) {
            inviteFilter.and("supplier", "in", (Object)supIdsList);
        } else {
            inviteFilter.and("supplier.supplier", "in", (Object)supIdsList);
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tnd_inviteletter", (String)"project", (QFilter[])new QFilter[]{inviteFilter});
        List entryIdsList = DynamicObjectUtil.col2ListId((DynamicObjectCollection)cols, (String)"project");
        return entryIdsList;
    }

    public static boolean isInviteLetterConfirm(long projectId) {
        QFilter inviteFilter = new QFilter("project", "=", (Object)projectId).and("cfmstatus", "=", (Object)ConfirmStatusEnum.CONFIRM.getVal());
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        String supType = SupplierUtil.getSupType(null);
        String supFilterPro = SupplierUtil.getSupProBySupType((String)supType);
        inviteFilter.and(supFilterPro, "in", (Object)supplierList);
        return QueryServiceHelper.exists((String)"tnd_inviteletter", (QFilter[])new QFilter[]{inviteFilter});
    }
}

