/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;

public class TndListFilterUtil {
    public static List<Long> getProjectByIsConfirm() {
        return TndListFilterUtil.getProjectByInviteSup(Boolean.TRUE);
    }

    public static List<Long> getProjectByUnConfirm() {
        return TndListFilterUtil.getProjectByInviteSup(Boolean.FALSE);
    }

    public static List<Long> getProjectByInviteSup(Boolean isConfirm) {
        QFilter qfilter = new QFilter("isconfirm", "=", (Object)isConfirm);
        List supIdsList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        qfilter.and(filterSupPro, "in", (Object)supIdsList);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"billid", (QFilter[])qfilter.toArray());
        qfilter.and("ismanualselect", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection inviteRows = QueryServiceHelper.query((String)"src_supplierinvite", (String)"billid", (QFilter[])qfilter.toArray());
        rows.addAll((Collection)inviteRows);
        return rows.stream().map(e -> e.getLong("billid")).distinct().collect(Collectors.toList());
    }

    public static DynamicObjectCollection getDynamicObjectByIsConfirm() {
        QFilter filter = new QFilter("isconfirm", "=", (Object)Boolean.TRUE);
        List supIdsList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(filterSupPro, "in", (Object)supIdsList);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"billid,package", (QFilter[])new QFilter[]{filter});
        return cols;
    }

    public static boolean isConfirm(long projectId) {
        QFilter filter = new QFilter("billid", "=", (Object)projectId).and("isconfirm", "=", (Object)Boolean.TRUE);
        List supplierList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(filterSupPro, "in", (Object)supplierList);
        return QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])new QFilter[]{filter});
    }

    public static void isConfirm(DynamicObject projectObj, SrcNodeStatusContext context) {
        long sourceFlowId = projectObj.getLong("srctypeid.id");
        Object extParamVal = ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isManualSelectSupplier", (Object)Boolean.FALSE, (long)projectObj.getLong("id"));
        boolean isManualSelectSupplier = ExtParameterUtils.convertToBoolen((Object)extParamVal);
        if (isManualSelectSupplier) {
            context.setConfirm(true);
        } else {
            context.setConfirm(TndListFilterUtil.isConfirm(projectObj.getLong("id")));
        }
    }
}

