/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.scm.pds.common.extplugin.IExtendPlugin;
import kd.scm.pds.common.util.SrcExchangeRateUtils;

public class TndQuoteCalculatePrice
implements IExtendPlugin {
    private static final long serialVersionUID = 1L;

    public void process(IFormView view, String viePattern, boolean isSubtract) {
        if (null == viePattern) {
            this.adjustPrice(view, isSubtract);
        } else {
            this.calculatePrice(view, viePattern, isSubtract);
        }
    }

    protected void calculatePrice(IFormView view, String viePattern, boolean isSubtract) {
        BigDecimal priceResult;
        int rowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject purlistObj = view.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (null == purlistObj) {
            return;
        }
        BigDecimal reducePct = BigDecimal.ZERO;
        if (viePattern.equals("2")) {
            reducePct = purlistObj.getBigDecimal("vieratio");
        } else if (viePattern.equals("3")) {
            reducePct = purlistObj.getBigDecimal("viediffer");
        }
        if (isSubtract) {
            reducePct = reducePct.negate();
        }
        String priceField = this.getPriceField(view);
        String maxPriceField = this.getMaxPriceField(view);
        BigDecimal price = SrcExchangeRateUtils.calcValue((DynamicObject)purlistObj, (String)maxPriceField, (String)"priceprecision");
        if ("2".equals(viePattern)) {
            reducePct = reducePct.divide(BigDecimal.TEN).divide(BigDecimal.TEN);
            priceResult = price.add(price.multiply(reducePct));
        } else {
            priceResult = price.add(reducePct);
        }
        view.getModel().setValue(priceField, (Object)(priceResult.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : priceResult), rowIndex);
    }

    protected void adjustPrice(IFormView view, boolean isSubtract) {
        BigDecimal priceResult;
        int rowIndex = view.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject purlistObj = view.getModel().getEntryRowEntity("entryentity", rowIndex);
        String reduceType = purlistObj.getString("reducetype");
        BigDecimal reducePct = purlistObj.getBigDecimal("increaseprice");
        if (isSubtract) {
            reducePct = reducePct.negate();
        }
        String priceField = this.getPriceField(view);
        BigDecimal price = purlistObj.getBigDecimal(priceField);
        if ("A".equals(reduceType)) {
            reducePct = reducePct.divide(BigDecimal.TEN).divide(BigDecimal.TEN);
            priceResult = price.add(price.multiply(reducePct));
        } else {
            priceResult = price.add(reducePct);
        }
        view.getModel().setValue(priceField, (Object)(priceResult.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : priceResult), rowIndex);
    }

    private String getPriceField(IFormView view) {
        if ("2".equals(view.getModel().getDataEntity().getString("taxtype"))) {
            return "price";
        }
        return "taxprice";
    }

    private String getMaxPriceField(IFormView view) {
        if ("2".equals(view.getModel().getDataEntity().getString("decisiontype"))) {
            if ("2".equals(view.getModel().getDataEntity().getString("taxtype"))) {
                return "maxamount";
            }
            return "maxtaxamount";
        }
        if ("2".equals(view.getModel().getDataEntity().getString("taxtype"))) {
            return "maxprice";
        }
        return "maxtaxprice";
    }
}

