/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.BizLog;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.vie.IPdsQuoteCommit;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndQuoteCommitToDB;

public class TndQuoteCommitToDB
implements ITndQuoteCommitToDB {
    private static final long serialVersionUID = 1L;

    public IPdsQuoteCommit handleData(PdsVieContext context) {
        return this;
    }

    public void commitData(PdsVieContext context) {
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> quoteObjs = new ArrayList<DynamicObject>(8);
        List properties = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"src_vie_detailf7"));
        Set<String> excFields = this.setExcFields();
        Map hasBidCountMap = PdsVieHelper.getHasBidCountMapByPurlist((PdsVieContext)context);
        int index = 0;
        IDataModel model = context.getView().getModel();
        StringBuilder indexSb = new StringBuilder();
        for (DynamicObject purlistObj : purlistObjs) {
            if (((Boolean)model.getValue("ischanged", index)).booleanValue()) {
                if (!context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid"))) continue;
                this.createQuoteEntry(context, quoteObjs, purlistObj, properties, excFields, hasBidCountMap);
                this.setLastTurnsInfo((AbstractFormDataModel)model, purlistObj, index);
                indexSb.append(index + 1).append(',');
            }
            ++index;
        }
        Object[] result = SaveServiceHelper.save((DynamicObject[])quoteObjs.toArray(new DynamicObject[0]));
        if (result.length > 0) {
            PdsVieHelper.setSupplierCommitData((PdsVieContext)context, (String)"1");
            String indexStr = indexSb.toString().substring(0, indexSb.toString().lastIndexOf(44) <= 0 ? indexSb.toString().length() : indexSb.toString().lastIndexOf(44));
            if ("1".equals(context.getVieTechScheme())) {
                context.setCommitOK(Boolean.TRUE.booleanValue());
                context.setMessage(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u6570\u636e\u63d0\u4ea4\u6210\u529f\uff0c\u63d0\u4ea4\u8bb0\u5f55\u6570(%1$s)\uff0c\u884c\uff1a%2$s", (String)"TndQuoteCommitToDB_3", (String)"scm-tnd-common", (Object[])new Object[0]), result.length, indexStr));
            }
        } else if ("1".equals(context.getVieTechScheme())) {
            context.setCommitOK(Boolean.FALSE.booleanValue());
            context.setMessage(ResManager.loadKDString((String)"\u4f60\u7684\u62a5\u4ef7\u6570\u636e\u672a\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"TndQuoteCommitToDB_1", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
    }

    protected void createQuoteEntry(PdsVieContext context, List<DynamicObject> quoteObjs, DynamicObject purlistObj, List<String> properties, Set<String> excFields, Map<String, Integer> hasBidCountMap) {
        DynamicObject quoteObj = BusinessDataServiceHelper.newDynamicObject((String)"src_vie_detailf7");
        for (String pro : properties) {
            if (excFields.contains(pro)) continue;
            try {
                if (purlistObj.get(pro) instanceof DynamicObject) {
                    quoteObj.set(pro, purlistObj.getDynamicObject(pro).getPkValue());
                    continue;
                }
                quoteObj.set(pro, purlistObj.get(pro));
            }
            catch (Exception e) {
                BizLog.log((String)e.getMessage());
            }
        }
        quoteObj.set("project", (Object)context.getProjectId());
        quoteObj.set("loccurr", (Object)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("currency")));
        quoteObj.set("turns", (Object)context.getTurns());
        quoteObj.set("vieturns", (Object)context.getVieturns());
        String key = purlistObj.getString("supplier.id") + '_' + purlistObj.getString("purlist.id");
        int hasBidCount = null == hasBidCountMap.get(key) ? 0 : hasBidCountMap.get(key);
        quoteObj.set("bidcount", (Object)(hasBidCount + 1));
        int restBidCount = context.getVieBillObj().getInt("bidcount") - hasBidCount - 1;
        quoteObj.set("restofbidcount", (Object)(restBidCount > 0 ? restBidCount : 0));
        quoteObj.set("suppliertype", (Object)"bd_supplier");
        quoteObj.set("entrystatus", (Object)ProjectStatusEnums.QUOTED.getValue());
        quoteObjs.add(quoteObj);
    }

    protected Set<String> setExcFields() {
        HashSet<String> excFields = new HashSet<String>(8);
        excFields.add("billid");
        excFields.add("entryid");
        excFields.add("suppliertype");
        excFields.add("loccurr");
        excFields.add("turns");
        excFields.add("vieturns");
        excFields.add("bidcount");
        excFields.add("ischanged");
        return excFields;
    }

    protected void setLastTurnsInfo(AbstractFormDataModel model, DynamicObject purlistObj, int index) {
        model.setValue("ischanged", (Object)Boolean.FALSE, index);
        model.setValue("lastvieratio", (Object)purlistObj.getBigDecimal("vieratio"), index);
        model.setValue("lastviediffer", (Object)purlistObj.getBigDecimal("viediffer"), index);
        model.setValue("lastprice", (Object)purlistObj.getBigDecimal("price"), index);
        model.setValue("lasttaxprice", (Object)purlistObj.getBigDecimal("taxprice"), index);
        model.setValue("lasttaxitem", (Object)SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("taxitem")), index);
        model.setValue("lastcurrency", (Object)SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("currency")), index);
        model.setValue("restofbidcount2", (Object)(purlistObj.getInt("restofbidcount2") - 1), index);
        model.setValue("lastispresent", (Object)purlistObj.getBoolean("ispresent"), index);
        model.setValue("lastisdiscarded", (Object)purlistObj.getBoolean("isdiscarded"), index);
    }
}

