/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.SrcExchangeRateUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyDataChange
implements ITndQuoteVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return;
        }
        long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj().getDynamicObject("srctype"));
        boolean isviesubmitunchange = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isviesubmitunchange", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getVieBillObj())));
        boolean isDataChanged = Boolean.FALSE;
        int index = 0;
        for (DynamicObject purlistObj : purlistObjs) {
            if (context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid")) && (isviesubmitunchange || this.isDataChanged(purlistObj))) {
                context.getView().getModel().setValue("locprice", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"price", (String)"priceprecision"), index);
                context.getView().getModel().setValue("loctaxprice", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxprice", (String)"priceprecision"), index);
                context.getView().getModel().setValue("locamount", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"amount", (String)"priceprecision"), index);
                context.getView().getModel().setValue("loctaxamount", (Object)SrcExchangeRateUtils.calcLocalValue((DynamicObject)purlistObj, (String)"taxamount", (String)"priceprecision"), index);
                context.getView().getModel().setValue("quotedate", (Object)TimeServiceHelper.now(), index);
                isDataChanged = true;
                context.getView().getModel().setValue("ischanged", (Object)Boolean.TRUE, index);
            }
            ++index;
        }
        if (!isDataChanged) {
            context.setVerify(Boolean.FALSE.booleanValue());
            context.setMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u9009\u4e2d\u62a5\u4ef7\u6570\u636e\uff0c\u6216\u9009\u4e2d\u7684\u62a5\u4ef7\u6570\u636e\u65e0\u53d8\u5316\uff0c\u4e0d\u9700\u8981\u63d0\u4ea4\u3002", (String)"TndQuoteVerifyDataChange_1", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
    }

    protected boolean isDataChanged(DynamicObject purlistObj) {
        if (purlistObj.getBigDecimal("vieratio").compareTo(purlistObj.getBigDecimal("lastvieratio")) != 0) {
            return Boolean.TRUE;
        }
        if (purlistObj.getBigDecimal("viediffer").compareTo(purlistObj.getBigDecimal("lastviediffer")) != 0) {
            return Boolean.TRUE;
        }
        if (purlistObj.getBigDecimal("price").compareTo(purlistObj.getBigDecimal("lastprice")) != 0) {
            return Boolean.TRUE;
        }
        if (purlistObj.getBigDecimal("taxprice").compareTo(purlistObj.getBigDecimal("lasttaxprice")) != 0) {
            return Boolean.TRUE;
        }
        if (SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("taxitem")) != SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("lasttaxitem"))) {
            return Boolean.TRUE;
        }
        if (SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("currency")) != SrmCommonUtil.getPkValue((DynamicObject)purlistObj.getDynamicObject("lastcurrency"))) {
            return Boolean.TRUE;
        }
        if (purlistObj.getBoolean("ispresent") != purlistObj.getBoolean("lastispresent")) {
            return Boolean.TRUE;
        }
        if (purlistObj.getBoolean("isdiscarded") != purlistObj.getBoolean("lastisdiscarded")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

