/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndQuoteVerify;

public class TndQuoteVerifyTendency
implements ITndQuoteVerify {
    private static final long serialVersionUID = 1L;

    public void verifyData(PdsVieContext context) {
        String tendency = context.getVieBillObj().getString("tendency");
        if (null == tendency || "".equals(tendency) || "3".equals(tendency)) {
            return;
        }
        DynamicObjectCollection purlistObjs = context.getView().getModel().getEntryEntity("entryentity");
        if (purlistObjs == null || purlistObjs.size() == 0) {
            return;
        }
        String taxtype = context.getVieBillObj().getString("taxtype");
        StringBuilder sb = new StringBuilder();
        for (DynamicObject purlistObj : purlistObjs) {
            if (!context.getSelectSrcentryIds().contains(purlistObj.getLong("srcentryid")) || purlistObj.getBoolean("isdiscarded") || purlistObj.getBoolean("ispresent")) continue;
            int priceprecision = purlistObj.getInt("currency.priceprecision");
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal hisPrice = BigDecimal.ZERO;
            if ("2".equals(taxtype)) {
                price = purlistObj.getBigDecimal("price");
                hisPrice = purlistObj.getBigDecimal("lastprice");
            } else {
                price = purlistObj.getBigDecimal("taxprice");
                hisPrice = purlistObj.getBigDecimal("lasttaxprice");
            }
            if (hisPrice.compareTo(BigDecimal.ZERO) == 0) continue;
            sb = PdsVieHelper.verifyTendency((StringBuilder)sb, (String)taxtype, (String)tendency, (DynamicObject)purlistObj, (BigDecimal)hisPrice, (BigDecimal)price, (int)priceprecision);
        }
        if (sb.length() > 0) {
            context.setVerify(Boolean.FALSE.booleanValue());
            if ("1".equals(tendency)) {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u672c\u8f6e\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u524d\u4e00\u8f6e\u62a5\u4ef7\uff1a%1$s", (String)"TndQuoteVerifyTendency_0", (String)"scm-tnd-common", (Object[])new Object[0]), sb.toString()));
            } else {
                context.setMessage(String.format(ResManager.loadKDString((String)"\u672c\u8f6e\u62a5\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u524d\u4e00\u8f6e\u62a5\u4ef7\uff1a%1$s", (String)"TndQuoteVerifyTendency_1", (String)"scm-tnd-common", (Object[])new Object[0]), sb.toString()));
            }
        }
    }
}

