/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndQuoteVerify;
import kd.scm.tnd.common.vie.ITndVieCDByRefresh;
import kd.scm.tnd.common.vie.ITndVieInitDynamic;
import kd.scm.tnd.common.vie.ITndVieInitStatic;
import kd.scm.tnd.common.vie.TndQuoteCalculatePrice;
import kd.scm.tnd.common.vie.TndQuotePropertyChange;
import kd.scm.tnd.common.vie.TndVieFactory;

public class TndVieFacade {
    public static void commitQuote(PdsVieContext context) {
        if (context.getVieTechScheme().equals("1")) {
            TndVieFactory.getTndQuoteCommitToDB().handleData(context).commitData(context);
        }
    }

    public static void initVieDynamic(PdsVieContext context) {
        List<ITndVieInitDynamic> tndVieInitDynamics = TndVieFactory.getTndVieInitDynamics();
        for (ITndVieInitDynamic tndVieInitDynamic : tndVieInitDynamics) {
            tndVieInitDynamic.process(context);
        }
    }

    public static void initVieStatic(PdsVieContext context) {
        List<ITndVieInitStatic> tndVieInitStatics = TndVieFactory.getTndVieInitStatics();
        for (ITndVieInitStatic tndVieInitStatic : tndVieInitStatics) {
            tndVieInitStatic.process(context);
        }
    }

    public static void refreshByCountDown(IFormView view) {
        PdsVieContext context = TndVieFactory.createVieContext(view);
        List<ITndVieCDByRefresh> handlers = TndVieFactory.getTndVieCDByRefresh();
        for (ITndVieCDByRefresh handler : handlers) {
            handler.process(context);
        }
    }

    public static void refreshByTimeOut(IFormView view) {
        TndVieFactory.getTndVieCDByTimeOut().process(TndVieFactory.createVieContext(view));
    }

    public static void refreshRank(PdsVieContext context) {
        if (context.getVieTechScheme().equals("1")) {
            TndVieFactory.getTndQuoteRefreshFromDB().getData(context).handleData(context).refreshData(context);
        }
    }

    public static void verifyQuote(PdsVieContext context) {
        TndVieFacade.initSelectSrcentryIds(context);
        context.setVerify(Boolean.TRUE.booleanValue());
        List<ITndQuoteVerify> tndQuoteVerifys = TndVieFactory.getTndQuoteVerifys();
        for (ITndQuoteVerify tndQuoteVerify : tndQuoteVerifys) {
            tndQuoteVerify.verifyData(context);
        }
    }

    public static void initRedisCache(PdsVieContext context) {
        if ((context.getVieTechScheme().equals("2") || context.getVieTechScheme().equals("3")) && PdsVieHelper.isInitializeRedisCache((PdsVieContext)context)) {
            TndVieFactory.getTndRedisUpdateFromDB().getData(context).handleData(context).updateRedis(context);
            PdsVieHelper.allowInitializeRedisCache((PdsVieContext)context, (String)"0");
        }
    }

    public static void propertyChange(IFormView currView, PropertyChangedArgs proChgArgs, ICal cal) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(TndQuotePropertyChange.class.getSimpleName(), TndQuotePropertyChange.class.getName());
        for (TndQuotePropertyChange handler : handlers) {
            handler.process(currView, proChgArgs, cal);
        }
    }

    public static void calculatePrice(IFormView view, String viePattern, boolean isSubtract) {
        List handlers = ExtPluginFactory.getInstance().getExtPluginInstancesSingle(TndQuoteCalculatePrice.class.getSimpleName(), TndQuoteCalculatePrice.class.getName());
        for (TndQuoteCalculatePrice handler : handlers) {
            handler.process(view, viePattern, isSubtract);
        }
    }

    public static void initSelectSrcentryIds(PdsVieContext context) {
        int[] indexs;
        Set<Object> selectSrcentryIds = new HashSet(16);
        if ("1".equals(context.getSubmitType())) {
            DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("entryentity");
            selectSrcentryIds = rows.stream().filter(e -> !e.getBoolean("isdiscarded2")).map(e -> e.getLong("srcentryid")).collect(Collectors.toSet());
            context.setSelectSrcentryIds(selectSrcentryIds);
            return;
        }
        EntryGrid grid = (EntryGrid)context.getView().getControl("entryentity");
        for (int index : indexs = grid.getSelectRows()) {
            DynamicObject row = context.getView().getModel().getEntryRowEntity("entryentity", index);
            if (row.getBoolean("isdiscarded2")) continue;
            selectSrcentryIds.add(row.getLong("srcentryid"));
            if (!"3".equals(context.getSubmitType())) continue;
            context.setSelectSrcentryIds(selectSrcentryIds);
            return;
        }
        context.setSelectSrcentryIds(selectSrcentryIds);
    }
}

