/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsPurlistUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndVieInitStatic;

public class TndVieInitPurlist
implements ITndVieInitStatic {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("supplier", "=", (Object)context.getSupplierId());
        qfilter.and("turns", "=", (Object)context.getTurns());
        Set purListEndIds = PdsPurlistUtils.getPurilstEndIds((long)context.getProjectId());
        if (purListEndIds.size() > 0) {
            qfilter.and("purlist", "not in", (Object)purListEndIds);
        }
        if (context.getVieBillObj().getBoolean("isviepublish")) {
            DynamicObjectCollection billRows = QueryServiceHelper.query((String)"tnd_quotebill", (String)"id", (QFilter[])qfilter.toArray());
            Set parentIds = billRows.stream().map(e -> e.getString("id")).collect(Collectors.toSet());
            QFilter compFilter = new QFilter("parentid", "in", parentIds);
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"src_purlistcomptpl", (String)"id", (QFilter[])compFilter.toArray());
            Set billIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            qfilter.and("billid", "in", billIds);
        }
        if (Objects.equals("2", context.getVieBillObj().getString("managetype"))) {
            QFilter supFilter = new QFilter("billid", "=", (Object)context.getProjectId());
            supFilter.and("supplier", "=", (Object)context.getSupplierId());
            supFilter.and("isdiscard", "=", (Object)true);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"src_bidopensupplier", (String)"package", (QFilter[])supFilter.toArray());
            Set packageIds = cols.stream().map(e -> e.getLong("package")).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(packageIds)) {
                qfilter.and("package", "not in", packageIds);
            }
        }
        qfilter.and("billtype", "=", (Object)"2");
        BizLog.log((String)("###TndVieInitPurlist builderFilter:" + qfilter.toString()));
        PdsVieHelper.loadVieEntryData((PdsVieContext)context, (IFormView)context.getView(), (String)"src_purlistf7", (QFilter)qfilter, this.setExcFields(), (String)"entryentity");
    }

    protected Set<String> setExcFields() {
        HashSet<String> excFields = new HashSet<String>(16);
        excFields.add("rank");
        excFields.add("optimalprice");
        excFields.add("optimaltaxprice");
        excFields.add("optimalamount");
        excFields.add("optimaltaxamount");
        excFields.add("optimalsupplier");
        excFields.add("lastvieratio");
        excFields.add("lastviediffer");
        excFields.add("lastprice");
        excFields.add("lasttaxprice");
        excFields.add("lasttaxitem");
        excFields.add("lastcurrency");
        excFields.add("lastispresent");
        excFields.add("lastisdiscarded");
        excFields.add("locprice");
        excFields.add("loctaxprice");
        excFields.add("locamount");
        excFields.add("loctaxamount");
        excFields.add("note");
        excFields.add("quotedate");
        excFields.add("packagename");
        return excFields;
    }
}

