/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.common.vie;

import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.logging.BizLog;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.enums.VieTurnsEnums;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.ITndVieInitStatic;

public class TndVieInitVieRule
implements ITndVieInitStatic {
    private static final long serialVersionUID = 1L;

    public void process(PdsVieContext context) {
        BizLog.log((String)"###Statrt TndVieInitVieRule process");
        this.setOpendate(context);
        this.setBidtime(context);
        this.setDelaytime(context);
        this.setOpenRank(context);
        this.setTendency(context);
        this.setViePattern(context);
        this.setVieType(context);
        this.setVieTurns(context);
        this.setVieTaxType(context);
        PdsVieHelper.setRestofBidCount((PdsVieContext)context);
        this.setOtherRule(context);
    }

    protected void setOpendate(PdsVieContext context) {
        Date openDate = context.getVieBillObj().getDate("opendate");
        String openDateStr = DateUtil.date2str((Date)openDate, null);
        Label opendateLable = (Label)context.getView().getControl("opendate");
        opendateLable.setText(openDateStr);
    }

    protected void setBidtime(PdsVieContext context) {
        int bidTime = context.getVieBillObj().getInt("bidtime");
        context.setBidtimes(bidTime * 60);
        Label bidtimeLable = (Label)context.getView().getControl("bidtime");
        bidtimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5206\u949f", (String)"TndVieInitVieRule_0", (String)"scm-tnd-common", (Object[])new Object[0]), bidTime));
    }

    protected void setDelaytime(PdsVieContext context) {
        int delaytime = context.getVieBillObj().getInt("delaytime");
        Label delaytimeLable = (Label)context.getView().getControl("delaytime");
        delaytimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u79d2", (String)"TndVieInitVieRule_1", (String)"scm-tnd-common", (Object[])new Object[0]), delaytime));
    }

    protected void setOpenRank(PdsVieContext context) {
        Label open2Lable = (Label)context.getView().getControl("open2");
        boolean isOpenRank = context.getVieBillObj().getBoolean("open2");
        if (isOpenRank) {
            open2Lable.setText(ResManager.loadKDString((String)"\u516c\u5f00\u6392\u540d", (String)"TndVieInitVieRule_2", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else {
            open2Lable.setText(ResManager.loadKDString((String)"\u4e0d\u516c\u5f00\u6392\u540d", (String)"TndVieInitVieRule_3", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
        context.getView().getModel().setValue("isopenrank", (Object)isOpenRank);
    }

    protected void setTendency(PdsVieContext context) {
        Label tendencyLable = (Label)context.getView().getControl("tendency");
        String tendency = context.getVieBillObj().getString("tendency");
        if (tendency.equals("1")) {
            tendencyLable.setText(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u964d\u4ef7", (String)"TndVieInitVieRule_4", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else if (tendency.equals("2")) {
            tendencyLable.setText(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u52a0\u4ef7", (String)"TndVieInitVieRule_5", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else if (tendency.equals("3")) {
            tendencyLable.setText(ResManager.loadKDString((String)"\u5141\u8bb8\u52a0\u4ef7\u6216\u964d\u4ef7", (String)"TndVieInitVieRule_6", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
    }

    protected void setViePattern(PdsVieContext context) {
        String viePattern = context.getViePattern();
        Map viePatternTitleMap = PdsVieHelper.getViePatternTitle((String)viePattern, (String)context.getVieBillObj().getString("taxtype"));
        Label viePatternLable = (Label)context.getView().getControl("labviepattern");
        viePatternLable.setText((String)viePatternTitleMap.get("viepattern"));
        context.getView().getModel().setValue("viepattern", (Object)viePattern);
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        HashMap map = new HashMap();
        map.put("zh_CN", viePatternTitleMap.get("viefrom"));
        entryGrid.setColumnProperty("viefrom", "header", map);
        map = new HashMap();
        map.put("zh_CN", viePatternTitleMap.get("vieto"));
        entryGrid.setColumnProperty("vieto", "header", map);
        String isRegionControl = context.getVieBillObj().getString("isregioncontrol");
        if ("1".equals(isRegionControl)) {
            context.getView().getModel().setValue("isregioncontrol", (Object)true);
        } else {
            context.getView().getModel().setValue("isregioncontrol", (Object)false);
        }
    }

    protected void setVieType(PdsVieContext context) {
        Label vieTypeLable = (Label)context.getView().getControl("vietype");
        String vieType = context.getVieBillObj().getString("vietype");
        String vieratio = "";
        String viediffer = "";
        if (vieType.equals("A")) {
            vieTypeLable.setText(ResManager.loadKDString((String)"\u964d\u4ef7(\u53cd\u5411\u62cd\u5356)", (String)"TndVieInitVieRule_7", (String)"scm-tnd-common", (Object[])new Object[0]));
            vieratio = ResManager.loadKDString((String)"\u2193 \u4e0b\u8c03\u6bd4\u7387(%)", (String)"TndVieInitVieRule_17", (String)"scm-tnd-common", (Object[])new Object[0]);
            viediffer = ResManager.loadKDString((String)"\u2193 \u4e0b\u8c03\u4ef7\u5dee", (String)"TndVieInitVieRule_18", (String)"scm-tnd-common", (Object[])new Object[0]);
        } else if (vieType.equals("B")) {
            vieTypeLable.setText(ResManager.loadKDString((String)"\u52a0\u4ef7(\u6b63\u5411\u62cd\u5356)", (String)"TndVieInitVieRule_8", (String)"scm-tnd-common", (Object[])new Object[0]));
            vieratio = ResManager.loadKDString((String)"\u2191 \u4e0a\u6d6e\u6bd4\u7387(%)", (String)"TndVieInitVieRule_19", (String)"scm-tnd-common", (Object[])new Object[0]);
            viediffer = ResManager.loadKDString((String)"\u2191 \u4e0a\u6d6e\u4ef7\u5dee", (String)"TndVieInitVieRule_20", (String)"scm-tnd-common", (Object[])new Object[0]);
        }
        EntryGrid entryGrid = (EntryGrid)context.getView().getControl("entryentity");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("zh_CN", vieratio);
        entryGrid.setColumnProperty("vieratio", "header", map);
        map = new HashMap();
        map.put("zh_CN", viediffer);
        entryGrid.setColumnProperty("viediffer", "header", map);
    }

    protected void setVieTurns(PdsVieContext context) {
        String turns = context.getTurns();
        String turnsName = QuoteTurnsEnums.getTurnsName((String)turns);
        Label turnsLable = (Label)context.getView().getControl("labturns");
        turnsLable.setText(turnsName);
        context.getView().getModel().setValue("turns", (Object)turns);
        String vieturns = context.getVieturns();
        String vieTurnsName = VieTurnsEnums.getTurnsName((String)vieturns);
        Label vieTurnsLable = (Label)context.getView().getControl("labvieturns");
        vieTurnsLable.setText(vieTurnsName);
        context.getView().getModel().setValue("vieturns", (Object)vieturns);
        BizLog.log((String)("###Statrt TndVieInitVieRule setVieTurns:" + turns));
    }

    protected void setVieTaxType(PdsVieContext context) {
        String taxType = PdsVieHelper.getTaxType((DynamicObject)context.getVieBillObj());
        String decisionType = context.getVieBillObj().getString("decisiontype");
        context.getView().getModel().setValue("taxtype", (Object)taxType);
        Label taxTypeLable = (Label)context.getView().getControl("labtaxtype");
        if ("1".equals(taxType)) {
            taxTypeLable.setText(ResManager.loadKDString((String)"\u5f55\u5165\u542b\u7a0e\u4ef7", (String)"TndVieInitVieRule_9", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else if ("2".equals(taxType)) {
            taxTypeLable.setText(ResManager.loadKDString((String)"\u5f55\u5165\u672a\u7a0e\u4ef7", (String)"TndVieInitVieRule_10", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else {
            taxTypeLable.setText(ResManager.loadKDString((String)"\u4ef7\u5185\u7a0e(\u542b\u7a0e)", (String)"TndVieInitVieRule_11", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
        PdsCommonUtils.setPriceProByTaxType((String)taxType, (String)decisionType, (IFormView)context.getView(), (boolean)true, (boolean)false);
        EntryGrid entry = (EntryGrid)context.getView().getControl("entryentity");
        entry.setMustInput("currency", Boolean.TRUE.booleanValue());
        entry.setMustInput("taxitem", Boolean.TRUE.booleanValue());
        context.getView().getModel().setValue("decisiontype", (Object)PdsVieHelper.getDecisionType((DynamicObject)context.getVieBillObj()));
        context.getView().getModel().setValue("sumtype", (Object)PdsVieHelper.getSumType((DynamicObject)context.getVieBillObj()));
    }

    protected void setOtherRule(PdsVieContext context) {
        String submitType = context.getVieBillObj().getString("submittype");
        Label labSubminType = (Label)context.getView().getControl("labsubmintype");
        if ("1".equals(submitType)) {
            labSubminType.setText(ResManager.loadKDString((String)"\u6240\u6709\u5206\u5f55\u4e00\u8d77\u63d0\u4ea4", (String)"TndVieInitVieRule_21", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else if ("2".equals(submitType)) {
            labSubminType.setText(ResManager.loadKDString((String)"\u63d0\u4ea4\u9009\u4e2d\u5206\u5f55(\u591a\u9009)", (String)"TndVieInitVieRule_22", (String)"scm-tnd-common", (Object[])new Object[0]));
        } else {
            labSubminType.setText(ResManager.loadKDString((String)"\u63d0\u4ea4\u9009\u4e2d\u5206\u5f55(\u5355\u9009)", (String)"TndVieInitVieRule_23", (String)"scm-tnd-common", (Object[])new Object[0]));
        }
    }
}

