/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.scm.common.util.cal.ICal;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcCalImpl;
import kd.scm.pds.common.util.SrcDateUtils;
import kd.scm.pds.common.vie.PdsVieContext;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.tnd.common.vie.TndEnterOrExitVieHallLog;
import kd.scm.tnd.common.vie.TndVieFacade;
import kd.scm.tnd.common.vie.TndVieFactory;

public class TndVieOnlinePlugin
extends AbstractFormPlugin
implements CountDownListener {
    private ICal cal = new SrcCalImpl();

    public void registerListener(EventObject e) {
        CountDown autorefreshCD;
        super.registerListener(e);
        CountDown countdown = (CountDown)this.getControl("countdownap");
        if (countdown != null) {
            countdown.addCountDownListener((CountDownListener)this);
        }
        if ((autorefreshCD = (CountDown)this.getControl("autorefresh_cd")) != null) {
            autorefreshCD.addCountDownListener((CountDownListener)this);
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String projectId = PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"projectid"), (String)"");
        String vieturns = PdsCommonUtils.object2String((Object)PdsCommonUtils.getCustomParamValue((IFormView)this.getView(), (String)"vieturns"), (String)"");
        PdsObjectPools.putInstance((String)PdsCommonUtils.getPageIdKey((IFormView)this.getView().getParentView(), (String)"tnd_quotebill", (String)(projectId + '_' + vieturns)), (Object)this.getView().getPageId());
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        PdsVieHelper.setSupplierOnlineStatus((PdsVieContext)context, (String)SrcDateUtils.getCurrentDateTime(), (boolean)false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initializeData();
        PdsVieHelper.setAutoRefreshTimes((IFormView)this.getView(), (int)this.getModel().getDataEntity().getInt("tndrefreshtimes"));
    }

    public void afterBindData(EventObject e) {
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        TndEnterOrExitVieHallLog handler = (TndEnterOrExitVieHallLog)ExtPluginFactory.getInstance().getExtPluginInstance(TndEnterOrExitVieHallLog.class.getSimpleName());
        if (null != handler) {
            context.setHandleType("initial");
            handler.process(context);
        }
    }

    protected void initializeData() {
        BizLog.log((String)"### TndVieOnlinePlugin initializeData");
        this.setVieBillId();
        PdsVieHelper.setVieParameter((IFormView)this.getView());
        this.refreshData();
    }

    protected void setVieBillId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        long vieBillId = PdsCommonUtils.object2Long(params.get("projectid"));
        this.getView().getModel().setValue("viebill", (Object)vieBillId);
        BizLog.log((String)("### TndVieOnlinePlugin setVieBillId:" + vieBillId));
    }

    public void onCountDownEnd(CountDownEvent countDownEvt) {
        CountDown countDown = (CountDown)countDownEvt.getSource();
        switch (countDown.getKey()) {
            case "autorefresh_cd": {
                TndVieFacade.refreshByCountDown((IFormView)this.getView());
                break;
            }
            case "countdownap": {
                TndVieFacade.refreshByTimeOut((IFormView)this.getView());
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "commit": {
                this.commitData();
                break;
            }
            case "attachment": {
                Map paraMap = this.getView().getFormShowParameter().getCustomParams();
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"tnd_vie_attachment", (ShowType)ShowType.Modal, (Map)paraMap, null);
                break;
            }
            case "analyse": {
                this.analyseQuote();
                break;
            }
            case "refresh": {
                this.refreshData();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            case "add": {
                TndVieFacade.calculatePrice((IFormView)this.getView(), null, (boolean)false);
                break;
            }
            case "sub": {
                TndVieFacade.calculatePrice((IFormView)this.getView(), null, (boolean)true);
                break;
            }
            case "logquery": {
                this.bizLogQuery();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        PdsVieHelper.setSupplierOnlineStatus((PdsVieContext)context, (String)"0", (boolean)false);
        TndEnterOrExitVieHallLog handler = (TndEnterOrExitVieHallLog)ExtPluginFactory.getInstance().getExtPluginInstance(TndEnterOrExitVieHallLog.class.getSimpleName());
        if (null != handler) {
            context.setHandleType("exit");
            handler.process(context);
        }
        PdsCommonUtils.refreshParentView((IFormView)this.getView());
    }

    protected void commitData() {
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        TndVieFacade.verifyQuote((PdsVieContext)context);
        if (context.isVerify()) {
            TndVieFacade.commitQuote((PdsVieContext)context);
            TndVieFacade.refreshRank((PdsVieContext)context);
            TndVieFacade.initVieDynamic((PdsVieContext)context);
        }
        this.initChangeAndSelectStatus();
        if (!StringUtils.isBlank((CharSequence)context.getMessage())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u62a5\u4ef7\u5904\u7406\u7ed3\u679c", (String)"TndVieOnlinePlugin_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]), context.getMessage(), MessageTypes.Default);
        }
    }

    protected void initChangeAndSelectStatus() {
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            this.getModel().setValue("ischanged", (Object)false, i);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.selectRows(-1);
    }

    protected void analyseQuote() {
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        if (context.getSupplierId() > 0L) {
            qfilter.and("supplier", "=", (Object)context.getSupplierId());
        } else {
            qfilter.and("supplier", "in", (Object)PdsCommonUtils.getSupplierByUserOfBizPartner());
        }
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_vieanalyze", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qfilter, null);
    }

    protected void refreshData() {
        BizLog.log((String)"### TndVieOnlinePlugin refreshData");
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        TndVieFacade.initVieStatic((PdsVieContext)context);
        TndVieFacade.initVieDynamic((PdsVieContext)context);
        TndVieFacade.refreshRank((PdsVieContext)context);
        this.getView().updateView("entryentity");
        PdsVieHelper.setSupplierOnlineStatus((PdsVieContext)context, (String)SrcDateUtils.getCurrentDateTime(), (boolean)true);
        BizLog.log((String)("### TndVieOnlinePlugin refreshData end truns=" + (null == context ? null : context.getTurns())));
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        TndVieFacade.propertyChange((IFormView)this.getView(), (PropertyChangedArgs)evt, (ICal)this.cal);
    }

    public void bizLogQuery() {
        PdsVieContext context = TndVieFactory.createVieContext((IFormView)this.getView());
        QFilter qFilter = new QFilter("project", "=", (Object)context.getProjectId());
        qFilter.and("entitykey", "=", (Object)"src_competebill");
        qFilter.and("turns", "=", (Object)context.getTurns());
        OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_bizoperatelog", (ShowType)ShowType.MainNewTabPage, null, (QFilter)qFilter, null);
    }
}

