/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.comp;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SrcDateUtils;

public class TndAptitudeCopyHistory
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public void process(ExtPluginContext context) {
        DynamicObjectCollection rows = context.getView().getModel().getEntryEntity("entryentity");
        context.setSourceObjs((List)rows);
        context.setBillObj(context.getView().getModel().getDataEntity());
        this.getHistoryFilter(context);
        this.getHistoryDataMap(context);
        this.setHistoryDataValue(context);
    }

    public void getHistoryFilter(ExtPluginContext context) {
        Set indexIds = context.getSourceObjs().stream().filter(e -> e.getLong("index.id") > 0L).map(e -> e.getLong("index.id")).collect(Collectors.toSet());
        if (null == indexIds || indexIds.size() == 0) {
            return;
        }
        Date historyDate = SrcDateUtils.getQueryHistoryDate((ExtPluginContext)context);
        long supplierId = context.getBillObj().getLong("supplier.id");
        QFilter qfilters = new QFilter("billid.supplier", "=", (Object)supplierId);
        qfilters.and("billid.cfmstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qfilters.and("billid.auditdate", ">=", (Object)historyDate);
        qfilters.and("index", "in", indexIds);
        qfilters.and("aptitudereply", "!=", (Object)" ");
        context.setQfilters(qfilters);
    }

    public void getHistoryDataMap(ExtPluginContext context) {
        if (null == context.getQfilters()) {
            return;
        }
        String selectFields = "index,aptitudereply,aptitudereply_fj";
        String orderby = "index,billid.auditdate desc";
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_scoretask_indexf7", (String)selectFields, (QFilter[])context.getQfilters().toArray(), (String)orderby);
        context.setObjMap(Arrays.asList(rows).stream().collect(Collectors.groupingBy(e -> e.getLong("index.id"), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0)))));
    }

    public void setHistoryDataValue(ExtPluginContext context) {
        if (null == context.getObjMap() || context.getObjMap().size() == 0) {
            return;
        }
        IDataModel model = context.getView().getModel();
        boolean isSupplier = model.getDataEntity().getBoolean("issupplier");
        int count = model.getEntryEntity("entryentity").getRowCount();
        model.beginInit();
        for (int index = 0; index < count; ++index) {
            DynamicObject indexObj;
            DynamicObject row = model.getEntryRowEntity("entryentity", index);
            String itemType = row.getString("index.itemtype");
            if (isSupplier && !"1".equals(itemType) && !"2".equals(itemType) || !isSupplier && !"1".equals(itemType) && !"3".equals(itemType) && !"4".equals(itemType) || null == (indexObj = (DynamicObject)context.getObjMap().get(row.getLong("index.id")))) continue;
            row.set("aptitudereply", (Object)indexObj.getString("aptitudereply"));
            row.set("aptitudereply_fj", (Object)PdsCommonUtils.cloneAttachment((DynamicObject)indexObj, (String)"aptitudereply_fj"));
        }
        model.endInit();
        context.getView().updateView("entryentity");
    }
}

