/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.util.StringUtils;
import kd.scm.pds.common.nodestatus.SrcNodeStatusData;
import kd.scm.pds.common.util.GridColorStyleUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndProjectTaskUtils;

public class TndProjectTaskEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (data == null) {
            return;
        }
        String billNo = (String)this.getView().getFormShowParameter().getCustomParam("billno");
        List nodeList = SerializationUtils.fromJsonStringToList((String)data, SrcNodeStatusData.class);
        this.loadData(nodeList, billNo);
        this.setGridColor();
    }

    private void loadData(List<SrcNodeStatusData> nodeDataList, String billNo) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        model.deleteEntryData("entryentity");
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int index = 0;
        for (int i = nodeDataList.size() - 1; i >= 0; --i) {
            SrcNodeStatusData nodeData = nodeDataList.get(i);
            ts.set("bizstatus", (Object)nodeData.getBizStatus(), index);
            ts.set("biztype", (Object)nodeData.getNodeName(), index);
            if (StringUtils.isNotEmpty((String)billNo)) {
                ts.set("billno", (Object)billNo, index);
            } else {
                ts.set("billno", (Object)nodeData.getBillNo(), index);
            }
            ts.set("billname", (Object)nodeData.getBillName(), index);
            ts.set("billdate", (Object)nodeData.getBillDate(), index);
            ts.set("enddate", (Object)nodeData.getEndDate(), index);
            ts.set("remark", (Object)nodeData.getRemark(), index);
            ts.set("billid", (Object)nodeData.getBillId(), index);
            ts.set("entityname", (Object)nodeData.getEntityName(), index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void setGridColor() {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        paraMap.put("view", this.getView());
        paraMap.put("entryname", "entryentity");
        paraMap.put("fieldname", "bizstatus");
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("A");
        statusList.add("B");
        paraMap.put("condition", statusList);
        paraMap.put("forecolor", "#276ff5");
        paraMap.put("backcolor", null);
        GridColorStyleUtils.setGridColor(paraMap);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        if ("biztype".equals(fieldName) || "billno".equals(fieldName)) {
            long billId = PdsCommonUtils.object2Long((Object)this.getModel().getValue("billid", rowIndex));
            String entityName = (String)this.getModel().getValue("entityname", rowIndex);
            TndProjectTaskUtils.openProjectTask((IFormView)this.getView(), (String)this.getPluginName(), (String)entityName, (long)billId, (String)fieldName);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals("tnd_project_task")) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
        }
    }
}

